package net.argius.stu.plugin;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.sql.*;

import javax.swing.*;

import net.argius.stu.*;
import net.argius.stu.io.*;

public class JFrameIOManager extends IOManager {
    
    private static final Font font = new Font("Monospaced", Font.PLAIN, 12);
    
    private JFrame frame;
    private JTextField commandLine;
    private JButton submit;
    private JTextArea outputArea;
    private JTextArea messageArea;
    
    private boolean blockerIsAvailable;
    private boolean blocking;
    
    // ͂ubNXbh
    private Thread blocker = new Thread() {
        public void run() {
            while (blockerIsAvailable) {
                if (blocking) {
                    waitMessage();
                }
            }
        }
    };
    
    // s{^Ƃ̃Cxgnh
    private ActionListener onSubmit = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            String s = commandLine.getText();
            if (s.trim().length() == 0) {
                return;
            }
            outputArea.setText("");
            blocking = false;
            blocker.interrupt();
        }
    };
    
    // RXgN^
    public JFrameIOManager() {
        
        // t[
        frame = new JFrame("STU - JFrameIOManager");
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        
        // ̓eLXg{bNX̒`
        JLabel commandLabel = new JLabel("R}h");
        commandLine = new JTextField();
        commandLine.setFont(font);
        commandLine.addActionListener(onSubmit);
        
        // s{^̒`
        submit = new JButton("s");
        submit.setDefaultCapable(true);
        submit.addActionListener(onSubmit);
        
        // o̓GA̒`
        outputArea = new JTextArea();
        outputArea.setFont(font);
        JScrollPane outputPane = new JScrollPane(outputArea);
        
        // bZ[WGA̒`
        messageArea = new JTextArea();
        messageArea.setFont(font);
        JScrollPane messagePane = new JScrollPane(messageArea);
        
        // o̓GAƃbZ[WGÃXvbgyC
        JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        splitPane.setTopComponent(outputPane);
        splitPane.setBottomComponent(messagePane);
        splitPane.setResizeWeight(0.7);
        
        // CAEg
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add(commandLabel, BorderLayout.WEST);
        p1.add(commandLine, BorderLayout.CENTER);
        p1.add(submit, BorderLayout.EAST);
        frame.getContentPane().add(p1, BorderLayout.NORTH);
        frame.getContentPane().add(splitPane, BorderLayout.CENTER);
        
        // ͑҂Xbh̋N
        blocking = true;
        blockerIsAvailable = true;
        blocker.start();
        
        // \
        frame.show();
        frame.setSize(800, 600);
        frame.validate();
        
    }
    
    // ̓XL̃ubN
    private synchronized void waitMessage() {
        while (blocking) {
            try {
                wait();
            } catch (InterruptedException e) {
            }
        }
        notify();
    }
    
    // ͂̃XL
    public String scanLine() throws IOException {
        waitMessage();
        blocking = true;
        return commandLine.getText();
    }
    
    // ʏo͏
    public int showResult(ResultSet rs, int limit) throws IOException, SQLException {
        
        // K{p[^`FbN
        if (rs == null) {
            throw new SQLException("ResultSet is null.");
        }
        // ʕ\̏
        Printer sp = new StringPrinter();
        TableWriter writer = new NullTableWriter();
        ResultSetMetaData md = rs.getMetaData();
        int cols = md.getColumnCount();
        int[] sizes = new int[cols];
        boolean isFirst = true;
        boolean limited = (limit > 0 ? true : false); 
        
        // C[v
        int recordSize = 0;
        try {
            while (rs.next()) {
                if (limited && recordSize >= limit) {
                    break;
                }
                ++recordSize;
                if (isFirst) {
                    // Pڂ̂ݓɃwb_𐶐
                    writer = new PrinterTableWriter(sp, sizes, '-');
                    writer.open();
                    for (int i = 1; i <= cols; i++) {
                        sizes[i-1] = md.getColumnDisplaySize(i);
                        String name = md.getColumnName(i);
                        writer.addColumn(name);
                    }
                    writer.nextRow();
                    isFirst = false;
                }
                // PR[ho
                for (int i = 1; i <= cols; i++) {
                    writer.addColumn(rs.getString(i));
                }
                writer.nextRow();
            }
            outputArea.append(sp.toString());
            return recordSize;
        } finally {
            writer.close();
        }
        
    }
    
    // bZ[W̕\
    public void printMessage(String message, boolean newLine) throws IOException {
        
        messageArea.append(message);
        if (newLine) {
            messageArea.append(IOManager.getLineSeparator());
        }
        
    }
    
}