package net.argius.stu.command;

import java.io.*;
import java.sql.*;

import net.argius.stu.*;
import net.argius.stu.text.*;

public final class Getfunctions extends Command {

    private static final String USAGE = "[ STRING | NUMBER | NUMERIC | DATE | TIME | SYSTEM ]";
    private static final IllegalArgumentException usageError = new IllegalArgumentException(USAGE);

    protected void execute(Connection conn, String parameter)
    	throws IllegalArgumentException, SQLException, IOException {

        StringQueue pq = split(parameter, 3); // Parameter Queue
        pq.draw(); // "GetFunctions"̂Ă
        if (pq.size() == 0) {
            throw usageError;
        }
        String type = pq.draw();

        final String label = "FUNCTIONS : ";
        DatabaseMetaData dbmd = conn.getMetaData();
        if (type.equalsIgnoreCase("STRING")) {
            println(label + dbmd.getStringFunctions());
        } else if (type.equalsIgnoreCase("NUMBER") || type.equalsIgnoreCase("NUMERIC")) {
            println(label + dbmd.getNumericFunctions());
        } else if (type.equalsIgnoreCase("DATE") || type.equalsIgnoreCase("TIME")) {
            println(label + dbmd.getTimeDateFunctions());
        } else if (type.equalsIgnoreCase("SYSTEM")) {
            println(label + dbmd.getSystemFunctions());
        } else {
            throw usageError;
        }

    }

}