package net.argius.stu.plugin;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

import javax.swing.*;

import net.argius.stu.io.*;

public final class GUIOneLinerScanner implements Scanner {

    private JFrame frame;
    private JTextField input;
    private JButton button;
    private boolean blockerIsAvailable;
    private boolean blocking;

    // ͂ƂȂ悤ɃubN
    private Thread blocker = new Thread() {

        public void run() {
            while (blockerIsAvailable) {
                if (blocking) {
                    getInputMessage();
                }
            }
        }
    };

    // {^ꂽ̃Cxgnh
    private ActionListener onSubmit = new ActionListener() {

        public void actionPerformed(ActionEvent e) {
            String s = input.getText();
            if (s != null && s.trim().length() > 0) {
                blocking = false;
                blocker.interrupt();
            }
        }
    };

    public GUIOneLinerScanner() {

        frame = new JFrame("STU - GUIOneLiner");

        input = new JTextField();
        input.setBorder(BorderFactory.createLineBorder(Color.white, 4));

        button = new JButton("s");
        button.setDefaultCapable(true);
        button.addActionListener(onSubmit);

        JPanel panel = new JPanel(new BorderLayout());
        panel.add(input, BorderLayout.CENTER);
        panel.add(button, BorderLayout.EAST);

        frame.getContentPane().add(panel);
        frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        frame.show();
        frame.setSize(800, 80);
        frame.validate();

        blockerIsAvailable = true;
        blocking = true;
        blocker.start();

    }

    public String scan() throws IOException {
        String s = getInputMessage();
        blocking = true;
        return s;
    }

    private synchronized String getInputMessage() {
        while (blocking) {
            try {
                wait();
            } catch (InterruptedException e) {
            }
        }
        notify();
        return input.getText();
    }

    public void close() {
        blockerIsAvailable = false;
        frame.dispose();
    }
}