package net.argius.stu.plugin;

import java.awt.*;

import javax.swing.*;

import net.argius.stu.*;
import net.argius.stu.io.*;

/*
 * VK쐬 : 2005/08/25
 */

/**
 * htgFNX̐
 */
public final class JFramePrinter implements Printer {

    private JFrame frame;
    private JTextArea outputArea;
    
    public JFramePrinter() {
        
        frame = new JFrame("STU - OutputPrinter");
        
        outputArea = new JTextArea();
        outputArea.setFont(new Font("Monospaced", Font.PLAIN, 12));
        JScrollPane outputPane = new JScrollPane(outputArea);
        outputPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        outputPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        outputPane.setViewportBorder(BorderFactory.createLineBorder(Color.white, 4));
        
        frame.getContentPane().add(outputPane);
        frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        frame.show();
        frame.setSize(800, 600);
        frame.validate();
        
    }
    
    public void print(String message) {
        outputArea.append(message);
    }
    
    public void println(String message) {
        outputArea.append(message);
        outputArea.append(IOManager.getLineSeparator()); // s
    }
    
    public void close() {
        frame.dispose();
    }    
}
