package net.argius.stu.command;

import java.io.*;
import java.sql.*;

import net.argius.stu.*;
import net.argius.stu.text.*;

public class Group extends Command {

    private static final String USAGE = "<table> <group list>";
    private static final IllegalArgumentException usageError = new IllegalArgumentException(USAGE);

    protected void execute(Connection conn, String parameter) throws IllegalArgumentException, IOException, SQLException {

        StringQueue pq = split(parameter, -1); // Parameter Queue
        pq.draw(); // "Group"̂Ă
        if (pq.size() <= 0) {
            throw usageError;
        }

        // e[u
        String table = pq.draw();
        // O[vXg
        StringBuffer sb = new StringBuffer();
        for (int i = 0; !pq.isEmpty(); i++) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(pq.draw());
        }
        String group = sb.toString();

        // rpk쐬
        String query = "SELECT " + group + ", count(*) FROM " + table + " GROUP BY " + group;
        println(query);
        writeLog(Log.DEBUG, "query : " + query);

        // rpks
        Statement stmt = conn.createStatement();
        try {
            setTimeout(stmt);
            ResultSet rs = stmt.executeQuery(query);
            try {
                // sʏo
                int recordSize = showResult(rs);
                // bZ[W\
                if (recordSize > 0) {
                    println(getMessage("selected1", String.valueOf(recordSize)));
                } else {
                    println(getMessage("recordnotfound"));
                }
            } finally {
                rs.close();
            }
        } finally {
            stmt.close();
        }

    }

}