/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.sql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import net.argius.stu.io.BinaryStream;
import net.argius.stu.io.CharacterStream;

public final class ResultSetEmulator
implements ResultSet,
ResultSetMetaData {
    private static final String ERROR_COLUMN_RANGE = "out of range.";
    private static final String ERROR_INDEX_IS_ZERO = "row of zero.";
    private static final String ERROR_NOT_SUPPORTED = "not supported.";
    private static final String ERROR_INVALID_COLUMN_NAME = "invalid column name.";
    private static final String ERROR_OBJECT_CLOSED = "object already closed.";
    private static final String ERROR_PARSE = "can't parse.";
    private static final String ERROR_ILLEGAL_ENCODE_TYPE = "illegal encode type.";
    private static final String ENCODE_ASCII = "ASCII";
    private static final String ENCODE_UTF_8 = "UTF-8";
    private static final int DEFAULT_FETCH_SIZE = 1;
    private int sizeOfRows = 0;
    private int currentRow = 0;
    private boolean opened = true;
    private boolean wasNull;
    private int fetchSize = 1;
    private String cursorName = "";
    private List columns = new ArrayList();
    private List names = new ArrayList();
    private List types = new ArrayList();
    private List sizes = new ArrayList();
    private SQLWarning warning;

    public void addColumn(List list, String string, int n, int n2) {
        this.columns.add(list);
        this.names.add(string);
        this.types.add(new Integer(n));
        this.sizes.add(new Integer(n2));
        this.sizeOfRows = this.columns.size() == 1 ? list.size() : (list.size() < this.sizeOfRows ? list.size() : this.sizeOfRows);
    }

    public void close() throws SQLException {
        this.opened = false;
        this.sizeOfRows = 0;
        this.columns.clear();
        this.names.clear();
        this.types.clear();
        this.sizes.clear();
    }

    public boolean first() throws SQLException {
        if (this.sizeOfRows <= 0) {
            return false;
        }
        this.currentRow = 0;
        return true;
    }

    public boolean last() throws SQLException {
        if (this.sizeOfRows <= 0) {
            return false;
        }
        this.currentRow = this.sizeOfRows - 1;
        return true;
    }

    public void beforeFirst() throws SQLException {
        if (this.sizeOfRows > 0) {
            this.currentRow = -1;
        }
    }

    public void afterLast() throws SQLException {
        if (this.sizeOfRows > 0) {
            this.currentRow = this.sizeOfRows;
        }
    }

    public boolean previous() throws SQLException {
        return --this.currentRow >= 0;
    }

    public boolean next() throws SQLException {
        return ++this.currentRow <= this.sizeOfRows;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean absolute(int n) throws SQLException {
        if (n > 0) {
            if (n <= this.sizeOfRows) {
                this.currentRow = n - 1;
                return true;
            }
            this.afterLast();
            return false;
        }
        if (n >= 0) throw new SQLException(ERROR_INDEX_IS_ZERO);
        if (n >= -this.sizeOfRows) {
            this.currentRow = this.sizeOfRows + n;
            return true;
        }
        this.beforeFirst();
        return false;
    }

    public boolean relative(int n) throws SQLException {
        return this.absolute(this.currentRow + 1 + n);
    }

    public int findColumn(String string) throws SQLException {
        if (this.names.contains(string)) {
            return this.names.indexOf(string);
        }
        throw new SQLException(ERROR_INVALID_COLUMN_NAME);
    }

    public String getString(int n) throws SQLException {
        if (!this.opened) {
            throw new SQLException(ERROR_OBJECT_CLOSED);
        }
        if (1 <= n && n <= this.columns.size()) {
            List list = (List)this.columns.get(n - 1);
            Object e = list.get(this.currentRow - 1);
            this.wasNull = e == null;
            return (String)e;
        }
        throw new SQLException(ERROR_COLUMN_RANGE);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    private String getParsableString(int n) throws SQLException {
        String string = this.getString(n);
        if (this.wasNull) {
            return "";
        }
        return string.trim();
    }

    public boolean getBoolean(int n) throws SQLException {
        return Boolean.valueOf(this.getParsableString(n));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        try {
            String string = this.getParsableString(n);
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(numberFormatException.getMessage());
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.getString(n).getBytes();
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        try {
            String string = this.getParsableString(n);
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(ERROR_PARSE);
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public short getShort(int n) throws SQLException {
        try {
            String string = this.getParsableString(n);
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(ERROR_PARSE);
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        try {
            String string = this.getParsableString(n);
            return Long.parseLong(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(ERROR_PARSE);
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLException {
        try {
            String string = this.getParsableString(n);
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(ERROR_PARSE);
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(int n) throws SQLException {
        try {
            String string = this.getParsableString(n);
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(ERROR_PARSE);
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            String string = this.getParsableString(n);
            return new BigDecimal(string);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SQLException(ERROR_PARSE);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            String string = this.getParsableString(n);
            return new BigDecimal(new BigInteger(string), n2);
        }
        catch (ArithmeticException arithmeticException) {
            throw new SQLException(ERROR_PARSE);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public Object getObject(int n) throws SQLException {
        return this.getString(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getString(string);
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    private long getMilliSecond(int n) throws SQLException {
        try {
            SimpleDateFormat simpleDateFormat;
            String string = this.getString(n);
            switch (this.getColumnType(n)) {
                case 91: {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    break;
                }
                case 92: {
                    simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                    break;
                }
                case 93: {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    break;
                }
                default: {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                }
            }
            return simpleDateFormat.parse(string).getTime();
        }
        catch (ParseException parseException) {
            throw new SQLException(ERROR_PARSE);
        }
    }

    public Date getDate(int n) throws SQLException {
        this.getParsableString(n);
        return new Date(this.getMilliSecond(n));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.getParsableString(n);
        return new Date(this.getMilliSecond(n));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        this.getParsableString(n);
        return new Time(this.getMilliSecond(n));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.getParsableString(n);
        return new Time(this.getMilliSecond(n));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.getParsableString(n);
        return new Timestamp(this.getMilliSecond(n));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        try {
            return new URL(this.getString(n));
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException(malformedURLException.getMessage());
        }
    }

    public URL getURL(String string) throws SQLException {
        try {
            String string2 = this.getParsableString(this.findColumn(string));
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException(malformedURLException.getMessage());
        }
    }

    public Blob getBlob(int n) throws SQLException {
        String string = this.getString(n);
        return new PrivateBlob(string);
    }

    public Blob getBlob(String string) throws SQLException {
        String string2 = this.getString(this.findColumn(string));
        return new PrivateBlob(string2);
    }

    public Clob getClob(int n) throws SQLException {
        String string = this.getString(n);
        return new PrivateClob(string);
    }

    public Clob getClob(String string) throws SQLException {
        String string2 = this.getString(this.findColumn(string));
        return new PrivateClob(string2);
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        String string = this.getString(n);
        if (this.wasNull) {
            return null;
        }
        return new ByteArrayInputStream(string.getBytes());
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = string.getBytes(ENCODE_ASCII);
            int n2 = byArray.length;
            BinaryStream binaryStream = new BinaryStream(n2);
            for (int i = 0; i < n2; ++i) {
                binaryStream.write(byArray[i]);
            }
            return binaryStream.getInputStream();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("illegal encode type. : ASCII");
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        String string = this.getString(n);
        if (this.wasNull) {
            return null;
        }
        try {
            byte[] byArray = string.getBytes(ENCODE_UTF_8);
            int n2 = byArray.length;
            BinaryStream binaryStream = new BinaryStream(n2);
            for (int i = 0; i < n2; ++i) {
                binaryStream.write(byArray[i]);
            }
            return binaryStream.getInputStream();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("illegal encode type. : UTF-8");
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (this.wasNull) {
            return null;
        }
        return new StringReader(string);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public void setFetchSize(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.currentRow < 0 && this.sizeOfRows > 0;
    }

    public boolean isFirst() throws SQLException {
        return this.currentRow == 0 && this.sizeOfRows > 0;
    }

    public boolean isLast() throws SQLException {
        return this.currentRow == this.sizeOfRows - 1 && this.sizeOfRows > 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.currentRow >= this.sizeOfRows && this.sizeOfRows > 0;
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public int getRow() throws SQLException {
        if (this.currentRow < 0 || this.currentRow >= this.sizeOfRows) {
            return 0;
        }
        return this.currentRow + 1;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warning;
    }

    public void clearWarnings() throws SQLException {
        this.warning = null;
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void deleteRow() throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateNull(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateNull(String string) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateRow() throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateString(int n, String string) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void insertRow() throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public void refreshRow() throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    public String getColumnName(int n) throws SQLException {
        if (1 <= n && n <= this.names.size()) {
            return (String)this.names.get(n - 1);
        }
        throw new SQLException(ERROR_COLUMN_RANGE);
    }

    public int getColumnType(int n) throws SQLException {
        if (1 <= n && n <= this.types.size()) {
            Integer n2 = (Integer)this.types.get(n - 1);
            return n2;
        }
        throw new SQLException(ERROR_COLUMN_RANGE);
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        if (1 <= n && n <= this.sizes.size()) {
            Integer n2 = (Integer)this.sizes.get(n - 1);
            return n2;
        }
        throw new SQLException(ERROR_COLUMN_RANGE);
    }

    public String getColumnClassName(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case -7: {
                return "java.lang.Boolean";
            }
            case 5: {
                return "java.lang.Short";
            }
            case 4: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 2: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 8: {
                return "java.lang.Double";
            }
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 2003: {
                return "java.sql.Array";
            }
        }
        return "java.lang.Object";
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnTypeName(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getCatalogName(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public int getPrecision(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public int getScale(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public String getSchemaName(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public String getTableName(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean isCurrency(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public int isNullable(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean isReadOnly(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean isSearchable(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean isSigned(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    public boolean isWritable(int n) throws SQLException {
        throw new SQLException(ERROR_NOT_SUPPORTED);
    }

    private static class PrivateClob
    implements Clob {
        private PrintWriter pw;
        private CharacterStream cs = new CharacterStream();
        private static final String ERROR_OVER_LIMIT = "over limit.";

        PrivateClob(String string) {
            this.pw = new PrintWriter(this.cs.getWriter());
            this.pw.println(string);
        }

        PrivateClob(char[] cArray) {
            this.pw = new PrintWriter(this.cs.getWriter());
            this.pw.println(cArray);
        }

        public InputStream getAsciiStream() throws SQLException {
            return this.cs.getInputAsciiStream();
        }

        public Reader getCharacterStream() throws SQLException {
            return this.cs.getReader();
        }

        public String getSubString(long l, int n) throws SQLException {
            if (l > Integer.MAX_VALUE) {
                throw new SQLException(ERROR_OVER_LIMIT);
            }
            int n2 = (int)l;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.cs.read(n2 + i));
            }
            return stringBuffer.toString();
        }

        public long length() throws SQLException {
            return this.cs.length();
        }

        public long position(Clob clob, long l) throws SQLException {
            throw new SQLException(ResultSetEmulator.ERROR_NOT_SUPPORTED);
        }

        public long position(String string, long l) throws SQLException {
            throw new SQLException(ResultSetEmulator.ERROR_NOT_SUPPORTED);
        }

        public OutputStream setAsciiStream(long l) throws SQLException {
            this.cs.setAbsolutePosition(l);
            return this.cs.getOutputAsciiStream();
        }

        public Writer setCharacterStream(long l) throws SQLException {
            this.cs.setAbsolutePosition(l);
            return this.cs.getWriter();
        }

        public int setString(long l, String string, int n, int n2) throws SQLException {
            if (this.cs.length() - l > (long)n2) {
                throw new SQLException("mismatch byte-size.");
            }
            int n3 = 0;
            try {
                this.cs.setAbsolutePosition(l);
                for (int i = n; i < n + n2; ++i) {
                    this.cs.write(string.charAt(i));
                    ++n3;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return n3;
        }

        public int setString(long l, String string) throws SQLException {
            return this.setString(l, string, 0, string.length());
        }

        public void truncate(long l) throws SQLException {
            this.cs.trancate(l);
        }

        public String toString() {
            return this.cs.toString();
        }
    }

    private static class PrivateBlob
    implements Blob {
        private BinaryStream bs = new BinaryStream();

        PrivateBlob(String string) {
            this(string.getBytes());
        }

        PrivateBlob(byte[] byArray) {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                this.bs.write(byArray[i]);
            }
        }

        public InputStream getBinaryStream() throws SQLException {
            return this.bs.getInputStream();
        }

        public byte[] getBytes(long l, int n) throws SQLException {
            try {
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    long l2 = (long)i + l;
                    byArray[i] = this.bs.read(l2);
                }
                return byArray;
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }

        public long length() throws SQLException {
            return this.bs.length();
        }

        public long position(Blob blob, long l) throws SQLException {
            throw new SQLException(ResultSetEmulator.ERROR_NOT_SUPPORTED);
        }

        public long position(byte[] byArray, long l) throws SQLException {
            throw new SQLException(ResultSetEmulator.ERROR_NOT_SUPPORTED);
        }

        public OutputStream setBinaryStream(long l) throws SQLException {
            return this.bs.getOutputStream();
        }

        public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
            if ((long)this.bs.length() - l > (long)n2) {
                throw new SQLException("mismatch byte-size.");
            }
            int n3 = 0;
            try {
                this.bs.setAbsolutePosition(l);
                for (int i = n; i < n + n2; ++i) {
                    this.bs.write(byArray[i]);
                    ++n3;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return n3;
        }

        public int setBytes(long l, byte[] byArray) throws SQLException {
            return this.setBytes(l, byArray, 0, byArray.length);
        }

        public void truncate(long l) throws SQLException {
            this.bs.trancate(l);
        }

        public String toString() {
            return this.bs.toString();
        }
    }
}

