/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class CharacterStream {
    private StringBuffer buffer = new StringBuffer();
    private long position;
    private int size;

    public long length() {
        return this.size;
    }

    public char read(long l) throws ArrayIndexOutOfBoundsException {
        this.validateRange(l);
        return this.buffer.charAt(this.getIntPosition());
    }

    public char read() throws ArrayIndexOutOfBoundsException {
        return this.read(this.position++);
    }

    private void validateRange(long l) throws ArrayIndexOutOfBoundsException {
        if (l < 0L || l >= Integer.MAX_VALUE || l >= this.length()) {
            throw new ArrayIndexOutOfBoundsException("index " + l + ", length " + this.length());
        }
    }

    public void write(char c) {
        this.buffer.append(c);
        ++this.position;
        ++this.size;
    }

    public void trancate(long l) {
        if (l <= Integer.MAX_VALUE) {
            String string = this.buffer.substring(0, (int)l);
            this.buffer = new StringBuffer(string);
        }
    }

    private int getIntPosition() {
        return (int)this.position;
    }

    public long getPosition() {
        return this.position;
    }

    public void setAbsolutePosition(long l) {
        this.validateRange(l);
        this.position = l;
    }

    public void setRelativePosition(int n) {
        long l = this.position + (long)n;
        this.read(l);
        this.position = l;
    }

    public Reader getReader() {
        return new CharacterReader(this);
    }

    public Writer getWriter() {
        return new CharacterWriter(this);
    }

    public InputStream getInputAsciiStream() {
        return new EncodingInputStream(this, "ASCII");
    }

    public OutputStream getOutputAsciiStream() {
        return new EncodingOutputStream(this, "ASCII");
    }

    public String toString() {
        return this.buffer.substring(0, this.size);
    }

    private static class EncodingOutputStream
    extends OutputStream {
        private CharacterStream cs;
        private String encode;
        private boolean cached;
        private byte cache;

        EncodingOutputStream(CharacterStream characterStream, String string) {
            this.cs = characterStream;
            this.encode = string;
        }

        public void write(int n) throws IOException {
            byte by = new Integer(n).byteValue();
            if (this.cached) {
                this.cached = false;
                try {
                    byte[] byArray = new byte[]{this.cache, by};
                    String string = new String(byArray, this.encode);
                    this.cs.write(string.charAt(0));
                }
                catch (RuntimeException runtimeException) {
                    throw new IOException("");
                }
            } else {
                this.cache = by;
                this.cached = true;
            }
        }
    }

    private static class EncodingInputStream
    extends InputStream {
        private CharacterStream cs;
        private String encode;
        private boolean cached;
        private byte cache;

        private EncodingInputStream(CharacterStream characterStream, String string) {
            this.cs = characterStream;
            this.encode = string;
        }

        public int read() throws IOException {
            if (this.cached) {
                this.cached = false;
                return this.cache;
            }
            StringBuffer stringBuffer = new StringBuffer();
            char c = this.cs.read();
            if (c == '\uffffffff') {
                return c;
            }
            stringBuffer.append(c);
            byte[] byArray = stringBuffer.toString().getBytes(this.encode);
            this.cache = byArray[1];
            this.cached = true;
            return byArray[0];
        }
    }

    private static class CharacterWriter
    extends Writer {
        private CharacterStream cs;

        private CharacterWriter(CharacterStream characterStream) {
            this.cs = characterStream;
        }

        public void flush() throws IOException {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            if (this.cs == null) {
                throw new IOException("stream already closed.");
            }
            if (cArray == null) {
                throw new IOException("buffer is not initialized.");
            }
            int n3 = cArray.length;
            for (int i = 0; i < n3 && i < n2; ++i) {
                this.cs.write(cArray[i]);
            }
        }

        public void close() throws IOException {
            this.cs = null;
        }
    }

    private static class CharacterReader
    extends Reader {
        private CharacterStream cs;
        private int pos;

        private CharacterReader(CharacterStream characterStream) {
            this.cs = characterStream;
            this.pos = 0;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.cs == null) {
                throw new IOException("stream already closed.");
            }
            if (cArray == null) {
                throw new IOException("buffer is not initialized.");
            }
            int n3 = (int)(this.cs.length() - (long)this.pos);
            if (n3 == 0) {
                return -1;
            }
            if (n2 > n3 - n) {
                char[] cArray2 = this.cs.toString().substring(this.pos).toCharArray();
                System.arraycopy(cArray2, 0, cArray, n, cArray2.length);
                this.pos = n3;
                return cArray2.length;
            }
            char[] cArray3 = this.cs.toString().substring(this.pos, this.pos + n2).toCharArray();
            System.arraycopy(cArray3, 0, cArray, n, cArray3.length);
            this.pos += n2;
            return n2;
        }

        public void close() throws IOException {
            this.cs = null;
        }
    }
}

