/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.command;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.argius.stu.Command;
import net.argius.stu.sql.LimitEditor;
import net.argius.stu.sql.ResultSetEmulator;
import net.argius.stu.text.StringQueue;
import net.argius.stu.text.Trimmer;

public class Report
extends Command
implements Comparator {
    private static final String USAGE = "- | <table-name> [ PK | INDEX ]";
    private static final IllegalArgumentException usageError = new IllegalArgumentException("- | <table-name> [ PK | INDEX ]");

    protected void execute(Connection connection, String string) throws IllegalArgumentException, SQLException, IOException {
        StringQueue stringQueue = this.split(string, 3);
        stringQueue.draw();
        this.writeLog(4, "input = " + stringQueue);
        if (stringQueue.size() < 1) {
            throw usageError;
        }
        String string2 = stringQueue.draw();
        if (string2.equals("-")) {
            this.showDBInfo(connection);
        } else if (stringQueue.isEmpty()) {
            this.showTableInfo(connection, string2);
        } else {
            String string3 = stringQueue.draw();
            if (string3.equalsIgnoreCase("PK")) {
                this.showPrimaryKeyInfo(connection, string2);
            } else if (string3.equalsIgnoreCase("INDEX")) {
                this.showIndexInfo(connection, string2);
            } else {
                throw new RuntimeException(this.getMessage("illegaloption", string3));
            }
        }
    }

    private void showDBInfo(Connection connection) throws SQLException {
        this.writeLog(4, "report DBInfo");
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        int n = 0;
        int n2 = 0;
        String[] stringArray = new String[5];
        stringArray[n2++] = this.getMessage("report.product.name");
        stringArray[n2++] = this.getMessage("report.product.version");
        stringArray[n2++] = this.getMessage("report.driver.name");
        stringArray[n2++] = this.getMessage("report.driver.version");
        stringArray[n2++] = this.getMessage("report.url");
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = stringArray[i].getBytes().length;
            n = n < n4 ? n4 : n;
        }
        n2 = 0;
        this.print(Trimmer.trim(stringArray[n2++], n), 1);
        this.print("  : ");
        this.println(databaseMetaData.getDatabaseProductName());
        this.print(Trimmer.trim(stringArray[n2++], n), 1);
        this.print("  : ");
        this.println(databaseMetaData.getDatabaseProductVersion());
        this.print(Trimmer.trim(stringArray[n2++], n), 1);
        this.print("  : ");
        this.println(databaseMetaData.getDriverName());
        this.print(Trimmer.trim(stringArray[n2++], n), 1);
        this.print("  : ");
        this.println(databaseMetaData.getDriverVersion());
        this.print(Trimmer.trim(stringArray[n2++], n), 1);
        this.print("  : ");
        this.println(databaseMetaData.getURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTableInfo(Connection connection, String string) throws IOException, SQLException {
        CharSequence charSequence;
        this.writeLog(4, "report Table");
        int n = 0;
        Statement statement = connection.createStatement();
        try {
            this.setTimeout(statement);
            charSequence = new StringBuffer("SELECT * FROM ");
            charSequence.append(string);
            LimitEditor limitEditor = LimitEditor.getLimitEditor(connection);
            String string2 = limitEditor.edit(charSequence.toString(), 1);
            this.writeLog(4, "SQL : " + string2);
            ResultSet resultSet = statement.executeQuery(charSequence.toString());
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                ArrayList<String> arrayList5 = new ArrayList<String>();
                ArrayList<String> arrayList6 = new ArrayList<String>();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= n2; ++i) {
                    arrayList.add(String.valueOf(i));
                    arrayList2.add(" ");
                    arrayList3.add(resultSetMetaData.getColumnName(i));
                    switch (resultSetMetaData.isNullable(i)) {
                        case 0: {
                            arrayList4.add("NO");
                            break;
                        }
                        case 1: {
                            arrayList4.add("YES");
                            break;
                        }
                        case 2: {
                            arrayList4.add("");
                        }
                    }
                    arrayList5.add(resultSetMetaData.getColumnTypeName(i));
                    arrayList6.add(String.valueOf(resultSetMetaData.getColumnDisplaySize(i)));
                }
                ResultSetEmulator resultSetEmulator = new ResultSetEmulator();
                resultSetEmulator.addColumn(arrayList, this.getColumnLabelName("order"), 4, 4);
                resultSetEmulator.addColumn(arrayList2, " ", 1, 1);
                resultSetEmulator.addColumn(arrayList3, this.getColumnLabelName("name"), 1, 16);
                resultSetEmulator.addColumn(arrayList4, this.getColumnLabelName("nullable"), 1, 10);
                resultSetEmulator.addColumn(arrayList5, this.getColumnLabelName("type"), 1, 16);
                resultSetEmulator.addColumn(arrayList6, this.getColumnLabelName("size"), 4, 6);
                n = this.showResult(resultSetEmulator);
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            this.writeLog(1, "failed to get table info.", sQLException);
            throw sQLException;
        }
        finally {
            statement.close();
        }
        if (n > 0) {
            charSequence = String.valueOf(n);
            if (n == 1) {
                this.println(this.getMessage("selected1", charSequence));
            } else {
                this.println(this.getMessage("selected2", charSequence));
            }
        } else {
            this.println(this.getMessage("recordnotfound"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPrimaryKeyInfo(Connection connection, String string) throws IOException, SQLException {
        String[] stringArray;
        String[] stringArray2;
        Object object;
        this.writeLog(4, "report PrimaryKey");
        int n = 0;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (n == 0) {
            object = databaseMetaData.getPrimaryKeys(null, null, string);
            try {
                while (object.next()) {
                    stringArray2 = new String[]{object.getString(5), object.getString(4), object.getString(6)};
                    arrayList.add(stringArray2);
                }
                n = arrayList.size();
                this.writeLog(4, "record : " + n);
            }
            finally {
                object.close();
            }
        }
        if (n == 0 && !string.equals(object = string.toUpperCase())) {
            this.writeLog(4, "re-searching by upper-case.");
            stringArray2 = databaseMetaData.getPrimaryKeys(null, null, (String)object);
            try {
                while (stringArray2.next()) {
                    stringArray = new String[]{stringArray2.getString(5), stringArray2.getString(4), stringArray2.getString(6)};
                    arrayList.add(stringArray);
                }
                n = arrayList.size();
                this.writeLog(4, "record : " + n);
            }
            finally {
                stringArray2.close();
            }
        }
        if (n == 0 && !string.equals(object = string.toLowerCase())) {
            this.writeLog(4, "re-searching by lower-case.");
            stringArray2 = databaseMetaData.getPrimaryKeys(null, null, (String)object);
            try {
                while (stringArray2.next()) {
                    stringArray = new String[]{stringArray2.getString(5), stringArray2.getString(4), stringArray2.getString(6)};
                    arrayList.add(stringArray);
                }
                n = arrayList.size();
                this.writeLog(4, "record : " + n);
            }
            finally {
                stringArray2.close();
            }
        }
        int n2 = 0;
        if (n > 0) {
            Collections.sort(arrayList, this);
            stringArray2 = new ResultSetEmulator();
            stringArray = new ArrayList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                String[] stringArray3 = (String[])arrayList.get(i);
                stringArray.add(stringArray3[0]);
                arrayList2.add(stringArray3[1]);
                arrayList3.add(stringArray3[2]);
            }
            stringArray2.addColumn((List)stringArray, " ", 4, 6);
            stringArray2.addColumn(arrayList2, this.getColumnLabelName("name"), 1, 32);
            stringArray2.addColumn(arrayList3, this.getMessage("label.primarykey.name"), 1, 32);
            n2 = this.showResult((ResultSet)stringArray2);
        }
        if (n2 > 0) {
            stringArray2 = String.valueOf(n2);
            if (n == 1) {
                this.println(this.getMessage("selected1", (Object)stringArray2));
            } else {
                this.println(this.getMessage("selected2", (Object)stringArray2));
            }
        } else {
            this.println(this.getMessage("recordnotfound"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showIndexInfo(Connection connection, String string) throws IOException, SQLException {
        String[] stringArray;
        String[] stringArray2;
        Object object;
        this.writeLog(4, "report Index");
        int n = 0;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (n == 0) {
            object = databaseMetaData.getIndexInfo(null, null, string, false, false);
            try {
                while (object.next()) {
                    stringArray2 = new String[]{object.getString(6), object.getString(8), object.getString(9)};
                    arrayList.add(stringArray2);
                }
                n = arrayList.size();
                this.writeLog(4, "record : " + n);
            }
            finally {
                object.close();
            }
        }
        if (n == 0 && !string.equals(object = string.toUpperCase())) {
            this.writeLog(4, "re-searching by upper-case.");
            stringArray2 = databaseMetaData.getIndexInfo(null, null, (String)object, false, false);
            try {
                while (stringArray2.next()) {
                    stringArray = new String[]{stringArray2.getString(6), stringArray2.getString(8), stringArray2.getString(9)};
                    arrayList.add(stringArray);
                }
                n = arrayList.size();
                this.writeLog(4, "record : " + n);
            }
            finally {
                stringArray2.close();
            }
        }
        if (n == 0 && !string.equals(object = string.toLowerCase())) {
            this.writeLog(4, "re-searching by lower-case.");
            stringArray2 = databaseMetaData.getIndexInfo(null, null, (String)object, false, false);
            try {
                while (stringArray2.next()) {
                    stringArray = new String[]{stringArray2.getString(6), stringArray2.getString(8), stringArray2.getString(9)};
                    arrayList.add(stringArray);
                }
                n = arrayList.size();
                this.writeLog(4, "record : " + n);
            }
            finally {
                stringArray2.close();
            }
        }
        int n2 = 0;
        if (n > 0) {
            Collections.sort(arrayList, this);
            stringArray2 = new ResultSetEmulator();
            stringArray = new ArrayList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                String[] stringArray3 = (String[])arrayList.get(i);
                stringArray.add(stringArray3[0]);
                arrayList2.add(stringArray3[1]);
                arrayList3.add(stringArray3[2]);
            }
            stringArray2.addColumn((List)stringArray, this.getMessage("label.index.name"), 1, 16);
            stringArray2.addColumn(arrayList2, " ", 4, 4);
            stringArray2.addColumn(arrayList3, this.getColumnLabelName("name"), 1, 32);
            n2 = this.showResult((ResultSet)stringArray2);
        }
        if (n2 > 0) {
            stringArray2 = String.valueOf(n2);
            if (n == 1) {
                this.println(this.getMessage("selected1", (Object)stringArray2));
            } else {
                this.println(this.getMessage("selected2", (Object)stringArray2));
            }
        } else {
            this.println(this.getMessage("recordnotfound"));
        }
    }

    private String getColumnLabelName(String string) {
        StringBuffer stringBuffer = new StringBuffer("label.column.");
        stringBuffer.append(string);
        return this.getMessage(stringBuffer.toString());
    }

    public int compare(Object object, Object object2) {
        if (object == null || object2 == null) {
            if (object == object2) {
                return 0;
            }
            return object == null ? -1 : 1;
        }
        String[] stringArray = (String[])object;
        String[] stringArray2 = (String[])object2;
        int n = 0;
        while (stringArray.length > n && stringArray2.length > n) {
            if (stringArray[n] == null) {
                return stringArray2[n] == null ? 0 : 1;
            }
            int n2 = stringArray[n].compareTo(stringArray2[n]);
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return stringArray.length - stringArray2.length;
    }
}

