/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.command;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.argius.stu.Command;
import net.argius.stu.io.CSVTableWriter;
import net.argius.stu.io.HTMLTableWriter;
import net.argius.stu.io.TableWriter;
import net.argius.stu.sql.LimitEditor;
import net.argius.stu.text.StringQueue;

public final class Export
extends Command {
    private static final String USAGE = "<file> [<SELECT-statement>|<table-name>]";
    private static final IllegalArgumentException usageError = new IllegalArgumentException("<file> [<SELECT-statement>|<table-name>]");
    private static final SimpleDateFormat defaultDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final String CSS_URL_PROP_NAME = "net.argius.stu.command.export.css.url";
    private static final String CSS_PATH_PROP_NAME = "net.argius.stu.command.export.css.path";
    private static final String DEFAULT_CSS_FILE_PATH = "/export.default.css";
    private TableWriter writer;
    static /* synthetic */ Class class$net$argius$stu$Application;

    protected void execute(Connection connection, String string) throws IllegalArgumentException, SQLException, IOException {
        StringQueue stringQueue = this.split(string, 2);
        stringQueue.draw();
        this.writeLog(4, "input = " + stringQueue);
        if (stringQueue.size() < 2) {
            throw usageError;
        }
        File file = this.resolvePath(stringQueue.draw());
        String string2 = file.getAbsolutePath();
        String string3 = stringQueue.drawAll();
        this.writer = null;
        this.writeLog(4, "path = " + string2);
        if (string2.toLowerCase().endsWith(".htm") || string2.toLowerCase().endsWith(".html")) {
            Object object;
            boolean bl = false;
            String string4 = this.getProperty(CSS_URL_PROP_NAME);
            if (string4.length() > 0) {
                this.writeLog(4, "css.url : " + string4);
                try {
                    object = new URL(string4);
                    this.writer = new HTMLTableWriter(string3, string2, (URL)object);
                    bl = true;
                }
                catch (MalformedURLException malformedURLException) {
                    this.writeLog(1, "", malformedURLException);
                    bl = false;
                }
            }
            object = this.getProperty(CSS_PATH_PROP_NAME);
            if (!bl && ((String)object).length() > 0) {
                this.writeLog(4, "css,path : " + (String)object);
                this.writer = new HTMLTableWriter(string3, string2, (String)object);
                bl = true;
            }
            if (!bl) {
                URL uRL = (class$net$argius$stu$Application == null ? (class$net$argius$stu$Application = Export.class$("net.argius.stu.Application")) : class$net$argius$stu$Application).getResource(DEFAULT_CSS_FILE_PATH);
                this.writeLog(4, "css : default ( " + uRL + " )");
                this.writer = new HTMLTableWriter(string3, string2, uRL);
            }
        } else {
            this.writer = new CSVTableWriter(string2);
        }
        if (this.isSelect(string3)) {
            this.exportSelectedResult(connection, string3);
        } else {
            String string5 = string3.trim();
            this.exportTableDescription(connection, string5);
        }
        this.println(this.getMessage("exported"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSelectedResult(Connection connection, String string) throws SQLException, IOException {
        Statement statement = connection.createStatement();
        try {
            this.setTimeout(statement);
            ResultSet resultSet = statement.executeQuery(string);
            try {
                int n;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.writer.open();
                int n2 = resultSetMetaData.getColumnCount();
                for (n = 1; n <= n2; ++n) {
                    this.writer.addColumn(resultSetMetaData.getColumnName(n));
                }
                this.writer.nextRow();
                n = 0;
                while (resultSet.next()) {
                    ++n;
                    block11: for (int i = 1; i <= n2; ++i) {
                        switch (resultSetMetaData.getColumnType(i)) {
                            case 91: {
                                Timestamp timestamp = resultSet.getTimestamp(i);
                                if (timestamp == null) {
                                    this.writer.addColumn("");
                                    continue block11;
                                }
                                this.writer.addColumn(defaultDateFormat.format(timestamp));
                                continue block11;
                            }
                            default: {
                                this.writer.addColumn(resultSet.getString(i));
                            }
                        }
                    }
                    this.writer.nextRow();
                }
                if (n > 0) {
                    String string2 = String.valueOf(n);
                    if (n == 1) {
                        this.println(this.getMessage("selected1", string2));
                    } else {
                        this.println(this.getMessage("selected2", string2));
                    }
                } else {
                    this.println(this.getMessage("recordnotfound"));
                }
            }
            finally {
                this.writer.close();
                resultSet.close();
            }
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTableDescription(Connection connection, String string) throws SQLException, IOException {
        CharSequence charSequence;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        int n = 0;
        Statement statement = connection.createStatement();
        try {
            this.setTimeout(statement);
            charSequence = new StringBuffer("SELECT * FROM ");
            charSequence.append(string);
            LimitEditor limitEditor = LimitEditor.getLimitEditor(connection);
            String string2 = limitEditor.edit(charSequence.toString(), 1);
            this.writeLog(4, "SQL : " + string2);
            ResultSet resultSet = statement.executeQuery(charSequence.toString());
            try {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= n2; ++i) {
                    arrayList.add(String.valueOf(i));
                    arrayList2.add(resultSetMetaData.getColumnName(i));
                    switch (resultSetMetaData.isNullable(i)) {
                        case 0: {
                            arrayList3.add("NO");
                            break;
                        }
                        case 1: {
                            arrayList3.add("YES");
                            break;
                        }
                        case 2: {
                            arrayList3.add("");
                        }
                    }
                    arrayList4.add(resultSetMetaData.getColumnTypeName(i));
                    arrayList5.add(String.valueOf(resultSetMetaData.getColumnDisplaySize(i)));
                    ++n;
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            this.writeLog(1, "failed to get info from ResultSetMetaData.", sQLException);
            throw sQLException;
        }
        finally {
            statement.close();
        }
        if (n > 0) {
            charSequence = String.valueOf(n);
            if (n == 1) {
                this.println(this.getMessage("selected1", charSequence));
            } else {
                this.println(this.getMessage("selected2", charSequence));
            }
            this.exportTableLayout(arrayList, arrayList2, arrayList3, arrayList4, arrayList5);
        } else {
            this.println(this.getMessage("recordnotfound"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTableLayout(List list, List list2, List list3, List list4, List list5) throws IOException, SQLException {
        try {
            this.writer.open();
            this.writer.addColumn(" ");
            this.writer.addColumn(this.getMessage("label.column.name"));
            this.writer.addColumn(this.getMessage("label.column.nullable"));
            this.writer.addColumn(this.getMessage("label.column.type"));
            this.writer.addColumn(this.getMessage("label.column.size"));
            this.writer.nextRow();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.writer.addColumn((String)list.get(i));
                this.writer.addColumn((String)list2.get(i));
                this.writer.addColumn((String)list3.get(i));
                this.writer.addColumn((String)list4.get(i));
                this.writer.addColumn((String)list5.get(i));
                this.writer.nextRow();
            }
        }
        finally {
            this.writer.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

