/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Properties;
import net.argius.stu.IOManager;

public final class Prompt
implements PropertyChangeListener {
    private static final String DEFAULT_PROMPT = ">";
    private static final String NOT_CONNECT_STRING = "STAND-BY";
    private String userName;
    private String connectorName;
    private boolean showUserName;
    private boolean showConnectorName;
    private IOManager io;

    public Prompt(Properties properties, IOManager iOManager) {
        this.io = iOManager;
        this.initialize(properties);
    }

    private void initialize(Properties properties) {
        String string = properties.getProperty("net.argius.stu.prompt.username");
        String string2 = properties.getProperty("net.argius.stu.prompt.connectorname");
        this.showUserName = Boolean.valueOf(string);
        this.showConnectorName = Boolean.valueOf(string2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Properties properties = (Properties)propertyChangeEvent.getSource();
        this.initialize(properties);
    }

    public String getInput() throws IOException {
        return this.getInput(this.toString());
    }

    public String getInput(int n) throws IOException {
        int n2 = this.toString().length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(n);
        stringBuffer.append(' ');
        stringBuffer.append(DEFAULT_PROMPT);
        stringBuffer.append(' ');
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, ' ');
        }
        return this.getInput(stringBuffer.toString());
    }

    public String getInput(String string) throws IOException {
        this.io.printMessage(string, false);
        return this.io.scanLine();
    }

    public void setParameters(String string, String string2) {
        this.userName = string;
        this.connectorName = string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.showUserName || this.showConnectorName) {
            if (this.userName == null || this.connectorName == null) {
                stringBuffer.append(NOT_CONNECT_STRING);
            } else {
                if (this.showUserName) {
                    stringBuffer.append(this.userName);
                }
                if (this.showConnectorName) {
                    stringBuffer.append(stringBuffer.toString().trim().length() > 0 ? " " : "");
                    stringBuffer.append("@ ");
                    stringBuffer.append(this.connectorName);
                }
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append(DEFAULT_PROMPT);
        stringBuffer.append(' ');
        return stringBuffer.toString();
    }
}

