/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu;

import java.util.HashMap;
import java.util.Iterator;
import net.argius.stu.text.StringQueue;

final class Option {
    private static final String DIRECT1 = "-e";
    private static final String DIRECT2 = "-direct";
    private static final String SILENT = "-s";
    private static final String MULTIPLE = "-f";
    private String connectorName = "";
    private boolean direct;
    private String directString = "";
    private boolean silent;
    private boolean multiple;

    Option(String[] stringArray) {
        if (stringArray.length > 0) {
            String string;
            this.connectorName = stringArray[0].trim();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            StringQueue stringQueue = new StringQueue();
            String string2 = "";
            int n = stringArray.length;
            for (int i = 1; i < n; ++i) {
                string = stringArray[i];
                if (this.isSwitch(string)) {
                    hashMap.put(string2, stringQueue.drawAll());
                    string2 = string;
                } else {
                    stringQueue.inject(string);
                }
                if (i != n - 1) continue;
                hashMap.put(string2, stringQueue.drawAll());
            }
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (string3 == null) continue;
                string = string3.trim();
                if (string.equals(DIRECT1) || string.equals(DIRECT2)) {
                    this.direct = true;
                    this.directString = (String)hashMap.get(string);
                    continue;
                }
                if (string.equals(SILENT)) {
                    this.silent = true;
                    continue;
                }
                if (!string.equals(MULTIPLE)) continue;
                this.multiple = true;
            }
        }
    }

    String getConnectorName() {
        return this.connectorName;
    }

    boolean isDirect() {
        return this.direct;
    }

    String getDirectString() {
        return this.directString;
    }

    boolean isSilent() {
        return this.silent;
    }

    boolean isMultiple() {
        return this.multiple;
    }

    private boolean isSwitch(String string) {
        return string != null && string.trim().startsWith("-");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[connector name = ");
        stringBuffer.append(this.connectorName);
        stringBuffer.append(", direct = ");
        if (this.direct) {
            stringBuffer.append(this.directString);
        } else {
            stringBuffer.append(this.direct);
        }
        stringBuffer.append(", silent = ");
        stringBuffer.append(this.silent);
        stringBuffer.append(", multiple = ");
        stringBuffer.append(this.multiple);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

