/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.argius.stu.io.FilePrinter;
import net.argius.stu.io.NullPrinter;
import net.argius.stu.io.Printer;
import net.argius.stu.text.Trimmer;

public class Log {
    private static final int ILLEGAL = -1;
    private static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final int VERBOSE = 5;
    private static final String EMPTY = "";
    private static final char SPACE = ' ';
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
    private static final int DEFAULT_FILE_SIZE = 0x100000;
    private static final String LOG_ROTATE_SUFFIX = ".bak";
    private File file;
    private Printer out;
    private int level;
    private int size;
    private boolean canRotate;

    Log(Properties properties) {
        String string = properties.getProperty("net.argius.stu.system.log.file", EMPTY);
        if (string.length() > 0) {
            String string2;
            try {
                this.file = new File(string);
                this.out = new FilePrinter(this.file);
                string2 = properties.getProperty("net.argius.stu.system.log.level", EMPTY);
                if (string2.length() > 0) {
                    this.level = this.getLevelInteger(string2);
                }
            }
            catch (IOException iOException) {
                this.out = new NullPrinter();
                this.level = 0;
            }
            string2 = properties.getProperty("net.argius.stu.system.log.size", EMPTY);
            if (string2.length() > 0) {
                try {
                    this.size = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.size = 0x100000;
                }
            } else {
                this.size = 0x100000;
            }
            this.canRotate = true;
        } else {
            this.out = new NullPrinter();
            this.level = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void print(int n, String string) {
        if (n <= this.level) {
            Log log = this;
            synchronized (log) {
                if (this.canRotate) {
                    this.rotate();
                }
                this.write(this.decorate(n, string));
            }
        }
    }

    void print(int n, String string, Throwable throwable) {
        if (n <= this.level) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(string);
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.write(this.decorate(n, stringWriter.toString()));
        }
    }

    protected String decorate(int n, String string) {
        String string2 = Thread.currentThread().getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDateFormat());
        stringBuffer.append(" |");
        stringBuffer.append(Trimmer.trim(string2, 4));
        stringBuffer.append(" (");
        stringBuffer.append(this.getLevelInitialCharacter(n));
        stringBuffer.append(") ");
        if (n > 3) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected String getDateFormat() {
        return DATE_FORMAT.format(new Date());
    }

    protected void write(String string) {
        this.out.println(string);
    }

    private void rotate() {
        if (this.file.length() > (long)this.size) {
            String string = this.file.getPath();
            File file = new File(string + LOG_ROTATE_SUFFIX);
            if (file.exists() && !file.delete()) {
                this.write("old file can't delete. can't rotate.");
                return;
            }
            try {
                this.out.close();
                File file2 = new File(string);
                if (!file2.renameTo(file)) {
                    this.write("old file can't move. can't rotate.");
                    return;
                }
                File file3 = new File(string);
                FilePrinter filePrinter = new FilePrinter(file3);
                this.file = file3;
                this.out = filePrinter;
            }
            catch (IOException iOException) {
                this.write("new file can't open. can't rotate.");
                return;
            }
        }
    }

    final void setLevel(int n) {
        this.level = n;
    }

    public final int getLevel() {
        return this.level;
    }

    protected final char getLevelInitialCharacter(int n) {
        String string = this.getLevelString(n);
        if (string.length() < 1) {
            return ' ';
        }
        return string.charAt(0);
    }

    protected final String getLevelString(int n) {
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARN";
            }
            case 3: {
                return "INFO";
            }
            case 4: {
                return "DEBUG";
            }
            case 5: {
                return "VERBOSE";
            }
        }
        return EMPTY;
    }

    protected final int getLevelInteger(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals("NONE")) {
            return 0;
        }
        if (string.equals("ERROR")) {
            return 1;
        }
        if (string.equals("WARN")) {
            return 2;
        }
        if (string.equals("INFO")) {
            return 3;
        }
        if (string.equals("DEBUG")) {
            return 4;
        }
        if (string.equals("VERBOSE")) {
            return 5;
        }
        return -1;
    }
}

