/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import net.argius.stu.Application;
import net.argius.stu.DefaultIOManager;
import net.argius.stu.IOManager;
import net.argius.stu.Log;
import net.argius.stu.io.Printer;
import net.argius.stu.io.Scanner;

final class Environment {
    static final String DEFAULT_PROPERTIES_FILE = "stu.properties";
    private static final String DEFAULT_CONNECTOR_PROPERTIES_FILE = "connector.properties";
    static final String PROP_PROPERTIES = "net.argius.stu.properties";
    static final String PROP_CONNECTOR_PROPERTIES = "net.argius.stu.connector.properties";
    static final String PROP_PROMPT_USERNAME = "net.argius.stu.prompt.username";
    static final String PROP_PROMPT_CONNECTORNAME = "net.argius.stu.prompt.connectorname";
    static final String PROP_MULTILINE_MODE = "net.argius.stu.prompt.multiline";
    static final String PROP_SYSTEM_DIRECTORY = "net.argius.stu.work.directory";
    static final String PROP_LOCALE_LANGUAGE = "net.argius.stu.system.locale.language";
    static final String PROP_LOCALE_COUNTRY = "net.argius.stu.system.locale.country";
    static final String PROP_IO_CLASS = "net.argius.stu.system.io.class";
    static final String PROP_IN_CLASS = "net.argius.stu.system.in.class";
    static final String PROP_OUT_CLASS = "net.argius.stu.system.out.class";
    static final String PROP_ERR_CLASS = "net.argius.stu.system.err.class";
    static final String PROP_LOG_FILE = "net.argius.stu.system.log.file";
    static final String PROP_LOG_LEVEL = "net.argius.stu.system.log.level";
    static final String PROP_LOG_SIZE = "net.argius.stu.system.log.size";
    private static final String EMPTY = "";
    private static Environment env;
    private Properties props;
    private Log log;
    private Locale locale;
    private boolean applicationIsAvailable;
    private List listeners;

    static synchronized Environment getEnvironment() {
        if (env == null) {
            env = new Environment();
        }
        return env;
    }

    private Environment() {
        this.initializeProperties();
        this.log = new Log(this.props);
        this.initializeLocale();
        this.listeners = new ArrayList();
        this.applicationIsAvailable = true;
    }

    String getProperty(String string) {
        String string2 = System.getProperty(string, EMPTY);
        if (string2.length() > 0) {
            return string2;
        }
        return this.props.getProperty(string, EMPTY);
    }

    Properties getProperties() {
        return (Properties)this.props.clone();
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        while (this.listeners.remove(propertyChangeListener)) {
        }
    }

    void firePropertyChange() {
        this.initializeProperties();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.getProperties(), EMPTY, EMPTY, EMPTY);
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator.next();
            if (propertyChangeListener == null) continue;
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    IOManager createIOManager() {
        Object object;
        Object object2;
        String string;
        IOManager iOManager;
        String string2 = this.getProperty(PROP_IO_CLASS);
        if (string2.length() > 0) {
            try {
                iOManager = (IOManager)this.newInstance(string2);
            }
            catch (InstantiationException instantiationException) {
                iOManager = new DefaultIOManager();
            }
        } else {
            iOManager = new DefaultIOManager();
        }
        if ((string = this.getProperty(PROP_IN_CLASS)).length() > 0) {
            try {
                object2 = (Scanner)this.newInstance(string);
                iOManager.setScanner((Scanner)object2);
            }
            catch (InstantiationException instantiationException) {
                this.log.print(2, EMPTY, instantiationException);
            }
        }
        if (((String)(object2 = this.getProperty(PROP_OUT_CLASS))).length() > 0) {
            try {
                object = (Printer)this.newInstance((String)object2);
                iOManager.setOutputPrinter((Printer)object);
            }
            catch (InstantiationException instantiationException) {
                this.log.print(2, EMPTY, instantiationException);
            }
        }
        if (((String)(object = this.getProperty(PROP_ERR_CLASS))).length() > 0) {
            try {
                Printer printer = (Printer)this.newInstance((String)object);
                iOManager.setErrorPrinter(printer);
            }
            catch (InstantiationException instantiationException) {
                this.log.print(2, EMPTY, instantiationException);
            }
        }
        return iOManager;
    }

    Log getLog() {
        return this.log;
    }

    synchronized void notifyExit() {
        this.applicationIsAvailable = false;
        this.notify();
    }

    synchronized void waitExit() {
        while (this.applicationIsAvailable) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    ResourceBundle getResourceBundle(String string) {
        return ResourceBundle.getBundle(string, this.locale);
    }

    private void initializeProperties() {
        if (this.props != null) {
            this.props.clear();
            this.props = null;
        }
        this.props = new Properties(System.getProperties());
        String string = System.getProperty(PROP_PROPERTIES, EMPTY);
        File file = new File(string);
        try {
            Object object;
            if (!file.isFile()) {
                file = new File(DEFAULT_PROPERTIES_FILE);
                if (file.isFile()) {
                    this.props.setProperty(PROP_PROPERTIES, DEFAULT_PROPERTIES_FILE);
                } else {
                    string = "/stu.properties";
                    object = this.getClass().getResource(string);
                    if (object == null) {
                        this.props.setProperty(PROP_CONNECTOR_PROPERTIES, DEFAULT_CONNECTOR_PROPERTIES_FILE);
                        return;
                    }
                    file = new File(((URL)object).getPath());
                }
            }
            object = new FileInputStream(file);
            this.props.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            Application.addException(exception);
        }
    }

    private void initializeLocale() {
        String string = this.getProperty(PROP_LOCALE_LANGUAGE);
        String string2 = this.getProperty(PROP_LOCALE_COUNTRY);
        this.locale = string.length() > 0 || string2.length() > 0 ? new Locale(string, string2) : Locale.getDefault();
        this.log.print(5, "locale : " + this.locale);
        Locale.setDefault(this.locale);
    }

    private Object newInstance(String string) throws InstantiationException {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception exception) {
            this.log.print(1, EMPTY, exception);
            throw new InstantiationException(exception.getMessage());
        }
    }
}

