/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.standard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.argius.stu.ConnectorManager;

public final class ConnectorConfigurationDialog
extends JDialog {
    private static final String DRIVER_CLASS_SEPARATOR = ":";
    private static final String FQCN = (class$net$argius$stu$standard$ConnectorConfigurationDialog == null ? (class$net$argius$stu$standard$ConnectorConfigurationDialog = ConnectorConfigurationDialog.class$("net.argius.stu.standard.ConnectorConfigurationDialog")) : class$net$argius$stu$standard$ConnectorConfigurationDialog).getName();
    private static final String PROP_CONNECTOR_PROPERTIES = "net.argius.stu.connector.properties";
    private static final String PROP_DRIVER_PATH = "net.argius.stu.jdbc.drivers.path";
    private static final String PROP_DRIVER_NAME = "net.argius.stu.jdbc.drivers.name";
    private static final String EMPTY = "";
    private static final int COL_NAME = 0;
    private static final int COL_URL = 1;
    private static final int COL_USER = 2;
    private static String pathSeparator = System.getProperty("path.separator", "");
    private static Font defaultFont = new Font("Monospaced", 0, 12);
    private ResourceBundle resource;
    private File targetFile;
    private List connectorInfoList;
    private JTable connectorTable;
    private JTable libraryTable;
    private JTable driverTable;
    private Properties props;
    static /* synthetic */ Class class$net$argius$stu$standard$ConnectorConfigurationDialog;

    public ConnectorConfigurationDialog(JFrame jFrame) {
        super(jFrame);
        this.setTitle(this.getExternalString("title"));
        this.setSize(560, 480);
        this.setResizable(false);
        this.connectorTable = new JTable();
        this.connectorTable.setAutoResizeMode(4);
        this.connectorTable.setModel(new PrivateTableModel(new String[]{this.getExternalString("connector"), this.getExternalString("url"), this.getExternalString("user")}));
        JScrollPane jScrollPane = new JScrollPane(this.connectorTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JButton jButton = this.createJButton("connector.add", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onAddconnectorButtonClicked();
            }
        });
        JButton jButton2 = this.createJButton("connector.edit", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onConnectorEditButtonClicked();
            }
        });
        JButton jButton3 = this.createJButton("connector.remove", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.connectorInfoList.remove(ConnectorConfigurationDialog.this.connectorTable.getSelectedRow());
                ConnectorConfigurationDialog.this.onRemoveButtonClicked(ConnectorConfigurationDialog.this.connectorTable);
            }
        });
        JButton jButton4 = this.createJButton("up", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ConnectorConfigurationDialog.this.connectorTable.getSelectedRow();
                if (n > 0) {
                    Object e = ConnectorConfigurationDialog.this.connectorInfoList.get(n);
                    Object e2 = ConnectorConfigurationDialog.this.connectorInfoList.get(n - 1);
                    ConnectorConfigurationDialog.this.connectorInfoList.set(n, e2);
                    ConnectorConfigurationDialog.this.connectorInfoList.set(n - 1, e);
                    ConnectorConfigurationDialog.this.onUpButtonClicked(ConnectorConfigurationDialog.this.connectorTable);
                }
            }
        });
        JButton jButton5 = this.createJButton("down", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ConnectorConfigurationDialog.this.connectorTable.getSelectedRow();
                if (n < ConnectorConfigurationDialog.this.connectorInfoList.size()) {
                    Object e = ConnectorConfigurationDialog.this.connectorInfoList.get(n);
                    Object e2 = ConnectorConfigurationDialog.this.connectorInfoList.get(n + 1);
                    ConnectorConfigurationDialog.this.connectorInfoList.set(n, e2);
                    ConnectorConfigurationDialog.this.connectorInfoList.set(n + 1, e);
                    ConnectorConfigurationDialog.this.onDownButtonClicked(ConnectorConfigurationDialog.this.connectorTable);
                }
            }
        });
        this.libraryTable = new JTable();
        this.libraryTable.setModel(new PrivateTableModel(new String[]{this.getExternalString("label.jdbc.libraries")}));
        JScrollPane jScrollPane2 = new JScrollPane(this.libraryTable);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        JButton jButton6 = this.createJButton("library.add", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onAddLibraryButtonClicked();
            }
        });
        JButton jButton7 = this.createJButton("library.remove", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onRemoveButtonClicked(ConnectorConfigurationDialog.this.libraryTable);
            }
        });
        JButton jButton8 = this.createJButton("up", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onUpButtonClicked(ConnectorConfigurationDialog.this.libraryTable);
            }
        });
        JButton jButton9 = this.createJButton("down", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onDownButtonClicked(ConnectorConfigurationDialog.this.libraryTable);
            }
        });
        this.driverTable = new JTable();
        this.driverTable.setModel(new PrivateTableModel(new String[]{this.getExternalString("label.jdbc.classes")}));
        JScrollPane jScrollPane3 = new JScrollPane(this.driverTable);
        jScrollPane3.setHorizontalScrollBarPolicy(30);
        jScrollPane3.setVerticalScrollBarPolicy(20);
        JButton jButton10 = this.createJButton("driver.add", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onAddDriverButtonClicked();
            }
        });
        JButton jButton11 = this.createJButton("driver.remove", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onRemoveButtonClicked(ConnectorConfigurationDialog.this.driverTable);
            }
        });
        JButton jButton12 = this.createJButton("up", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onUpButtonClicked(ConnectorConfigurationDialog.this.driverTable);
            }
        });
        JButton jButton13 = this.createJButton("down", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onDownButtonClicked(ConnectorConfigurationDialog.this.driverTable);
            }
        });
        JButton jButton14 = this.createJButton("import", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onImportButtonClicked();
            }
        });
        JButton jButton15 = this.createJButton("export", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onExportButtonClicked();
            }
        });
        JButton jButton16 = this.createJButton("ok", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onOkButtonClicked();
            }
        });
        JButton jButton17 = this.createJButton("cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onCancelButtonClicked();
            }
        });
        ConnectorConfigurationDialog.setEscapeButton(jButton17, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog.this.onCancelButtonClicked();
            }
        });
        int n = 10;
        int n2 = 370;
        int n3 = 20;
        int n4 = 350;
        int n5 = 160;
        int n6 = 100;
        int n7 = 100;
        int n8 = 20;
        JPanel jPanel = new JPanel(null);
        jPanel.add(jScrollPane);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jPanel.add(jButton5);
        jPanel.add(jScrollPane2);
        jPanel.add(jScrollPane3);
        jPanel.add(jButton6);
        jPanel.add(jButton7);
        jPanel.add(jButton8);
        jPanel.add(jButton9);
        jPanel.add(jButton10);
        jPanel.add(jButton11);
        jPanel.add(jButton12);
        jPanel.add(jButton13);
        jPanel.add(jButton14);
        jPanel.add(jButton15);
        jPanel.add(jButton16);
        jPanel.add(jButton17);
        jScrollPane.setBounds(n, n3 + 0, n4, n7);
        jButton.setBounds(n2, n3 + 0, n5, n8);
        jButton2.setBounds(n2, n3 + 20, n5, n8);
        jButton3.setBounds(n2, n3 + 40, n5, n8);
        jButton4.setBounds(n2, n3 + 60, n5, n8);
        jButton5.setBounds(n2, n3 + 80, n5, n8);
        jScrollPane2.setBounds(n, n3 + 120, n4, n7);
        jScrollPane3.setBounds(n, n3 + 240, n4, n7);
        jButton6.setBounds(n2, n3 + 120, n5, n8);
        jButton7.setBounds(n2, n3 + 140, n5, n8);
        jButton8.setBounds(n2, n3 + 160, n5, n8);
        jButton9.setBounds(n2, n3 + 180, n5, n8);
        jButton10.setBounds(n2, n3 + 240, n5, n8);
        jButton11.setBounds(n2, n3 + 260, n5, n8);
        jButton12.setBounds(n2, n3 + 280, n5, n8);
        jButton13.setBounds(n2, n3 + 300, n5, n8);
        jButton14.setBounds(n2, n3 + 340, n5, n8);
        jButton15.setBounds(n2, n3 + 360, n5, n8);
        jButton16.setBounds(280, n3 + 400, n6, n8);
        jButton17.setBounds(384, n3 + 400, n6, n8);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(jPanel);
        jPanel.setBounds(8, 0, this.getWidth(), this.getHeight());
        Component[] componentArray = jPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setForeground(Color.black);
            componentArray[i].setFont(defaultFont);
        }
        JTable[] jTableArray = new JTable[]{this.connectorTable, this.libraryTable, this.driverTable};
        for (int i = 0; i < jTableArray.length; ++i) {
            jTableArray[i].setForeground(Color.black);
            jTableArray[i].setFont(defaultFont);
        }
        this.connectorInfoList = new ArrayList();
        this.props = new Properties(System.getProperties());
        String string = this.props.getProperty(PROP_CONNECTOR_PROPERTIES, EMPTY);
        if (string.equals(EMPTY)) {
            string = "connector.properties";
            this.props.setProperty(PROP_CONNECTOR_PROPERTIES, string);
        }
        this.targetFile = new File(string);
        if (this.targetFile.exists()) {
            try {
                this.importProperties(this.targetFile);
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        } else {
            this.targetFile = new File("connector.properties");
            try {
                this.targetFile.createNewFile();
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
    }

    private String getExternalString(String string) {
        if (this.resource == null) {
            this.resource = ResourceBundle.getBundle(FQCN);
        }
        return this.resource.getString(FQCN + '.' + string);
    }

    private JButton createJButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(this.getExternalString("button." + string));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string, this.getExternalString("title"), 0);
    }

    private boolean showOkCancelDialog(String string) {
        int n = JOptionPane.showConfirmDialog(this, string, this.getExternalString("title"), 2);
        return n == 0;
    }

    private void importProperties(File file) throws IOException {
        TableModel tableModel;
        Object object;
        Object object2;
        TableModel tableModel2;
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        properties.setProperty(PROP_CONNECTOR_PROPERTIES, file.getCanonicalPath());
        ConnectorManager connectorManager = new ConnectorManager(properties);
        List list = connectorManager.getConnectorNames();
        TableModel tableModel3 = this.connectorTable.getModel();
        if (tableModel3 instanceof PrivateTableModel) {
            tableModel2 = (PrivateTableModel)tableModel3;
            this.connectorInfoList.clear();
            ((PrivateTableModel)tableModel2).removeRowAll();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                object2 = (String)list.get(i);
                object = new ConnectorInfo();
                ((ConnectorInfo)object).setName((String)object2);
                ((ConnectorInfo)object).setUrl(properties.getProperty((String)object2 + ".url"));
                ((ConnectorInfo)object).setUser(properties.getProperty((String)object2 + ".user"));
                ((ConnectorInfo)object).setPassword(properties.getProperty((String)object2 + ".password"));
                ((ConnectorInfo)object).setUserSpacified("true".equalsIgnoreCase(properties.getProperty((String)object2 + ".userspecified")));
                ((ConnectorInfo)object).setReadonly("true".equalsIgnoreCase(properties.getProperty((String)object2 + ".readonly")));
                this.connectorInfoList.add(object);
                String[] stringArray = new String[]{((ConnectorInfo)object).getName(), ((ConnectorInfo)object).getUrl(), ((ConnectorInfo)object).getUser()};
                ((PrivateTableModel)tableModel2).addRow(stringArray);
            }
            this.connectorTable.tableChanged(null);
        }
        if ((tableModel2 = this.libraryTable.getModel()) instanceof PrivateTableModel) {
            PrivateTableModel privateTableModel = (PrivateTableModel)tableModel2;
            privateTableModel.removeRowAll();
            String string = properties.getProperty(PROP_DRIVER_PATH, EMPTY);
            object2 = new StringTokenizer(string, pathSeparator);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                privateTableModel.addRow(Arrays.asList(((StringTokenizer)object2).nextToken()));
            }
            this.libraryTable.tableChanged(null);
        }
        if ((tableModel = this.driverTable.getModel()) instanceof PrivateTableModel) {
            PrivateTableModel privateTableModel = (PrivateTableModel)tableModel;
            privateTableModel.removeRowAll();
            object2 = properties.getProperty(PROP_DRIVER_NAME, EMPTY);
            object = new StringTokenizer((String)object2, DRIVER_CLASS_SEPARATOR);
            while (((StringTokenizer)object).hasMoreTokens()) {
                privateTableModel.addRow(Arrays.asList(((StringTokenizer)object).nextToken()));
            }
            this.driverTable.tableChanged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportProperties(File file) throws IOException {
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("#--- drivers ---");
        printWriter.print(PROP_DRIVER_PATH);
        printWriter.print(" = ");
        int n2 = this.libraryTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                printWriter.print(pathSeparator);
            }
            printWriter.print(this.libraryTable.getValueAt(n, 0));
        }
        printWriter.println();
        printWriter.print(PROP_DRIVER_NAME);
        printWriter.print(" = ");
        n2 = this.driverTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                printWriter.print(DRIVER_CLASS_SEPARATOR);
            }
            printWriter.print(this.driverTable.getValueAt(n, 0));
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("#--- connectors ---");
        n2 = this.connectorInfoList.size();
        for (n = 0; n < n2; ++n) {
            ConnectorInfo connectorInfo = (ConnectorInfo)this.connectorInfoList.get(n);
            String string = connectorInfo.getName();
            if (string == null || string.trim().length() <= 0) continue;
            printWriter.println(string + ".url      = " + connectorInfo.getUrl());
            printWriter.println(string + ".user     = " + connectorInfo.getUser());
            printWriter.println(string + ".password = " + connectorInfo.getPassword());
            printWriter.println(string + ".userspecified = " + connectorInfo.isUserSpacified());
            printWriter.println(string + ".readonly = " + connectorInfo.isReadonly());
            printWriter.println();
        }
        PrintWriter printWriter2 = new PrintWriter(new FileWriter(file));
        try {
            printWriter2.print(stringWriter);
        }
        finally {
            printWriter2.close();
        }
    }

    private void closeDialog() {
        this.dispose();
    }

    private void onAddconnectorButtonClicked() {
        TableModel tableModel = this.connectorTable.getModel();
        if (tableModel instanceof PrivateTableModel) {
            PrivateTableModel privateTableModel = (PrivateTableModel)tableModel;
            int n = privateTableModel.getColumnCount();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = EMPTY;
            }
            privateTableModel.addRow(stringArray);
            this.connectorInfoList.add(new ConnectorInfo());
            this.connectorTable.tableChanged(null);
            this.connectorTable.changeSelection(this.connectorTable.getRowCount() - 1, -1, false, false);
            PrivateInputDialog privateInputDialog = new PrivateInputDialog(this);
            privateInputDialog.setVisible(true);
        }
    }

    private void onAddLibraryButtonClicked() {
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.showDialog(this, this.getExternalString("button.select"));
        File file = jFileChooser.getSelectedFile();
        if (file != null) {
            TableModel tableModel = this.libraryTable.getModel();
            try {
                String string = file.getCanonicalPath().replace('\\', '/');
                if (tableModel instanceof PrivateTableModel) {
                    PrivateTableModel privateTableModel = (PrivateTableModel)tableModel;
                    privateTableModel.addRow(new String[]{string});
                    this.libraryTable.tableChanged(null);
                }
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
    }

    private void onAddDriverButtonClicked() {
        TableModel tableModel;
        String string = JOptionPane.showInputDialog(this, (Object)this.getExternalString("DriverDialog.title"));
        if (string != null && (tableModel = this.driverTable.getModel()) instanceof PrivateTableModel) {
            PrivateTableModel privateTableModel = (PrivateTableModel)tableModel;
            privateTableModel.addRow(new String[]{string});
            this.driverTable.tableChanged(null);
        }
    }

    private void onConnectorEditButtonClicked() {
        if (this.connectorTable.getSelectedRow() >= 0) {
            PrivateInputDialog privateInputDialog = new PrivateInputDialog(this);
            privateInputDialog.setVisible(true);
        }
    }

    private void onRemoveButtonClicked(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof PrivateTableModel) {
            PrivateTableModel privateTableModel = (PrivateTableModel)tableModel;
            int n = jTable.getSelectedRow();
            if (n >= 0) {
                privateTableModel.removeRow(n);
                jTable.tableChanged(null);
            }
        }
    }

    private void onUpButtonClicked(JTable jTable) {
        int n = jTable.getSelectedRow();
        int n2 = n - 1;
        int n3 = jTable.getRowCount();
        if (n3 >= 2 && n > 0) {
            int n4 = jTable.getColumnCount();
            for (int i = 0; i < n4; ++i) {
                Object object = jTable.getValueAt(n, i);
                Object object2 = jTable.getValueAt(n2, i);
                jTable.setValueAt(object2, n, i);
                jTable.setValueAt(object, n2, i);
            }
            jTable.changeSelection(n2, -1, false, false);
        }
    }

    private void onDownButtonClicked(JTable jTable) {
        int n = jTable.getSelectedRow();
        int n2 = n + 1;
        int n3 = jTable.getRowCount();
        if (n3 >= 2 && n2 < n3) {
            int n4 = jTable.getColumnCount();
            for (int i = 0; i < n4; ++i) {
                Object object = jTable.getValueAt(n, i);
                Object object2 = jTable.getValueAt(n2, i);
                jTable.setValueAt(object2, n, i);
                jTable.setValueAt(object, n2, i);
            }
            jTable.changeSelection(n2, -1, false, false);
        }
    }

    private void onImportButtonClicked() {
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.showDialog(JOptionPane.getFrameForComponent(jFileChooser), this.getExternalString("button.import"));
        File file = jFileChooser.getSelectedFile();
        if (file != null) {
            try {
                this.importProperties(file);
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
    }

    private void onExportButtonClicked() {
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.showDialog(this, this.getExternalString("button.select"));
        File file = jFileChooser.getSelectedFile();
        if (file != null) {
            if (file.exists() && !this.showOkCancelDialog(this.getExternalString("message.overwrite"))) {
                return;
            }
            this.connectorTable.clearSelection();
            this.updateConnectorInfoList();
            try {
                this.exportProperties(file);
            }
            catch (IOException iOException) {
                this.showMessage(iOException.getMessage());
            }
        }
    }

    private void onOkButtonClicked() {
        try {
            File file = new File(this.targetFile.getName() + ".bak");
            ConnectorConfigurationDialog.copyFile(this.targetFile, file);
            this.exportProperties(this.targetFile);
            this.closeDialog();
        }
        catch (IOException iOException) {
            this.showMessage(iOException.getMessage());
        }
    }

    private void onCancelButtonClicked() {
        if (this.showOkCancelDialog(this.getExternalString("message.confirmnotsave"))) {
            this.closeDialog();
        }
    }

    private void updateConnectorInfoList() {
        TableModel tableModel = this.connectorTable.getModel();
        int n = tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            ConnectorInfo connectorInfo = (ConnectorInfo)this.connectorInfoList.get(i);
            connectorInfo.name = (String)tableModel.getValueAt(i, 0);
            connectorInfo.url = (String)tableModel.getValueAt(i, 1);
            connectorInfo.user = (String)tableModel.getValueAt(i, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(File file, File file2) {
        try {
            long l = file.lastModified();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    int n = 0;
                    while ((n = fileInputStream.read()) != -1) {
                        fileOutputStream.write(n);
                    }
                }
                finally {
                    fileInputStream.close();
                }
            }
            finally {
                fileOutputStream.close();
            }
            file2.setLastModified(l);
            return true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException);
            return false;
        }
    }

    private static void setEscapeButton(JComponent jComponent, Action action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke('\u001b');
        InputMap inputMap = jComponent.getInputMap(2);
        ActionMap actionMap = jComponent.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "cancel");
            actionMap.put("cancel", action);
        }
    }

    public static void main(String[] stringArray) {
        ConnectorConfigurationDialog connectorConfigurationDialog = new ConnectorConfigurationDialog(null);
        connectorConfigurationDialog.setLocation(100, 100);
        connectorConfigurationDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        connectorConfigurationDialog.setVisible(true);
        connectorConfigurationDialog.requestFocus();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PrivateInputDialog
    extends JDialog {
        private ConnectorConfigurationDialog scdialog;
        private JLabel label3;
        private JLabel label4;
        private JTextField text1;
        private JTextField text2;
        private JTextField text3;
        private JPasswordField text4;
        private JCheckBox userSpecified;
        private JCheckBox readOnly;

        PrivateInputDialog(ConnectorConfigurationDialog connectorConfigurationDialog) {
            super((Dialog)connectorConfigurationDialog, true);
            Object object;
            this.scdialog = connectorConfigurationDialog;
            this.setTitle(connectorConfigurationDialog.getExternalString("PrivateInputDialog.title"));
            this.setLocation(connectorConfigurationDialog.getX() + connectorConfigurationDialog.getWidth() / 2, connectorConfigurationDialog.getY() + connectorConfigurationDialog.getHeight() / 4);
            this.setSize(320, 260);
            this.setResizable(false);
            JLabel jLabel = new JLabel(connectorConfigurationDialog.getExternalString("connector"));
            JLabel jLabel2 = new JLabel(connectorConfigurationDialog.getExternalString("url"));
            this.label3 = new JLabel(connectorConfigurationDialog.getExternalString("user"));
            this.label4 = new JLabel(connectorConfigurationDialog.getExternalString("password"));
            this.text1 = new JTextField();
            this.text2 = new JTextField();
            this.text3 = new JTextField();
            this.text4 = new JPasswordField();
            this.readOnly = new JCheckBox(connectorConfigurationDialog.getExternalString("label.readonly"));
            this.userSpecified = new JCheckBox(connectorConfigurationDialog.getExternalString("label.user.specified"));
            this.userSpecified.addActionListener(new ActionListener(this){
                PrivateInputDialog pdialog;
                private final /* synthetic */ PrivateInputDialog this$0;
                {
                    this.pdialog = this.this$0 = privateInputDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = PrivateInputDialog.access$2000(this.this$0).isSelected();
                    PrivateInputDialog.access$2100(this.pdialog).setEnabled(bl);
                    PrivateInputDialog.access$2200(this.pdialog).setEnabled(bl);
                    PrivateInputDialog.access$2300(this.pdialog).setEnabled(bl);
                    PrivateInputDialog.access$2400(this.pdialog).setEnabled(bl);
                }
            });
            JTable jTable = connectorConfigurationDialog.connectorTable;
            boolean bl = false;
            int n = jTable.getSelectedRow();
            List list = connectorConfigurationDialog.connectorInfoList;
            if (n >= 0 && list.size() > n) {
                object = (ConnectorInfo)list.get(n);
                this.text1.setText((String)jTable.getValueAt(n, 0));
                this.text2.setText((String)jTable.getValueAt(n, 1));
                this.text3.setText((String)jTable.getValueAt(n, 2));
                this.text4.setText(((ConnectorInfo)object).getPassword());
                bl = ((ConnectorInfo)object).isUserSpacified();
                this.readOnly.setSelected(((ConnectorInfo)object).isReadonly());
            }
            this.userSpecified.setSelected(bl);
            this.label3.setEnabled(bl);
            this.label4.setEnabled(bl);
            this.text3.setEnabled(bl);
            this.text4.setEnabled(bl);
            object = connectorConfigurationDialog.createJButton("submit", new ActionListener(this){
                PrivateInputDialog pdialog;
                JTable table;
                List list;
                private final /* synthetic */ PrivateInputDialog this$0;
                {
                    this.pdialog = this.this$0 = privateInputDialog;
                    this.table = ConnectorConfigurationDialog.access$200(PrivateInputDialog.access$2500(this.pdialog));
                    this.list = ConnectorConfigurationDialog.access$300(PrivateInputDialog.access$2500(this.pdialog));
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.table.getSelectedRow();
                    String string = PrivateInputDialog.access$2600(this.pdialog).getText();
                    String string2 = PrivateInputDialog.access$2700(this.pdialog).getText();
                    String string3 = PrivateInputDialog.access$2300(this.pdialog).getText();
                    String string4 = String.valueOf(PrivateInputDialog.access$2400(this.pdialog).getPassword());
                    this.table.setValueAt(string, n, 0);
                    this.table.setValueAt(string2, n, 1);
                    this.table.setValueAt(string3, n, 2);
                    ConnectorInfo connectorInfo = (ConnectorInfo)this.list.get(n);
                    connectorInfo.setName(string);
                    connectorInfo.setUrl(string2);
                    connectorInfo.setUser(string3);
                    connectorInfo.setPassword(string4);
                    connectorInfo.setUserSpacified(PrivateInputDialog.access$2000(this.pdialog).isSelected());
                    connectorInfo.setReadonly(PrivateInputDialog.access$2800(this.this$0).isSelected());
                    this.table.tableChanged(null);
                    this.this$0.dispose();
                }
            });
            JButton jButton = new JButton();
            ConnectorConfigurationDialog.setEscapeButton(jButton, new AbstractAction(this){
                private final /* synthetic */ PrivateInputDialog this$0;
                {
                    this.this$0 = privateInputDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PrivateInputDialog.access$3000(this.this$0);
                }
            });
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            jPanel.add(this.label3);
            jPanel.add(this.label4);
            jPanel.add(this.text1);
            jPanel.add(this.text2);
            jPanel.add(this.text3);
            jPanel.add(this.text4);
            jPanel.add(this.readOnly);
            jPanel.add(this.userSpecified);
            jPanel.add((Component)object);
            jPanel.add(jButton);
            jLabel.setBounds(0, 4, 280, 18);
            this.text1.setBounds(0, 20, 280, 18);
            jLabel2.setBounds(0, 40, 280, 18);
            this.text2.setBounds(0, 56, 280, 18);
            this.readOnly.setBounds(0, 80, 280, 20);
            this.userSpecified.setBounds(0, 100, 280, 22);
            this.label3.setBounds(0, 124, 280, 16);
            this.text3.setBounds(0, 140, 280, 18);
            this.label4.setBounds(0, 160, 280, 18);
            this.text4.setBounds(0, 176, 280, 18);
            ((Component)object).setBounds(100, 200, 100, 18);
            this.getContentPane().setLayout(null);
            this.getContentPane().add(jPanel);
            jPanel.setBounds(16, 0, this.getWidth(), this.getHeight());
            Component[] componentArray = jPanel.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].setForeground(Color.black);
                componentArray[i].setFont(defaultFont);
            }
        }

        private void close() {
            this.setVisible(false);
        }

        static /* synthetic */ JCheckBox access$2000(PrivateInputDialog privateInputDialog) {
            return privateInputDialog.userSpecified;
        }

        static /* synthetic */ JLabel access$2100(PrivateInputDialog privateInputDialog) {
            return privateInputDialog.label3;
        }

        static /* synthetic */ JLabel access$2200(PrivateInputDialog privateInputDialog) {
            return privateInputDialog.label4;
        }

        static /* synthetic */ JTextField access$2300(PrivateInputDialog privateInputDialog) {
            return privateInputDialog.text3;
        }

        static /* synthetic */ JPasswordField access$2400(PrivateInputDialog privateInputDialog) {
            return privateInputDialog.text4;
        }

        static /* synthetic */ ConnectorConfigurationDialog access$2500(PrivateInputDialog privateInputDialog) {
            return privateInputDialog.scdialog;
        }

        static /* synthetic */ JTextField access$2600(PrivateInputDialog privateInputDialog) {
            return privateInputDialog.text1;
        }

        static /* synthetic */ JTextField access$2700(PrivateInputDialog privateInputDialog) {
            return privateInputDialog.text2;
        }

        static /* synthetic */ JCheckBox access$2800(PrivateInputDialog privateInputDialog) {
            return privateInputDialog.readOnly;
        }

        static /* synthetic */ void access$3000(PrivateInputDialog privateInputDialog) {
            privateInputDialog.close();
        }
    }

    private static class ConnectorInfo {
        private String name = "";
        private String url = "";
        private String user = "";
        private String password = "";
        private boolean userSpacified;
        private boolean readonly;

        private ConnectorInfo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String string) {
            this.url = string;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String string) {
            this.user = string;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        public boolean isUserSpacified() {
            return this.userSpacified;
        }

        public void setUserSpacified(boolean bl) {
            this.userSpacified = bl;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public void setReadonly(boolean bl) {
            this.readonly = bl;
        }
    }

    private static class PrivateTableModel
    extends AbstractTableModel {
        List columns;
        List records;

        PrivateTableModel(Object[] objectArray) {
            this.columns = Arrays.asList(objectArray);
            this.records = new LinkedList();
        }

        public void addRow(String[] stringArray) {
            List<String> list = Arrays.asList(stringArray);
            this.records.add(list);
        }

        public void addRow(List list) {
            LinkedList linkedList = new LinkedList(list);
            this.records.add(linkedList);
        }

        public void removeRow(int n) {
            this.records.remove(n);
        }

        public void removeRowAll() {
            this.records.clear();
        }

        public Object getValueAt(int n, int n2) {
            try {
                List list = (List)this.records.get(n);
                return list.get(n2);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            List list = (List)this.records.get(n);
            list.set(n2, object);
        }

        public int getRowCount() {
            return this.records.size();
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        public String getColumnName(int n) {
            try {
                return (String)this.columns.get(n);
            }
            catch (RuntimeException runtimeException) {
                return ConnectorConfigurationDialog.EMPTY;
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

