/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.argius.stu.sql.AbstractSQL;
import net.argius.stu.sql.LimitEditor;

public final class SelectSQL
extends AbstractSQL {
    private int limit;
    private ResultSet rs;
    private Map map;
    private int count;

    public SelectSQL() {
        this.limit = -1;
    }

    public SelectSQL(int n) {
        this.limit = n;
    }

    public SelectSQL(Connection connection, String string) {
        this(connection, string, -1);
    }

    public SelectSQL(Connection connection, String string, int n) {
        this.open(connection, string);
        this.limit = n;
    }

    protected int executeQuery(PreparedStatement preparedStatement) throws SQLException {
        this.rs = preparedStatement.executeQuery();
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.count = 0;
        return 0;
    }

    protected String getSQLString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.getSelectString());
        stringBuffer2.append(" FROM ");
        StringBuffer stringBuffer3 = new StringBuffer(0);
        String string = this.getQuery();
        if (string != null && string.length() > 0) {
            if (string.toUpperCase().indexOf("WHERE") == -1) {
                stringBuffer3.append(" WHERE");
            }
            stringBuffer3.append(' ');
            stringBuffer3.append(string.toUpperCase());
        }
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(this.getTable());
        stringBuffer.append(stringBuffer3);
        if (this.limited()) {
            LimitEditor limitEditor;
            try {
                limitEditor = LimitEditor.getLimitEditor(this.getDatabaseName());
            }
            catch (SQLException sQLException) {
                limitEditor = LimitEditor.getLimitEditor("");
            }
            return limitEditor.edit(stringBuffer.toString(), this.limit);
        }
        return stringBuffer.toString();
    }

    private String getSelectString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        List list = this.getColumns();
        if (list.size() == 0) {
            stringBuffer.append('*');
            return stringBuffer.toString();
        }
        stringBuffer.append(list.get(0));
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(list.get(i));
        }
        return stringBuffer.toString().toUpperCase();
    }

    private boolean limited() {
        return this.limit > -1;
    }

    public boolean next() throws SQLWarning {
        try {
            if (this.rs == null) {
                throw new SQLWarning("no result object.");
            }
            if (!this.rs.next() || this.limited() && this.count++ >= this.limit) {
                this.rs.close();
                return false;
            }
            this.map.clear();
            int n = this.getColumns().size();
            for (int i = 0; i < n; ++i) {
                String string = this.getColumns().get(i).toString();
                String string2 = this.rs.getString(i + 1);
                this.map.put(string, string2);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLWarning("cursor error.");
        }
        return true;
    }

    public String getValue(String string) {
        Object v = this.map.get(string);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public String getValue(int n) {
        List list = this.getColumns();
        if (list.size() <= n) {
            return null;
        }
        Object v = this.map.get(list.get(n));
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public List getValues() throws SQLException {
        List list = this.getColumns();
        ArrayList arrayList = new ArrayList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.map.get(list.get(i)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() throws SQLException {
        try {
            if (this.map != null) {
                this.map.clear();
            }
            if (this.rs != null) {
                this.rs.close();
            }
        }
        finally {
            this.rs = null;
        }
    }

    protected String partialInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("|Name=");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('|');
        stringBuffer.append("limit=");
        stringBuffer.append(this.limit);
        stringBuffer.append('|');
        stringBuffer.append("ResultSet=");
        stringBuffer.append(this.rs);
        stringBuffer.append('|');
        stringBuffer.append("Map=");
        stringBuffer.append(this.map);
        stringBuffer.append('|');
        return stringBuffer.toString();
    }

    public String toString() {
        return super.toString();
    }
}

