/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import net.argius.stu.io.Printer;
import net.argius.stu.io.TableWriter;

public final class PrinterTableWriter
extends TableWriter {
    private static final char DEFAULT_DELIMITER = '-';
    private Printer printer;
    private boolean opened;
    private int[] sizes;
    private char delimiter;

    public PrinterTableWriter(Printer printer, int[] nArray) {
        this.printer = printer;
        this.sizes = nArray;
        this.delimiter = (char)45;
    }

    public PrinterTableWriter(Printer printer, int[] nArray, char c) {
        this.printer = printer;
        this.sizes = nArray;
        this.delimiter = c;
    }

    public void open() throws IOException {
        if (this.printer == null || this.sizes == null) {
            throw new IOException("can't open writer.");
        }
        this.opened = true;
    }

    public void close() throws IOException {
        if (this.opened && this.printer != null) {
            this.printer.close();
        }
        this.opened = false;
    }

    protected void writeLine(List list) throws IOException {
        if (!this.opened) {
            throw new IOException("stream already closed.");
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (this.getLineNumber() == 0) {
            int n;
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                if (n != 0) {
                    printWriter.print(' ');
                }
                printWriter.print(this.trimForHeader(list.get(n), n));
            }
            printWriter.println();
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                if (n != 0) {
                    printWriter.print(' ');
                }
                printWriter.print(this.getDelimiter(n));
            }
            printWriter.println();
        } else {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    printWriter.print(' ');
                }
                printWriter.print(this.trimForData(list.get(i), i));
            }
            printWriter.println();
        }
        this.printer.print(stringWriter.toString());
    }

    private String getDelimiter(int n) {
        int n2 = Math.abs(this.getSize(n));
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(this.delimiter);
        }
        return stringBuffer.toString();
    }

    private int getSize(int n) {
        return this.sizes == null || this.sizes.length <= n ? 0 : this.sizes[n];
    }

    private String trimForData(Object object, int n) {
        int n2 = this.getSize(n);
        String string = object == null ? "" : object.toString();
        return this.trim(string, n2);
    }

    private String trimForHeader(Object object, int n) {
        int n2 = Math.abs(this.getSize(n));
        String string = object == null ? "" : object.toString();
        return this.trim(string, n2);
    }

    private String trim(String string, int n) {
        boolean bl;
        int n2;
        if (n == 0) {
            return string;
        }
        if (n < 0) {
            n2 = -n;
            bl = true;
        } else {
            n2 = n;
            bl = false;
        }
        int n3 = string.getBytes().length;
        if (n3 < n2) {
            return this.pad(string, n2, bl);
        }
        if (n3 > n2) {
            return this.cut(string, n2, bl);
        }
        return string;
    }

    private String pad(String string, int n, boolean bl) {
        if (n <= string.getBytes().length) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl) {
            while (stringBuffer.toString().getBytes().length < n) {
                stringBuffer.insert(0, ' ');
            }
        } else {
            while (stringBuffer.toString().getBytes().length < n) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    private String cut(String string, int n, boolean bl) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (n < stringBuffer.toString().getBytes().length) {
            if (bl) {
                stringBuffer.deleteCharAt(0);
                continue;
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

