/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.argius.stu.io.TableWriter;

public final class HTMLTableWriter
extends TableWriter {
    private String title;
    private String file;
    private String cssfile;
    private URL cssurl;
    private PrintWriter writer;
    private boolean opened;
    private static final Map escapeMap = new HashMap();

    public HTMLTableWriter(String string, String string2) {
        this.initialize(string, string2, "", null);
    }

    public HTMLTableWriter(String string, String string2, String string3) {
        this.initialize(string, string2, string3, null);
    }

    public HTMLTableWriter(String string, String string2, URL uRL) {
        this.initialize(string, string2, "", uRL);
    }

    private void initialize(String string, String string2, String string3, URL uRL) {
        this.title = string == null || string.trim().length() == 0 ? "(untitled)" : string.trim();
        this.file = string2;
        this.cssfile = string3 == null ? "" : string3;
        this.cssurl = uRL;
    }

    public void open() throws IOException {
        if (!this.opened) {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.file));
            this.writer = new PrintWriter(bufferedWriter);
            this.opened = true;
        }
        this.writeHeader();
    }

    public void close() throws IOException {
        if (this.opened && this.writer != null) {
            this.writeFooter();
            this.writer.close();
        }
        this.opened = false;
    }

    public void writeLine(List list) throws IOException {
        if (!this.opened) {
            throw new IOException("stream already closed.");
        }
        if (this.getLineNumber() == 0) {
            this.writer.println("  <tr>");
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.writer.print("    <th>");
                this.writer.print(this.escape(list.get(i)));
                this.writer.println("</th>");
            }
            this.writer.println("  </tr>");
        } else {
            this.writer.println("  <tr>");
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.writer.print("    <td>");
                this.writer.print(this.escape(list.get(i)));
                this.writer.println("</td>");
            }
            this.writer.println("  </tr>");
        }
    }

    private void writeHeader() throws IOException {
        this.writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        this.writer.println("<html>");
        this.writer.println("<head>");
        this.writer.print("<title>");
        this.writer.print(this.title);
        this.writer.println("</title>");
        this.writer.println("</head>");
        this.writer.println("<style>");
        this.addStyle(this.writer);
        this.writer.println("</style>");
        this.writer.println("<body>");
        this.writer.print("<h1>");
        this.writer.print(this.escape(this.title));
        this.writer.println("</h1>");
        this.writer.println("<table border=\"1\">");
    }

    private void addStyle(PrintWriter printWriter) {
        try {
            String string;
            InputStreamReader inputStreamReader;
            if (this.cssurl != null) {
                inputStreamReader = new InputStreamReader(this.cssurl.openStream());
            } else if (new File(this.cssfile).exists()) {
                inputStreamReader = new FileReader(this.cssfile);
            } else {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeFooter() throws IOException {
        this.writer.println("</table>");
        this.writer.println("</body>");
        this.writer.println("</html>");
    }

    private String escape(Object object) {
        if (object == null) {
            return "";
        }
        String string = object.toString();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            String string2 = string.substring(i, i + 1);
            if (escapeMap.containsKey(string2)) {
                stringBuffer.append(escapeMap.get(string2));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static {
        escapeMap.put(" ", "&nbsp;");
        escapeMap.put("<", "&lt;");
        escapeMap.put(">", "&gt;");
        escapeMap.put("&", "&amp;");
        escapeMap.put("\"", "&quot;");
    }
}

