/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.argius.stu.io.CSVOutputForm;

public class CSVFile {
    private static final String TEMPFILE_PREFIX = "stu.";
    private static final String TEMPFILE_SUFFIX = ".dat";
    private static final String ERROR_CANNOT_ACCESS = "file can't access.";
    private static final String ERROR_FILE_IS_NOT_OPEN = "file is not open.";
    private static final String ERROR_FILE_ALREADY_OPENED = "file already opened.";
    private static final String ERROR_FILE_ALREADY_EXISTS = "file already exists.";
    private static final int READ_MODE = 4097;
    private static final int WRITE_MODE = 8193;
    private static final char DQ = '\"';
    private static final String DQ2 = "\"\"";
    private static final String EQDQ = "=\"";
    private static final String EMPTY = "";
    private File file;
    private BufferedReader rbuffer;
    private BufferedWriter wbuffer;
    private List columns = new ArrayList();
    private int mode;
    private CSVOutputForm form = CSVOutputForm.RAW;
    private boolean opened;

    public CSVFile() throws IOException {
        this.file = File.createTempFile(TEMPFILE_PREFIX, TEMPFILE_SUFFIX);
        this.file.deleteOnExit();
    }

    public CSVFile(String string) throws IOException {
        this.file = new File(string);
        this.checkFile();
    }

    public CSVFile(File file) throws IOException {
        this.file = file;
        this.checkFile();
    }

    private void checkFile() throws IOException {
        if (this.file.exists()) {
            if (!this.file.canRead() && !this.file.canWrite()) {
                throw new IOException(ERROR_CANNOT_ACCESS);
            }
        } else {
            this.file.createNewFile();
        }
    }

    private void checkOpenedOrError() throws IOException {
        if (!this.opened) {
            throw new IOException(ERROR_FILE_IS_NOT_OPEN);
        }
    }

    public void setReadMode() throws IOException {
        this.changeMode(4097);
    }

    public void setWriteMode() throws IOException {
        this.changeMode(8193);
    }

    private void changeMode(int n) throws IOException {
        boolean bl = this.opened;
        if (bl) {
            this.close();
        }
        this.mode = n;
        if (bl) {
            this.open();
        }
    }

    public void open() throws IOException {
        if (this.opened) {
            throw new IOException(ERROR_FILE_ALREADY_OPENED);
        }
        switch (this.mode) {
            case 4097: {
                this.rbuffer = new BufferedReader(new FileReader(this.file));
                break;
            }
            case 8193: {
                this.wbuffer = new BufferedWriter(new FileWriter(this.file.getPath(), true));
                break;
            }
            default: {
                throw new RuntimeException("unknown access mode(" + this.mode + ").");
            }
        }
        this.opened = true;
    }

    public void clear() throws IOException {
        if (this.mode == 8193) {
            boolean bl = this.opened;
            if (bl) {
                this.close();
            }
            new FileWriter(this.file).close();
            if (bl) {
                this.open();
            }
        } else {
            throw new IOException("can't clear file without write mode.");
        }
    }

    public void close() throws IOException {
        this.checkOpenedOrError();
        switch (this.mode) {
            case 4097: {
                this.rbuffer.close();
                this.rbuffer = null;
                break;
            }
            case 8193: {
                this.wbuffer.close();
                this.wbuffer = null;
                break;
            }
            default: {
                throw new RuntimeException("unknown access mode(" + this.mode + ").");
            }
        }
        this.opened = false;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public void setOutputForm(CSVOutputForm cSVOutputForm) {
        this.form = cSVOutputForm;
    }

    public void addColumn(String string) {
        this.columns.add(this.form.format(string));
    }

    public void addColumn(String string, CSVOutputForm cSVOutputForm) {
        this.columns.add(cSVOutputForm.format(string));
    }

    public void insertColumn(int n, String string) {
        this.columns.add(n, this.form.format(string));
    }

    public void insertColumn(int n, String string, CSVOutputForm cSVOutputForm) {
        this.columns.add(n, cSVOutputForm.format(string));
    }

    public List nextRow() throws IOException {
        this.checkOpenedOrError();
        switch (this.mode) {
            case 4097: {
                return this.readNextRow();
            }
            case 8193: {
                StringBuffer stringBuffer = new StringBuffer();
                int n = this.columns.size();
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(this.columns.get(i));
                }
                this.wbuffer.write(stringBuffer.toString());
                this.wbuffer.newLine();
                this.columns.clear();
                return this.columns;
            }
        }
        throw new RuntimeException("unknown access mode(" + this.mode + ").");
    }

    private List readNextRow() throws IOException {
        String string = this.rbuffer.readLine();
        if (string == null) {
            return null;
        }
        if (string.indexOf(34) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
            int n = 0;
            int n2 = stringBuffer.length();
            for (int i = 0; i < n2; ++i) {
                String string2;
                CharSequence charSequence;
                Object object;
                char c = stringBuffer.charAt(i);
                if (c == '\"' && n == i) {
                    boolean bl = true;
                    object = new StringBuffer();
                    ++i;
                    while (i < stringBuffer.length()) {
                        c = stringBuffer.charAt(i);
                        if (!bl && c == ',') {
                            n = i + 1;
                            break;
                        }
                        if (bl && c == '\"') {
                            if (stringBuffer.substring(i).startsWith(DQ2)) {
                                ((StringBuffer)object).append('\"');
                                ++i;
                            } else {
                                bl = false;
                            }
                        } else {
                            ((StringBuffer)object).append(c);
                        }
                        if (bl && i == stringBuffer.length() - 1) {
                            charSequence = this.rbuffer.readLine();
                            if (charSequence == null) break;
                            StringWriter stringWriter = new StringWriter();
                            PrintWriter printWriter = new PrintWriter(stringWriter);
                            printWriter.println();
                            printWriter.print((String)charSequence);
                            stringBuffer.append(stringWriter.toString());
                        }
                        ++i;
                    }
                    arrayList.add((CharSequence)object);
                } else if (c == ',') {
                    arrayList.add(EMPTY);
                } else {
                    ++i;
                    while (i < stringBuffer.length() && stringBuffer.charAt(i) != ',') {
                        ++i;
                    }
                    string2 = stringBuffer.substring(n, i);
                    object = string2.trim();
                    charSequence = new StringBuffer();
                    if (((String)object).length() >= 3 && string2.startsWith(EQDQ) && ((String)object).endsWith(String.valueOf('\"'))) {
                        for (int j = 2; j < ((String)object).length() - 1; ++j) {
                            c = ((String)object).charAt(j);
                            if (((String)object).substring(j).indexOf(DQ2) >= 0) {
                                ++j;
                            }
                            ((StringBuffer)charSequence).append(c);
                        }
                    } else {
                        ((StringBuffer)charSequence).append(string2);
                    }
                    arrayList.add(charSequence);
                }
                n = i + 1;
                if (n <= stringBuffer.length()) {
                    string2 = stringBuffer.substring(n);
                    if (string2.indexOf(34) >= 0) continue;
                    object = this.separateComma(string2);
                    if (object != null) {
                        arrayList.addAll((Collection<CharSequence>)object);
                    }
                }
                return arrayList;
            }
        } else {
            return this.separateComma(string);
        }
        return null;
    }

    private List separateComma(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != ',') continue;
            arrayList.add(string.substring(n, i));
            n = i + 1;
        }
        arrayList.add(string.substring(n));
        return arrayList;
    }

    public void move(String string) throws IOException {
        this.move(string, false);
    }

    public void move(String string, boolean bl) throws IOException {
        boolean bl2 = this.opened;
        if (bl2) {
            this.close();
        }
        File file = this.resolveFilePath(string, bl);
        this.file.renameTo(file);
        this.file = file;
        this.checkFile();
        if (bl2) {
            this.open();
        }
    }

    public void copy(String string) throws IOException {
        this.copy(string, false);
    }

    public void copy(String string, boolean bl) throws IOException {
        int n;
        boolean bl2 = this.opened;
        if (bl2) {
            this.close();
        }
        File file = this.resolveFilePath(string, bl);
        File file2 = this.file;
        this.file = file;
        this.checkFile();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        while ((n = bufferedReader.read()) != -1) {
            bufferedWriter.write(n);
        }
        bufferedReader.close();
        bufferedWriter.close();
        if (bl2) {
            this.open();
        }
    }

    private File resolveFilePath(String string, boolean bl) throws IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            file = new File(string, this.file.getName());
        } else if (!file.isFile()) {
            file = new File(this.file.getParent(), string);
        }
        if (file.exists() && !bl) {
            throw new IOException(ERROR_FILE_ALREADY_EXISTS);
        }
        return file;
    }
}

