/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class BinaryStream {
    private static final int BUFFER_SIZE = 256;
    private static final int ENSURE_SIZE = 256;
    private byte[] buffer;
    private int position;
    private int size;

    public BinaryStream() {
        this(256);
    }

    public BinaryStream(int n) {
        this.buffer = new byte[n];
        this.position = 0;
        this.size = 0;
    }

    public int length() {
        return this.size;
    }

    public byte read(long l) throws ArrayIndexOutOfBoundsException {
        if (l < 0L || l >= Integer.MAX_VALUE || l >= (long)this.length()) {
            throw new ArrayIndexOutOfBoundsException("index " + l + ", pos " + this.position);
        }
        return this.buffer[(int)l];
    }

    public byte read() throws ArrayIndexOutOfBoundsException {
        return this.read(this.position++);
    }

    private void validateRange(long l) throws ArrayIndexOutOfBoundsException {
        if (l < 0L || l >= Integer.MAX_VALUE || l >= (long)this.length()) {
            throw new ArrayIndexOutOfBoundsException("index " + l + ", length " + this.length());
        }
    }

    private synchronized void ensureBuffer() {
        if (this.buffer.length >= this.position) {
            byte[] byArray = new byte[256];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
    }

    public void write(byte by) {
        this.ensureBuffer();
        this.buffer[this.position++] = by;
        ++this.size;
    }

    public void trancate(long l) {
        if (l <= Integer.MAX_VALUE) {
            this.size = (int)l;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setAbsolutePosition(long l) {
        this.validateRange(l);
        this.position = (int)l;
    }

    public void setRelativePosition(int n) {
        int n2 = this.position + n;
        this.validateRange(n2);
        this.position = n2;
    }

    public InputStream getInputStream() {
        return new BinaryInputStream(this);
    }

    public OutputStream getOutputStream() {
        return new BinaryOutputStream(this);
    }

    public String toString() {
        return new String(this.buffer, 0, this.size);
    }

    private static class BinaryOutputStream
    extends OutputStream {
        private BinaryStream bs;

        private BinaryOutputStream(BinaryStream binaryStream) {
            this.bs = binaryStream;
        }

        public void write(int n) throws IOException {
            this.bs.write((byte)n);
        }
    }

    private static class BinaryInputStream
    extends InputStream {
        private BinaryStream bs;
        private int pos;

        private BinaryInputStream(BinaryStream binaryStream) {
            this.bs = binaryStream;
            this.pos = 0;
        }

        public int read() throws IOException {
            if (this.pos >= this.bs.length()) {
                return -1;
            }
            return this.bs.read(this.pos++);
        }
    }
}

