/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu;

import java.text.ParseException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Version {
    private String name;
    private String fullname;
    private int major;
    private int minor;
    private int revision;
    private String note;
    private String copyright;
    private boolean valid;
    private String errorString;

    public Version(Class clazz) {
        String string = clazz.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string2 + ".version");
        try {
            this.name = Version.getBundleString(resourceBundle, "product.name");
            this.fullname = Version.getBundleString(resourceBundle, "product.fullname");
            this.major = Version.parseUnsignedInteger(Version.getBundleString(resourceBundle, "version.major"));
            this.minor = Version.parseUnsignedInteger(Version.getBundleString(resourceBundle, "version.minor"));
            String string3 = Version.getBundleString(resourceBundle, "version.revision");
            this.revision = string3.length() > 0 ? Version.parseUnsignedInteger(string3) : -1;
            this.note = Version.getBundleString(resourceBundle, "version.note");
            this.copyright = Version.getBundleString(resourceBundle, "product.copyright");
            this.valid = true;
            this.errorString = "";
        }
        catch (ParseException parseException) {
            this.valid = false;
            this.errorString = parseException.getMessage();
        }
    }

    private static String getBundleString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "";
        }
    }

    private static int parseUnsignedInteger(String string) throws ParseException {
        try {
            int n = Integer.parseInt(string);
            if (n >= 0) {
                return n;
            }
            throw new ParseException("negative integer : " + string, 0);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("not numeric : " + string, 0);
        }
    }

    public String getProductName() {
        return this.name;
    }

    public String getProductFullName() {
        return this.fullname;
    }

    public int getMajorNumber() {
        return this.major;
    }

    public int getMinorNumber() {
        return this.minor;
    }

    public int getRevisionNumber() {
        return this.revision;
    }

    public String getNote() {
        return this.note;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getVersionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.major);
        stringBuffer.append('.');
        stringBuffer.append(this.minor);
        if (this.revision >= 0) {
            stringBuffer.append('.');
            stringBuffer.append(this.revision);
        }
        if (this.note.length() > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(this.note);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.valid) {
            if (this.name.length() > 0) {
                stringBuffer.append(this.name);
                if (this.fullname.length() > 0) {
                    stringBuffer.append("/");
                    stringBuffer.append(this.fullname);
                }
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.getVersionString());
        } else {
            stringBuffer.append("(no infomation : cause of '");
            stringBuffer.append(this.errorString);
            stringBuffer.append("')");
        }
        return stringBuffer.toString();
    }
}

