/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import net.argius.stu.Application;
import net.argius.stu.IOManager;
import net.argius.stu.text.Function;
import net.argius.stu.text.StringQueue;

public class Command
implements PropertyChangeListener {
    private static final String COMMAND_PACKAGE_NAME = "net.argius.stu.command.";
    private static final String INDENT_SPACE = "  ";
    private Map pool;
    private int timeoutSeconds;
    private int recordLimit;
    private Application app;
    private IOManager io;
    private String name = "";
    private static final String SELECT = "SELECT";

    protected Command() {
    }

    protected Command(Application application) {
        this.app = application;
        this.io = application.getIOManager();
        this.pool = new HashMap();
        this.initialize(application);
    }

    protected void initialize(Application application) {
        String string;
        String string2 = application.getProperty("net.argius.stu.statement.result.limit");
        if (string2.length() > 0) {
            try {
                this.recordLimit = string2.length() >= 0 ? Integer.parseInt(string2) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                this.recordLimit = 0;
            }
        }
        if ((string = application.getProperty("net.argius.stu.statement.timeout.seconds")).length() > 0) {
            try {
                this.timeoutSeconds = string.length() >= 0 ? Integer.parseInt(string) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                this.timeoutSeconds = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(Connection connection, String string) {
        try {
            this.writeLog(3, "command [" + this.name + "] start.");
            if (connection == null || connection.isClosed()) {
                throw new SQLException(this.getMessage("notconnect"));
            }
            this.execute(connection, string);
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getMessage("usage"));
            stringBuffer.append(this.name);
            stringBuffer.append(' ');
            stringBuffer.append(illegalArgumentException.getMessage());
            this.println(stringBuffer.toString());
            this.writeLog(4, stringBuffer.toString());
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
            this.error(sQLException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.error(iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLog(3, "command [" + this.name + "] end.");
        }
    }

    protected void execute(Connection connection, String string) throws IllegalArgumentException, IOException, SQLException {
    }

    protected synchronized Command getCommand(String string) {
        try {
            String string2 = Command.getClassName(string);
            if (this.pool.containsKey(string2)) {
                return (Command)this.pool.get(string2);
            }
            Class<?> clazz = Class.forName(string2);
            Command command = (Command)clazz.newInstance();
            command.name = string.toUpperCase();
            command.app = this.app;
            command.io = this.io;
            command.recordLimit = this.recordLimit;
            command.timeoutSeconds = this.timeoutSeconds;
            this.pool.put(string2, command);
            return command;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.writeLog(4, "", classNotFoundException);
            throw new RuntimeException("class not found.");
        }
        catch (InstantiationException instantiationException) {
            this.writeLog(4, "", instantiationException);
            throw new RuntimeException("failed to instantiate.");
        }
        catch (IllegalAccessException illegalAccessException) {
            this.writeLog(4, "", illegalAccessException);
            throw new RuntimeException("can't access.");
        }
    }

    private static String getClassName(String string) {
        if (string == null) {
            return COMMAND_PACKAGE_NAME;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (stringBuffer.length() == 0) {
                stringBuffer.append(Character.toUpperCase(c));
                continue;
            }
            stringBuffer.append(Character.toLowerCase(c));
        }
        stringBuffer.insert(0, COMMAND_PACKAGE_NAME);
        return stringBuffer.toString();
    }

    protected final String getMessage(String string) {
        return this.app.getPhraseForCommand(string);
    }

    protected final String getMessage(String string, Object object) {
        String string2 = this.getMessage(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '$') {
                stringBuffer.append(object);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected final String getMessage(String string, Object[] objectArray) {
        String string2 = this.getMessage(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c == '$' && n < objectArray.length) {
                stringBuffer.append(objectArray[n++]);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected final StringQueue split(String string, int n) {
        String[] stringArray = n <= 0 ? Function.split(string) : Function.split(string, n);
        return new StringQueue(stringArray);
    }

    protected final int showResult(ResultSet resultSet) {
        try {
            return this.io.showResult(resultSet, this.recordLimit);
        }
        catch (IOException iOException) {
            this.writeLog(1, "Command.showResult()", iOException);
        }
        catch (SQLException sQLException) {
            this.writeLog(1, "Command.showResult()", sQLException);
        }
        return 0;
    }

    protected final int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    protected final void setTimeout(Statement statement) {
        if (this.timeoutSeconds > 0) {
            try {
                statement.setQueryTimeout(this.timeoutSeconds);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected final boolean isSelect(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() < SELECT.length()) {
            return false;
        }
        return string2.substring(0, 6).equalsIgnoreCase(SELECT);
    }

    protected final File resolvePath(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.app.getWorkDirectory(), string);
    }

    protected final void print(String string) {
        try {
            this.io.printMessage(string, false);
        }
        catch (IOException iOException) {
            this.writeLog(1, "Command.print()", iOException);
        }
    }

    protected final void print(String string, int n) {
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(INDENT_SPACE);
            }
            stringBuffer.append(string);
            this.print(stringBuffer.toString());
        } else {
            this.print(string);
        }
    }

    protected final void println(String string) {
        try {
            this.io.printMessage(string, true);
        }
        catch (IOException iOException) {
            this.writeLog(1, "Command.println()", iOException);
        }
    }

    protected final void warning(String string) {
        StringBuffer stringBuffer = new StringBuffer("WARNING : ");
        stringBuffer.append(string);
        this.writeLog(2, stringBuffer.toString());
        this.println(stringBuffer.toString());
    }

    private final void error(Throwable throwable) {
        this.writeLog(1, throwable);
        this.println(throwable.getMessage());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.pool.clear();
        this.initialize(this.app);
    }

    protected void writeLog(int n, String string) {
        this.app.writeLog(n, string);
    }

    protected void writeLog(int n, Throwable throwable) {
        this.app.writeLog(n, throwable);
    }

    protected void writeLog(int n, String string, Throwable throwable) {
        this.app.writeLog(n, string, throwable);
    }

    protected String getProperty(String string) {
        return this.app.getProperty(string);
    }

    protected int getLogLevel() {
        return this.app.getLogLevel();
    }
}

