/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.standard;

import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Position;
import net.argius.stu.Application;
import net.argius.stu.IOManager;
import net.argius.stu.Version;
import net.argius.stu.io.Configuration;
import net.argius.stu.standard.ConnectorConfigurationDialog;

public final class StandardView
extends IOManager {
    private static Version version;
    private static final String FQCN;
    private Application app;
    private static int openedWindow;
    private static int windowNumber;
    private JFrame frame;
    private JTextArea messageArea;
    private JSplitPane splitPane;
    private JScrollPane outputPane;
    private JTable table;
    private DefaultTableModel model;
    private List inputComponents = new ArrayList();
    private JMenuBar menuBar;
    private static String FONT_FAMILY;
    private static final Font LARGE_FONT;
    private static final Font MEDIUM_FONT;
    private static final Font SMALL_FONT;
    private Font mediumFont = MEDIUM_FONT;
    private Font smallFont = SMALL_FONT;
    private static final Font menuFont;
    private static final String lineSeparator;
    private int previousPosition;
    private List histories;
    private int historyIndex;
    private ResourceBundle resource;
    private ScanBlocker blocker;
    private boolean blockerIsAvailable;
    private boolean blocking;
    private static final String GROUP_ID = "stu";
    private Configuration configuration = new Configuration(FQCN, "stu");
    private ViewConfiguration viewConf;
    private static float javaVersion;
    static /* synthetic */ Class class$net$argius$stu$standard$StandardView;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Object;

    private static float getJavaVersion() {
        try {
            String string = System.getProperty("java.specification.version");
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public StandardView() {
        this.loadConfiguration();
        this.initializeFonts();
        this.resource = this.getSubApplication().getResourceBundle(FQCN);
        this.initialize();
        this.frame.setLocation(this.viewConf.frameLeft, this.viewConf.frameTop);
        this.frame.setSize(this.viewConf.frameWidth, this.viewConf.frameHeight);
        this.splitPane.setDividerLocation(this.viewConf.splitLocation);
        this.changeFontSize(this.viewConf.fontSize);
        this.frame.validate();
        ++openedWindow;
        this.frame.setIconImage(this.getIconImage());
    }

    private void initialize() {
        Serializable serializable;
        this.table = new JTable(this.model);
        this.table.setFont(this.mediumFont);
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(true);
        this.outputPane = new JScrollPane(this.table);
        this.outputPane.setHorizontalScrollBarPolicy(32);
        this.outputPane.setVerticalScrollBarPolicy(22);
        JScrollPane jScrollPane = this.outputPane;
        this.messageArea = new JTextArea(5, 80);
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setFont(this.mediumFont);
        this.messageArea.setMargin(new Insets(4, 4, 4, 4));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.onPressEnter(actionEvent);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        InputMap inputMap = new InputMap();
        inputMap.setParent(this.messageArea.getInputMap());
        inputMap.put(StandardView.getKeyStroke(10, false), abstractAction);
        inputMap.put(StandardView.getKeyStroke(77, true), abstractAction);
        inputMap.put(StandardView.getKeyStroke(38, false), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.printHistoryItem(-1);
            }
        });
        inputMap.put(StandardView.getKeyStroke(40, false), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.printHistoryItem(1);
            }
        });
        inputMap.put(StandardView.getKeyStroke(37, false), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = StandardView.this.messageArea.getCaretPosition();
                if (n > StandardView.this.getPreviousPosition()) {
                    StandardView.this.messageArea.setCaretPosition(n - 1);
                }
            }
        });
        inputMap.put(StandardView.getKeyStroke(39, false), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = StandardView.this.messageArea.getCaretPosition();
                int n2 = StandardView.getEndPosition(StandardView.this.messageArea);
                if (n < StandardView.this.getPreviousPosition()) {
                    StandardView.this.messageArea.setCaretPosition(StandardView.this.getPreviousPosition());
                } else if (n < n2 - 1) {
                    StandardView.this.messageArea.setCaretPosition(n + 1);
                }
            }
        });
        inputMap.put(StandardView.getKeyStroke(8, false), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = StandardView.this.messageArea.getCaretPosition();
                if ((double)javaVersion >= 1.5) {
                    if (n > StandardView.this.getPreviousPosition()) {
                        StandardView.this.messageArea.replaceRange("", n - 1, n);
                    }
                } else if (n <= StandardView.this.getPreviousPosition()) {
                    StandardView.this.messageArea.replaceRange(" ", n, n);
                }
            }
        });
        for (int i = 0; i < 15; ++i) {
            serializable = KeyStroke.getKeyStroke(36, i);
            inputMap.put((KeyStroke)serializable, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StandardView.this.messageArea.setCaretPosition(StandardView.this.getPreviousPosition());
                }
            });
        }
        inputMap.put(StandardView.getKeyStroke(33, false), abstractAction2);
        inputMap.put(StandardView.getKeyStroke(34, false), abstractAction2);
        inputMap.put(StandardView.getKeyStroke(78, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.startNew((String[])new String[0]);
            }
        });
        inputMap.put(StandardView.getKeyStroke(87, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.closeWindow();
            }
        });
        inputMap.put(StandardView.getKeyStroke(81, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.exitWithConfirm();
            }
        });
        inputMap.put(StandardView.getKeyStroke(48, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.changeFontSize(((StandardView)StandardView.this).viewConf.fontSize + 2);
            }
        });
        inputMap.put(StandardView.getKeyStroke(45, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.changeFontSize(((StandardView)StandardView.this).viewConf.fontSize - 2);
            }
        });
        inputMap.put(StandardView.getKeyStroke(46, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.setWidthRate(1.5);
            }
        });
        inputMap.put(StandardView.getKeyStroke(44, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.setWidthRate(0.6666666666666666);
            }
        });
        inputMap.put(StandardView.getKeyStroke(47, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.fitHeaderWidth();
            }
        });
        inputMap.put(StandardView.getKeyStroke(37, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = StandardView.this.messageArea.getCaretPosition();
                    int n2 = StandardView.this.getPreviousPosition();
                    if (n > n2) {
                        int n3 = n - n2;
                        String string = StandardView.this.messageArea.getText(n2, n3);
                        if (string.trim().length() > 0) {
                            char c = ' ';
                            int n4 = string.length();
                            for (int i = 0; i < n4; ++i) {
                                char c2 = string.charAt(n4 - i - 1);
                                if (Character.isWhitespace(c2) && c2 != c) {
                                    StandardView.this.messageArea.setCaretPosition(n2 + n4 - i);
                                    return;
                                }
                                c = c2;
                            }
                        }
                        StandardView.this.messageArea.setCaretPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
        inputMap.put(StandardView.getKeyStroke(19, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(StandardView.this.frame, "current JRE : " + javaVersion);
            }
        });
        this.messageArea.setInputMap(0, inputMap);
        JScrollPane jScrollPane2 = new JScrollPane(this.messageArea);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        this.splitPane = new JSplitPane(0);
        this.splitPane.setTopComponent(jScrollPane);
        this.splitPane.setBottomComponent(jScrollPane2);
        this.splitPane.setResizeWeight(0.9);
        this.histories = new LinkedList();
        this.historyIndex = -1;
        this.frame = new JFrame();
        if (openedWindow != 0) {
            this.frame.setTitle(this.getTitleName() + " (" + (++windowNumber + 1) + ')');
        } else {
            this.frame.setTitle(this.getTitleName());
        }
        this.frame.getContentPane().add(this.splitPane);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setFont(this.mediumFont);
        this.blocker = new ScanBlocker();
        this.blockerIsAvailable = true;
        this.blocking = true;
        this.blocker.start();
        this.addInputComponent(this.messageArea);
        this.frame.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                StandardView.moveCursorEnd(StandardView.this.messageArea);
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StandardView.this.closeWindow();
            }
        });
        serializable = new JMenu(this.getMenuLabel("file"));
        ((AbstractButton)serializable).setMnemonic('F');
        JMenuItem jMenuItem = this.createJMenuItem(this.getMenuLabel("directory"), 'D', StandardView.getKeyStroke(68, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.onSelectMenuChangeDirectory();
            }
        });
        JMenuItem jMenuItem2 = this.createJMenuItem(this.getMenuLabel("new"), 'N', StandardView.getKeyStroke(78, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.startNew((String[])new String[0]);
            }
        });
        JMenuItem jMenuItem3 = this.createJMenuItem(this.getMenuLabel("close"), 'C', StandardView.getKeyStroke(87, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.closeWindow();
            }
        });
        JMenuItem jMenuItem4 = this.createJMenuItem(this.getMenuLabel("exit"), 'X', StandardView.getKeyStroke(81, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.exitWithConfirm();
            }
        });
        ((JMenu)serializable).add(jMenuItem);
        ((JMenu)serializable).add(new JSeparator());
        ((JMenu)serializable).add(jMenuItem2);
        ((JMenu)serializable).add(jMenuItem3);
        ((JMenu)serializable).add(new JSeparator());
        ((JMenu)serializable).add(jMenuItem4);
        JMenu jMenu = new JMenu(this.getMenuLabel("connect"));
        jMenu.setMnemonic('C');
        JMenuItem jMenuItem5 = this.createJMenuItem(this.getMenuLabel("connectdb"), 'C', StandardView.getKeyStroke(32, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.onSelectMenuConnect();
            }
        });
        JMenuItem jMenuItem6 = this.createJMenuItem(this.getMenuLabel("disconnect"), 'D', null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.sendCommandMessage("disconnect", false);
            }
        });
        JMenuItem jMenuItem7 = this.createJMenuItem(this.getMenuLabel("configuration"), 'G', null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectorConfigurationDialog connectorConfigurationDialog = new ConnectorConfigurationDialog(null);
                connectorConfigurationDialog.setModal(true);
                connectorConfigurationDialog.setVisible(true);
                StandardView.this.sendCommandMessage("reload", false);
            }
        });
        jMenu.add(jMenuItem5);
        jMenu.add(jMenuItem6);
        jMenu.add(new JSeparator());
        jMenu.add(jMenuItem7);
        JMenu jMenu2 = new JMenu(this.getMenuLabel("view"));
        jMenu2.setMnemonic('V');
        JMenuItem jMenuItem8 = this.createJMenuItem(this.getMenuLabel("widen"), 'W', StandardView.getKeyStroke(46, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.setWidthRate(1.5);
            }
        });
        JMenuItem jMenuItem9 = this.createJMenuItem(this.getMenuLabel("narrow"), 'N', StandardView.getKeyStroke(44, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.setWidthRate(0.6666666666666666);
            }
        });
        JMenuItem jMenuItem10 = this.createJMenuItem(this.getMenuLabel("fit"), 'F', StandardView.getKeyStroke(47, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.fitHeaderWidth();
            }
        });
        JMenuItem jMenuItem11 = this.createJMenuItem(this.getMenuLabel("enlarge"), 'L', StandardView.getKeyStroke(48, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.changeFontSize(((StandardView)StandardView.this).viewConf.fontSize + 2);
            }
        });
        JMenuItem jMenuItem12 = this.createJMenuItem(this.getMenuLabel("ensmall"), 'S', StandardView.getKeyStroke(45, true), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.changeFontSize(((StandardView)StandardView.this).viewConf.fontSize - 2);
            }
        });
        JMenuItem jMenuItem13 = this.createJMenuItem(this.getMenuLabel("reset"), 'R', null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.resetMessageArea();
            }
        });
        jMenu2.add(jMenuItem8);
        jMenu2.add(jMenuItem9);
        jMenu2.add(jMenuItem10);
        jMenu2.add(new JSeparator());
        jMenu2.add(jMenuItem11);
        jMenu2.add(jMenuItem12);
        jMenu2.add(new JSeparator());
        jMenu2.add(jMenuItem13);
        JMenu jMenu3 = new JMenu(this.getMenuLabel("help"));
        jMenu3.setMnemonic('H');
        JMenuItem jMenuItem14 = this.createJMenuItem(this.getMenuLabel("about"), 'A', null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardView.this.onSelectMenuAbout();
            }
        });
        jMenu3.add(jMenuItem14);
        this.menuBar = new JMenuBar();
        this.menuBar.add((JMenu)serializable);
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
        this.menuBar.add(jMenu3);
        this.adjustAllMenuElement(this.menuBar);
        this.addInputComponent((JComponent)serializable);
        this.addInputComponent(jMenu);
        this.addInputComponent(jMenu2);
        this.addInputComponent(jMenu3);
        this.frame.setJMenuBar(this.menuBar);
        this.frame.validate();
        this.frame.setVisible(true);
        this.frame.validate();
        this.splitPane.validate();
    }

    private static KeyStroke getKeyStroke(int n, boolean bl) {
        return KeyStroke.getKeyStroke(n, bl ? 2 : 0);
    }

    private JMenuItem createJMenuItem(String string, char c, KeyStroke keyStroke, Action action) {
        JMenuItem jMenuItem = new JMenuItem(string, c);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        if (action != null) {
            jMenuItem.addActionListener(action);
        }
        return jMenuItem;
    }

    public void close() {
        super.close();
        this.frame.hide();
        this.frame.dispose();
    }

    private void initializeFonts() {
        this.mediumFont = new Font(FONT_FAMILY, 0, this.viewConf.fontSize);
        this.smallFont = new Font(FONT_FAMILY, 0, this.viewConf.fontSize - 1);
    }

    private boolean changeFontSize(int n) {
        if (n < 8 || n > 16) {
            return false;
        }
        this.viewConf.fontSize = n;
        this.initializeFonts();
        this.messageArea.setFont(this.mediumFont);
        this.frame.setFont(this.mediumFont);
        this.messageArea.validate();
        this.frame.validate();
        StandardView.moveCursorEnd(this.messageArea);
        this.saveConfiguration();
        return true;
    }

    private void addInputComponent(JComponent jComponent) {
        this.inputComponents.add(jComponent);
    }

    private void setAllInputEnabled(boolean bl) {
        if (bl) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int n = this.inputComponents.size();
        for (int i = 0; i < n; ++i) {
            JComponent jComponent = (JComponent)this.inputComponents.get(i);
            jComponent.setEnabled(bl);
        }
    }

    private synchronized void setPreviousPosition(int n) {
        this.previousPosition = n;
    }

    private synchronized int getPreviousPosition() {
        return this.previousPosition;
    }

    private void sendCommandMessage(String string) {
        this.sendCommandMessage(string, true);
    }

    private void sendCommandMessage(String string, boolean bl) {
        if (!bl) {
            int n = StandardView.getEndPosition(this.messageArea) - 1;
            if (this.getPreviousPosition() == n) {
                this.messageArea.append(string);
            } else {
                this.messageArea.replaceRange(string, this.getPreviousPosition(), n);
            }
            this.messageArea.append(lineSeparator);
        }
        this.histories.add(string);
        if (this.histories.size() > this.viewConf.historySize) {
            this.histories.remove(0);
        }
        this.historyIndex = -1;
        this.setAllInputEnabled(false);
        this.blocker.setInputMessage(string);
        this.blocking = false;
        this.blocker.interrupt();
    }

    private void resetMessageArea() {
        this.messageArea.setText("");
        this.setPreviousPosition(StandardView.getEndPosition(this.messageArea));
        this.setAllInputEnabled(false);
        this.blocker.setInputMessage(" ");
        this.blocking = false;
        this.blocker.interrupt();
    }

    private static int getEndPosition(JTextArea jTextArea) {
        Document document = jTextArea.getDocument();
        Position position = document.getEndPosition();
        return position.getOffset();
    }

    private static void moveCursorEnd(JTextArea jTextArea) {
        Caret caret = jTextArea.getCaret();
        caret.setDot(StandardView.getEndPosition(jTextArea));
        jTextArea.requestFocus();
        jTextArea.repaint();
        caret.setVisible(false);
        caret.setVisible(true);
    }

    private void printHistoryItem(int n) {
        if (this.histories.size() == 0) {
            return;
        }
        int n2 = this.historyIndex + n;
        if (n2 < 0) {
            n2 = this.histories.size() - 1;
        } else if (n2 >= this.histories.size()) {
            n2 = 0;
        }
        int n3 = StandardView.getEndPosition(this.messageArea) - 1;
        String string = (String)this.histories.get(n2);
        if (string != null) {
            if (this.getPreviousPosition() == n3) {
                this.messageArea.append(string);
            } else {
                this.messageArea.replaceRange(string, this.getPreviousPosition(), n3);
            }
        }
        this.historyIndex = n2;
    }

    private String getExternalString(String string) {
        return this.resource.getString(FQCN + '.' + string);
    }

    private String getTitleName() {
        return this.resource.getString(((Object)((Object)this)).getClass().getName() + ".title");
    }

    private void writeLog(int n, String string) {
        this.getSubApplication().writeLog(n, string);
    }

    private void writeLog(int n, Throwable throwable) {
        this.getSubApplication().writeLog(n, throwable);
    }

    private Application getSubApplication() {
        if (this.app == null) {
            this.app = new Application();
        }
        return this.app;
    }

    private static synchronized Version getVersion() {
        if (version == null) {
            version = new Version(class$net$argius$stu$standard$StandardView == null ? (class$net$argius$stu$standard$StandardView = StandardView.class$("net.argius.stu.standard.StandardView")) : class$net$argius$stu$standard$StandardView);
        }
        return version;
    }

    private Image getIconImage() {
        String string = "/" + FQCN.replace('.', '/') + ".icon.gif";
        URL uRL = ((Object)((Object)this)).getClass().getResource(string);
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public String scanLine() throws IOException {
        this.getPreviousPosition();
        this.setAllInputEnabled(true);
        String string = this.blocker.getInputMessage();
        this.blocking = true;
        return string;
    }

    private void printMessage(String string) {
        try {
            this.printMessage(string, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printMessage(String string, boolean bl) throws IOException {
        int n = this.messageArea.getLineCount();
        if ((double)n * 1.1 > (double)this.viewConf.messageBufferSize) {
            try {
                int n2 = n / 10;
                int n3 = this.messageArea.getLineEndOffset(n2);
                this.messageArea.replaceRange("", 0, n3);
            }
            catch (BadLocationException badLocationException) {
                this.getApplication().writeLog(4, (Throwable)badLocationException);
            }
        }
        this.messageArea.append(string);
        if (bl) {
            this.messageArea.append(StandardView.getLineSeparator());
        }
        this.setPreviousPosition(StandardView.getEndPosition(this.messageArea) - 1);
        StandardView.moveCursorEnd(this.messageArea);
    }

    public int showResult(ResultSet resultSet, int n) throws IOException, SQLException {
        if (resultSet == null) {
            throw new SQLException("ResultSet is null.");
        }
        int n2 = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n3];
        boolean bl = true;
        boolean bl2 = n > 0;
        this.outputPane.setVisible(false);
        this.table.setVisible(false);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setFont(this.smallFont);
        jTableHeader.setVisible(false);
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        this.table.setModel(defaultTableModel);
        boolean bl3 = true;
        while (resultSet.next() && (!bl2 || n2 < n)) {
            int n4;
            Object object;
            ++n2;
            if (bl) {
                defaultTableModel = new PrivateTableModel(n3, nArray);
                this.table.setModel(defaultTableModel);
                object = jTableHeader.getColumnModel();
                for (n4 = 1; n4 <= n3; ++n4) {
                    int n5;
                    TableColumn tableColumn = object.getColumn(n4 - 1);
                    nArray[n4 - 1] = n5 = resultSetMetaData.getColumnType(n4);
                    int n6 = resultSetMetaData.getColumnDisplaySize(n4);
                    if (n6 < 1 || n6 > 64) {
                        n6 = -1;
                    }
                    switch (n5) {
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 8: {
                            n6 = -1;
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            n6 = 16;
                            break;
                        }
                    }
                    if (bl3 && n6 >= 1) {
                        tableColumn.setPreferredWidth(n6 * 10);
                    }
                    tableColumn.setHeaderValue(resultSetMetaData.getColumnName(n4));
                }
                bl = false;
            }
            object = new Vector<String>();
            for (n4 = 1; n4 <= n3; ++n4) {
                ((Vector)object).add(resultSet.getString(n4));
            }
            defaultTableModel.addRow((Vector<?>)object);
        }
        jTableHeader.setVisible(true);
        this.table.setVisible(true);
        this.table.validate();
        this.outputPane.setVisible(true);
        return defaultTableModel.getRowCount();
    }

    private void setWidthRate(double d) {
        TableColumnModel tableColumnModel = this.table.getTableHeader().getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n2 = (int)((double)tableColumn.getWidth() * d);
            tableColumn.setPreferredWidth(n2);
        }
    }

    private void fitHeaderWidth() {
        TableColumnModel tableColumnModel = this.table.getTableHeader().getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            Object object = tableColumn.getHeaderValue();
            if (object == null || !(object instanceof String)) continue;
            int n2 = object.toString().length() * this.viewConf.fontSize;
            tableColumn.setPreferredWidth(n2);
        }
    }

    private String getMenuLabel(String string) {
        return this.getExternalString("menu." + string);
    }

    private void adjustAllMenuElement(MenuElement menuElement) {
        MenuElement[] menuElementArray = menuElement.getSubElements();
        int n = menuElementArray.length;
        for (int i = 0; i < n; ++i) {
            MenuElement menuElement2 = menuElementArray[i];
            menuElement2.getComponent().setFont(menuFont);
            this.adjustAllMenuElement(menuElement2);
        }
    }

    private void closeWindow() {
        if (openedWindow > 1) {
            --openedWindow;
            if (this.messageArea.isEnabled()) {
                this.sendCommandMessage("close", false);
            } else {
                this.getApplication().notifyExit();
                this.frame.dispose();
            }
        } else {
            this.exitWithConfirm();
        }
    }

    private void exitWithConfirm() {
        String string = this.getExternalString("dialog.exit.title");
        String string2 = this.getExternalString("dialog.exit.message");
        int n = JOptionPane.showConfirmDialog(this.frame, string2, string, 0);
        if (n == 0) {
            this.saveConfiguration();
            if (this.messageArea.isEnabled()) {
                this.sendCommandMessage("exit", false);
            } else {
                this.getApplication().notifyExit();
                this.frame.dispose();
            }
        }
    }

    private void loadConfiguration() {
        try {
            this.configuration.load();
            this.viewConf = (ViewConfiguration)this.configuration.getObject();
            this.writeLog(3, "loaded configuration.");
            this.writeLog(4, "conf = " + this.viewConf);
        }
        catch (Exception exception) {
            this.writeLog(2, exception);
            this.viewConf = new ViewConfiguration();
        }
    }

    private void saveConfiguration() {
        try {
            this.viewConf.frameLeft = this.frame.getX();
            this.viewConf.frameTop = this.frame.getY();
            this.viewConf.frameWidth = this.frame.getWidth();
            this.viewConf.frameHeight = this.frame.getHeight();
            this.viewConf.splitLocation = this.splitPane.getDividerLocation();
            this.writeLog(4, "conf = " + this.viewConf);
            this.configuration.setObject((Serializable)this.viewConf);
            this.configuration.save();
            this.writeLog(3, "saved configuration.");
        }
        catch (Exception exception) {
            this.writeLog(2, exception);
        }
    }

    private void onPressEnter(ActionEvent actionEvent) {
        int n;
        int n2 = StandardView.getEndPosition(this.messageArea) - 1;
        if (n2 != (n = this.messageArea.getCaretPosition())) {
            StandardView.moveCursorEnd(this.messageArea);
            return;
        }
        try {
            Document document = this.messageArea.getDocument();
            int n3 = n2 - this.getPreviousPosition();
            String string = document.getText(this.getPreviousPosition(), n3);
            if (string == null || string.trim().length() == 0) {
                StandardView.moveCursorEnd(this.messageArea);
                return;
            }
            this.messageArea.append(lineSeparator);
            this.sendCommandMessage(string);
        }
        catch (BadLocationException badLocationException) {
            this.writeLog(2, badLocationException);
            n2 = StandardView.getEndPosition(this.messageArea) - 1;
        }
        this.setPreviousPosition(n2 + lineSeparator.length());
    }

    private void onSelectMenuChangeDirectory() {
        JFileChooser jFileChooser = new JFileChooser(this.getApplication().getWorkDirectory());
        jFileChooser.setDialogTitle(this.getExternalString("dialog.directory.title"));
        jFileChooser.setApproveButtonText(this.getExternalString("dialog.directory.message"));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.showDialog(this.frame, null);
        File file = jFileChooser.getSelectedFile();
        if (file != null) {
            this.getApplication().setWorkDirectory(file);
        }
    }

    private void onSelectMenuConnect() {
        Application application = this.getApplication();
        Object[] objectArray = application.getConnectorNames().toArray();
        String string = objectArray.length != 0 ? objectArray[0] : "";
        this.writeLog(4, "connectors = " + Arrays.asList(objectArray));
        this.writeLog(4, "default  = " + string);
        Object object = JOptionPane.showInputDialog(this.frame, this.getExternalString("dialog.connect.message"), this.getExternalString("dialog.connect.title"), -1, null, objectArray, string);
        if (object != null) {
            String string2 = (String)object;
            if (application.isUserSpecified(string2)) {
                this.sendCommandMessage("connect " + string2, false);
            } else {
                UserAndPasswordDialog userAndPasswordDialog = new UserAndPasswordDialog(this.frame);
                userAndPasswordDialog.setTitle("connect to '" + string2 + "'");
                userAndPasswordDialog.setModal(true);
                userAndPasswordDialog.setLocationRelativeTo(this.frame);
                userAndPasswordDialog.setVisible(true);
                String string3 = userAndPasswordDialog.getUser();
                String string4 = userAndPasswordDialog.getPassword();
                if (string3 != null && string4 != null) {
                    String string5 = "connect " + string2 + ' ' + string3 + ' ';
                    this.printMessage(string5);
                    this.sendCommandMessage(string5 + string4, true);
                }
            }
        }
    }

    private void onSelectMenuAbout() {
        Version version = Application.getVersion();
        Version version2 = StandardView.getVersion();
        Object[] objectArray = new Object[]{version.getProductFullName(), "version " + version.getVersionString(), version.getCopyright(), " ", "plugin view : " + version2.getProductName(), "version " + version2.getVersionString(), version2.getCopyright()};
        JOptionPane jOptionPane = new JOptionPane(objectArray, 1, -1);
        jOptionPane.setIcon(new ImageIcon(this.getIconImage()));
        jOptionPane.setFont(LARGE_FONT);
        JDialog jDialog = jOptionPane.createDialog(this.frame, this.getExternalString("dialog.version.title"));
        jDialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        System.setProperty("net.argius.stu.system.io.class", (class$net$argius$stu$standard$StandardView == null ? (class$net$argius$stu$standard$StandardView = StandardView.class$("net.argius.stu.standard.StandardView")) : class$net$argius$stu$standard$StandardView).getName());
        Application.startMain((String[])stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        FQCN = (class$net$argius$stu$standard$StandardView == null ? (class$net$argius$stu$standard$StandardView = StandardView.class$("net.argius.stu.standard.StandardView")) : class$net$argius$stu$standard$StandardView).getName();
        openedWindow = 0;
        windowNumber = 0;
        FONT_FAMILY = "Monospaced";
        LARGE_FONT = new Font(FONT_FAMILY, 0, 13);
        MEDIUM_FONT = new Font(FONT_FAMILY, 0, 12);
        SMALL_FONT = new Font(FONT_FAMILY, 0, 11);
        menuFont = new Font(FONT_FAMILY, 0, 12);
        lineSeparator = StandardView.getLineSeparator();
        javaVersion = StandardView.getJavaVersion();
    }

    private static class PrivateTableModel
    extends DefaultTableModel {
        int[] types;

        PrivateTableModel(int n, int[] nArray) {
            super(0, n);
            this.types = nArray;
        }

        public Class getColumnClass(int n) {
            switch (this.types[n]) {
                case -7: {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = StandardView.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    return class$java$lang$Number == null ? (class$java$lang$Number = StandardView.class$("java.lang.Number")) : class$java$lang$Number;
                }
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = StandardView.class$("java.lang.Object")) : class$java$lang$Object;
        }
    }

    private static class ViewConfiguration
    implements Serializable {
        File file = new File("");
        int frameLeft = 32;
        int frameTop = 32;
        int frameWidth = 800;
        int frameHeight = 600;
        int splitLocation = -1;
        int fontSize = 12;
        int messageBufferSize = 100;
        int historySize = 50;

        ViewConfiguration() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[ file = ");
            stringBuffer.append(this.file);
            stringBuffer.append(", frameLeft = ");
            stringBuffer.append(this.frameLeft);
            stringBuffer.append(", frameTop = ");
            stringBuffer.append(this.frameTop);
            stringBuffer.append(", frameWidth = ");
            stringBuffer.append(this.frameWidth);
            stringBuffer.append(", frameHeight = ");
            stringBuffer.append(this.frameHeight);
            stringBuffer.append(", splitLocation = ");
            stringBuffer.append(this.splitLocation);
            stringBuffer.append(", fontSize = ");
            stringBuffer.append(this.fontSize);
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }
    }

    private static class UserAndPasswordDialog
    extends JDialog {
        private JTextField textUser;
        private JTextField textPassword;
        private boolean isSubmitted;

        public UserAndPasswordDialog(Frame frame) {
            super(frame);
            this.setSize(200, 108);
            this.setResizable(true);
            JPanel jPanel = new JPanel(null);
            JLabel jLabel = new JLabel("user");
            JLabel jLabel2 = new JLabel("password");
            this.textUser = new JTextField(32);
            this.textUser.setFont(MEDIUM_FONT);
            this.textPassword = new JPasswordField(32);
            JButton jButton = new JButton("SUBMIT");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ UserAndPasswordDialog this$0;
                {
                    this.this$0 = userAndPasswordDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    UserAndPasswordDialog.access$2500(this.this$0, actionEvent);
                    this.this$0.dispose();
                }
            });
            jPanel.add(jLabel);
            jPanel.add(this.textUser);
            jPanel.add(jLabel2);
            jPanel.add(this.textPassword);
            jPanel.add(jButton);
            jLabel.setBounds(4, 4, 64, 20);
            this.textUser.setBounds(68, 4, 120, 20);
            jLabel2.setBounds(4, 28, 64, 20);
            this.textPassword.setBounds(68, 28, 120, 20);
            jButton.setBounds(48, 54, 100, 16);
            this.getContentPane().add(jPanel);
        }

        private void onSubmitButtonClicked(ActionEvent actionEvent) {
            this.isSubmitted = true;
        }

        public String getUser() {
            if (this.isSubmitted && this.textUser != null) {
                return this.textUser.getText();
            }
            return null;
        }

        public String getPassword() {
            if (this.isSubmitted && this.textPassword != null) {
                return this.textPassword.getText();
            }
            return null;
        }

        static /* synthetic */ void access$2500(UserAndPasswordDialog userAndPasswordDialog, ActionEvent actionEvent) {
            userAndPasswordDialog.onSubmitButtonClicked(actionEvent);
        }
    }

    private class ScanBlocker
    extends Thread {
        private String message = "";

        private ScanBlocker() {
        }

        public void run() {
            while (StandardView.this.blockerIsAvailable) {
                this.getInputMessage();
            }
        }

        private synchronized void setInputMessage(String string) {
            this.message = string;
        }

        private synchronized String getInputMessage() {
            while (StandardView.this.blocking) {
                try {
                    this.message = "";
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.notify();
            return this.message;
        }
    }
}

