/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.text;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class DateConverter {
    private static final DateFormat defaultDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private List formatList = new ArrayList();
    private DateFormat printFormat = defaultDateFormat;

    public void addFormat(String string) {
        this.formatList.add(new SimpleDateFormat(string));
    }

    public void addFormat(DateFormat dateFormat) {
        this.formatList.add(dateFormat);
    }

    public void addFormat(List list) throws ClassCastException {
        ArrayList<DateFormat> arrayList = new ArrayList<DateFormat>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add((DateFormat)list.get(i));
        }
        this.formatList.add(arrayList);
    }

    public void clear() {
        this.formatList.clear();
    }

    public void setPrintFormat(String string) {
        this.printFormat = new SimpleDateFormat(string);
    }

    public void setPrintFormat(DateFormat dateFormat) {
        this.printFormat = dateFormat;
    }

    public Date convert(String string) throws ParseException {
        StringBuffer stringBuffer = null;
        if (this.formatList.size() > 0) {
            int n = this.formatList.size();
            for (int i = 0; i < n; ++i) {
                try {
                    return this.getFormat(i).parse(string);
                }
                catch (ParseException parseException) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    } else {
                        stringBuffer.append(':');
                    }
                    stringBuffer.append(parseException.getMessage());
                    continue;
                }
            }
        } else {
            return defaultDateFormat.parse(string);
        }
        String string2 = stringBuffer != null ? stringBuffer.toString() : "";
        throw new ParseException(string2, this.formatList.size());
    }

    public String convert(Date date) {
        return this.printFormat.format(date);
    }

    private DateFormat getFormat(int n) {
        return (DateFormat)this.formatList.get(n);
    }
}

