/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ResultSetAdapter
implements ResultSet,
ResultSetMetaData {
    private static final String NOT_SUPPORTED_ERROR = "not supported.";
    private ResultSet rs;
    private List order;
    private List names;
    private List sizes;

    public ResultSetAdapter(ResultSet resultSet) {
        if (resultSet == null) {
            throw new NullPointerException("ResultSet is null.");
        }
        this.rs = resultSet;
        this.order = new ArrayList();
        this.names = new ArrayList();
        this.sizes = new ArrayList();
    }

    public void addColumnInfo(int n) {
        this.addColumnInfo(n, "");
    }

    public void addColumnInfo(int n, String string) {
        this.addColumnInfo(n, string, -1);
    }

    public void addColumnInfo(int n, String string, int n2) {
        this.order.add(new Integer(n));
        this.names.add(string);
        this.sizes.add(new Integer(n2));
    }

    private int getColumnIndex(String string) {
        if (!this.names.contains(string)) {
            throw new NoSuchElementException("name = " + string);
        }
        return this.names.indexOf(string) + 1;
    }

    private int getRealColumnIndex(int n) {
        if (n < 1 || n > this.order.size()) {
            String string = "size = " + this.order.size() + ", index = " + n;
            throw new IndexOutOfBoundsException(string);
        }
        Integer n2 = (Integer)this.order.get(n - 1);
        return n2;
    }

    private int getRealColumnIndex(String string) {
        int n = this.getColumnIndex(string);
        return this.getRealColumnIndex(n);
    }

    public boolean absolute(int n) throws SQLException {
        return this.rs.absolute(n);
    }

    public int findColumn(String string) throws SQLException {
        return this.getColumnIndex(string);
    }

    public boolean next() throws SQLException {
        return this.rs.next();
    }

    public void afterLast() throws SQLException {
        this.rs.afterLast();
    }

    public String getString(int n) throws SQLException {
        return this.rs.getString(this.getRealColumnIndex(n));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    public void beforeFirst() throws SQLException {
        this.rs.beforeFirst();
    }

    public void cancelRowUpdates() throws SQLException {
        this.rs.cancelRowUpdates();
    }

    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    public void close() throws SQLException {
        this.rs.close();
    }

    public void deleteRow() throws SQLException {
        this.rs.deleteRow();
    }

    public boolean first() throws SQLException {
        return this.rs.first();
    }

    public Array getArray(int n) throws SQLException {
        return this.rs.getArray(this.getRealColumnIndex(n));
    }

    public Array getArray(String string) throws SQLException {
        return this.rs.getArray(this.getRealColumnIndex(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.rs.getAsciiStream(this.getRealColumnIndex(n));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.rs.getAsciiStream(this.getRealColumnIndex(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.rs.getBigDecimal(this.getRealColumnIndex(n));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.rs.getBigDecimal(this.getRealColumnIndex(string));
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.rs.getBinaryStream(this.getRealColumnIndex(n));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.rs.getBinaryStream(this.getRealColumnIndex(string));
    }

    public Blob getBlob(int n) throws SQLException {
        return this.rs.getBlob(this.getRealColumnIndex(n));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.rs.getBlob(this.getRealColumnIndex(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.rs.getBoolean(this.getRealColumnIndex(n));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.rs.getBoolean(this.getRealColumnIndex(string));
    }

    public byte getByte(int n) throws SQLException {
        return this.rs.getByte(this.getRealColumnIndex(n));
    }

    public byte getByte(String string) throws SQLException {
        return this.rs.getByte(this.getRealColumnIndex(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.rs.getBytes(this.getRealColumnIndex(n));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.rs.getBytes(this.getRealColumnIndex(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this.rs.getCharacterStream(this.getRealColumnIndex(n));
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.rs.getCharacterStream(this.getRealColumnIndex(string));
    }

    public Clob getClob(int n) throws SQLException {
        return this.rs.getClob(this.getRealColumnIndex(n));
    }

    public Clob getClob(String string) throws SQLException {
        return this.rs.getClob(this.getRealColumnIndex(string));
    }

    public int getConcurrency() throws SQLException {
        return this.rs.getConcurrency();
    }

    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.rs.getDate(this.getRealColumnIndex(n), calendar);
    }

    public Date getDate(int n) throws SQLException {
        return this.rs.getDate(this.getRealColumnIndex(n));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.rs.getDate(this.getRealColumnIndex(string), calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.rs.getDate(this.getRealColumnIndex(string));
    }

    public double getDouble(int n) throws SQLException {
        return this.rs.getDouble(this.getRealColumnIndex(n));
    }

    public double getDouble(String string) throws SQLException {
        return this.rs.getDouble(this.getRealColumnIndex(string));
    }

    public int getFetchDirection() throws SQLException {
        return this.rs.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.rs.getFetchSize();
    }

    public float getFloat(int n) throws SQLException {
        return this.rs.getFloat(this.getRealColumnIndex(n));
    }

    public float getFloat(String string) throws SQLException {
        return this.rs.getFloat(this.getRealColumnIndex(string));
    }

    public int getInt(int n) throws SQLException {
        return this.rs.getInt(this.getRealColumnIndex(n));
    }

    public int getInt(String string) throws SQLException {
        return this.rs.getInt(this.getRealColumnIndex(string));
    }

    public long getLong(int n) throws SQLException {
        return this.rs.getLong(this.getRealColumnIndex(n));
    }

    public long getLong(String string) throws SQLException {
        return this.rs.getLong(this.getRealColumnIndex(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.rs.getObject(this.getRealColumnIndex(n), map);
    }

    public Object getObject(int n) throws SQLException {
        return this.rs.getObject(this.getRealColumnIndex(n));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.rs.getObject(this.getRealColumnIndex(string), map);
    }

    public Object getObject(String string) throws SQLException {
        return this.rs.getObject(this.getRealColumnIndex(string));
    }

    public Ref getRef(int n) throws SQLException {
        return this.rs.getRef(this.getRealColumnIndex(n));
    }

    public Ref getRef(String string) throws SQLException {
        return this.rs.getRef(this.getRealColumnIndex(string));
    }

    public int getRow() throws SQLException {
        return this.rs.getRow();
    }

    public short getShort(int n) throws SQLException {
        return this.rs.getShort(this.getRealColumnIndex(n));
    }

    public short getShort(String string) throws SQLException {
        return this.rs.getShort(this.getRealColumnIndex(string));
    }

    public Statement getStatement() throws SQLException {
        return this.rs.getStatement();
    }

    public String getString(String string) throws SQLException {
        return this.rs.getString(this.getRealColumnIndex(string));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.rs.getTime(this.getRealColumnIndex(n), calendar);
    }

    public Time getTime(int n) throws SQLException {
        return this.rs.getTime(this.getRealColumnIndex(n));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.rs.getTime(this.getRealColumnIndex(string), calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.rs.getTime(this.getRealColumnIndex(string));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(this.getRealColumnIndex(n), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.rs.getTimestamp(this.getRealColumnIndex(n));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(this.getRealColumnIndex(string), calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.rs.getTimestamp(this.getRealColumnIndex(string));
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public int getType() throws SQLException {
        return this.rs.getType();
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    public void insertRow() throws SQLException {
        this.rs.insertRow();
    }

    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    public boolean last() throws SQLException {
        return this.rs.last();
    }

    public void moveToCurrentRow() throws SQLException {
        this.rs.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.rs.moveToInsertRow();
    }

    public boolean previous() throws SQLException {
        return this.rs.previous();
    }

    public void refreshRow() throws SQLException {
        this.rs.refreshRow();
    }

    public boolean relative(int n) throws SQLException {
        return this.rs.relative(n);
    }

    public boolean rowDeleted() throws SQLException {
        return this.rs.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.rs.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.rs.rowUpdated();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.rs.setFetchDirection(n);
    }

    public void setFetchSize(int n) throws SQLException {
        this.rs.setFetchSize(n);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.rs.updateAsciiStream(this.getRealColumnIndex(n), inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.rs.updateAsciiStream(this.getRealColumnIndex(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.rs.updateBigDecimal(this.getRealColumnIndex(n), bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.rs.updateBigDecimal(this.getRealColumnIndex(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.rs.updateBinaryStream(this.getRealColumnIndex(n), inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.rs.updateBinaryStream(this.getRealColumnIndex(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.rs.updateBoolean(this.getRealColumnIndex(n), bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.rs.updateBoolean(this.getRealColumnIndex(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.rs.updateByte(this.getRealColumnIndex(n), by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.rs.updateByte(this.getRealColumnIndex(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.rs.updateBytes(this.getRealColumnIndex(n), byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.rs.updateBytes(this.getRealColumnIndex(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.rs.updateCharacterStream(this.getRealColumnIndex(n), reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.rs.updateCharacterStream(this.getRealColumnIndex(string), reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.rs.updateDate(this.getRealColumnIndex(n), date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.rs.updateDate(this.getRealColumnIndex(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.rs.updateDouble(this.getRealColumnIndex(n), d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.rs.updateDouble(this.getRealColumnIndex(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.rs.updateFloat(this.getRealColumnIndex(n), f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.rs.updateFloat(this.getRealColumnIndex(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.rs.updateInt(this.getRealColumnIndex(n), n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.rs.updateInt(this.getRealColumnIndex(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.rs.updateLong(this.getRealColumnIndex(n), l);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.rs.updateLong(this.getRealColumnIndex(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.rs.updateNull(this.getRealColumnIndex(n));
    }

    public void updateNull(String string) throws SQLException {
        this.rs.updateNull(this.getRealColumnIndex(string));
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.rs.updateObject(this.getRealColumnIndex(n), object, n2);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.rs.updateObject(this.getRealColumnIndex(n), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.rs.updateObject(this.getRealColumnIndex(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.rs.updateObject(this.getRealColumnIndex(string), object);
    }

    public void updateRow() throws SQLException {
        this.rs.updateRow();
    }

    public void updateShort(int n, short s) throws SQLException {
        this.rs.updateShort(this.getRealColumnIndex(n), s);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.rs.updateShort(this.getRealColumnIndex(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.rs.updateString(this.getRealColumnIndex(n), string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.rs.updateString(this.getRealColumnIndex(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.rs.updateTime(this.getRealColumnIndex(n), time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.rs.updateTime(this.getRealColumnIndex(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.rs.updateTimestamp(this.getRealColumnIndex(n), timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.rs.updateTimestamp(this.getRealColumnIndex(string), timestamp);
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public boolean wasNull() throws SQLException {
        return this.rs.wasNull();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new SQLException(NOT_SUPPORTED_ERROR);
    }

    public int getColumnCount() throws SQLException {
        return this.order.size();
    }

    public String getColumnClassName(int n) throws SQLException {
        return null;
    }

    public String getColumnName(int n) throws SQLException {
        if (n >= 1 && n <= this.names.size()) {
            String string = (String)this.names.get(n - 1);
            if (string != null && string.length() > 0) {
                return string;
            }
            return this.rs.getMetaData().getColumnName(this.getRealColumnIndex(n));
        }
        throw new IndexOutOfBoundsException();
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        if (n >= 1 && n <= this.order.size()) {
            Integer n2 = (Integer)this.sizes.get(n - 1);
            if (n2 != null && n2 > 0) {
                return n2;
            }
            return this.rs.getMetaData().getColumnDisplaySize(this.getRealColumnIndex(n));
        }
        throw new IndexOutOfBoundsException();
    }

    public int getColumnType(int n) throws SQLException {
        return this.rs.getMetaData().getColumnType(this.getRealColumnIndex(n));
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this.rs.getMetaData().getColumnTypeName(this.getRealColumnIndex(n));
    }

    public int getPrecision(int n) throws SQLException {
        return this.rs.getMetaData().getPrecision(this.getRealColumnIndex(n));
    }

    public int getScale(int n) throws SQLException {
        return this.rs.getMetaData().getScale(this.getRealColumnIndex(n));
    }

    public String getSchemaName(int n) throws SQLException {
        return this.rs.getMetaData().getSchemaName(this.getRealColumnIndex(n));
    }

    public String getTableName(int n) throws SQLException {
        return this.rs.getMetaData().getTableName(this.getRealColumnIndex(n));
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return this.rs.getMetaData().isAutoIncrement(this.getRealColumnIndex(n));
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return this.rs.getMetaData().isCaseSensitive(this.getRealColumnIndex(n));
    }

    public boolean isCurrency(int n) throws SQLException {
        return this.rs.getMetaData().isCurrency(this.getRealColumnIndex(n));
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return this.rs.getMetaData().isDefinitelyWritable(this.getRealColumnIndex(n));
    }

    public int isNullable(int n) throws SQLException {
        return this.rs.getMetaData().isNullable(this.getRealColumnIndex(n));
    }

    public boolean isReadOnly(int n) throws SQLException {
        return this.rs.getMetaData().isReadOnly(this.getRealColumnIndex(n));
    }

    public boolean isSearchable(int n) throws SQLException {
        return this.rs.getMetaData().isSearchable(this.getRealColumnIndex(n));
    }

    public boolean isSigned(int n) throws SQLException {
        return this.rs.getMetaData().isSigned(this.getRealColumnIndex(n));
    }

    public boolean isWritable(int n) throws SQLException {
        return this.rs.getMetaData().isWritable(this.getRealColumnIndex(n));
    }

    public String getCatalogName(int n) throws SQLException {
        return this.rs.getMetaData().getCatalogName(this.getRealColumnIndex(n));
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.rs.getMetaData().getColumnLabel(this.getRealColumnIndex(n));
    }
}

