/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.argius.stu.sql.SQL;

public abstract class AbstractSQL
implements SQL {
    private boolean opened;
    private Connection conn;
    private String table = "";
    private List columns = new ArrayList();
    private List params = new ArrayList();
    private String query = "";
    private PreparedStatement statement;
    private boolean prepared;
    private int timeoutSeconds = 0;

    protected AbstractSQL() {
    }

    public final void open(Connection connection, String string) {
        this.conn = connection;
        this.table = string;
        this.opened = true;
    }

    public final void addColumn(String string) {
        this.columns.add(string);
        this.prepared = false;
    }

    public final void addColumn(List list) {
        this.columns.addAll(list);
        this.prepared = false;
    }

    public final void clearColumn() {
        this.columns.clear();
        this.prepared = false;
    }

    public final String getQuery() {
        return this.query;
    }

    public final void setQuery(String string) {
        this.query = string.toUpperCase();
        this.prepared = false;
    }

    public final void setQueryTimeout(int n) {
        this.timeoutSeconds = n;
    }

    public final void addParameter(String string) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        this.params.add(string);
    }

    public final void addParameter(List list) {
        if (this.params == null) {
            this.params = new ArrayList();
        } else {
            this.params.addAll(list);
        }
    }

    public final void clearParameter() {
        if (this.statement != null) {
            try {
                this.statement.clearParameters();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.params != null) {
            this.params.clear();
        }
    }

    public int execute() throws SQLException {
        if (!this.opened) {
            throw new SQLException("object is not opened.");
        }
        if (!this.prepared) {
            this.statement = this.conn.prepareStatement(this.getSQLString());
            this.prepared = true;
        }
        if (this.timeoutSeconds > 0) {
            this.statement.setQueryTimeout(this.timeoutSeconds);
        }
        int n = this.params.size();
        for (int i = 0; i < n; ++i) {
            this.statement.setString(i + 1, this.params.get(i).toString());
        }
        return this.executeQuery(this.statement);
    }

    public boolean next() throws SQLException {
        throw new SQLWarning("next()\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public String getValue(String string) throws SQLException {
        throw new SQLWarning("getValue(String)\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public String getValue(int n) throws SQLException {
        throw new SQLWarning("getValue(int)\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public List getValues() throws SQLException {
        throw new SQLWarning("getValues()\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws SQLException {
        try {
            this.clearAll();
            this.columns.clear();
            this.params.clear();
            this.query = "";
            if (this.statement != null) {
                this.statement.close();
            }
            Object var2_1 = null;
            this.statement = null;
            this.prepared = false;
            this.table = "";
            this.conn = null;
            this.opened = false;
            this.timeoutSeconds = 0;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.statement = null;
            this.prepared = false;
            this.table = "";
            this.conn = null;
            this.opened = false;
            this.timeoutSeconds = 0;
            throw throwable;
        }
    }

    protected abstract String getSQLString();

    protected abstract int executeQuery(PreparedStatement var1) throws SQLException;

    protected abstract void clearAll() throws SQLException;

    protected String getTable() {
        return this.table;
    }

    protected List getColumns() {
        return this.columns;
    }

    protected List getParameters() {
        return this.params;
    }

    protected abstract String partialInfo();

    protected String embedQueryString() {
        int n = 0;
        List list = this.getParameters();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getQuery() + " ", "?");
        StringBuffer stringBuffer = new StringBuffer(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            if (n < list.size()) {
                stringBuffer.append("'").append(list.get(n++)).append("'");
                stringBuffer.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuffer.append("''");
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    protected String getDatabaseName() throws SQLException {
        return this.conn.getMetaData().getDatabaseProductName();
    }

    public String toVerboseString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("connection=[");
        stringBuffer.append(this.conn);
        stringBuffer.append("]:sql=[");
        stringBuffer.append(this.getSQLString());
        stringBuffer.append("]:prepared=[");
        stringBuffer.append(this.prepared);
        stringBuffer.append("]:parameters=[");
        stringBuffer.append(this.params);
        stringBuffer.append("]:partial=[");
        stringBuffer.append(this.partialInfo());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        List list = this.getParameters();
        String string = this.getSQLString();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '?' && n < list.size()) {
                stringBuffer.append("'").append(list.get(n++)).append("'");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

