/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Configuration {
    private static final String FILE_SUFFIX = ".configuration";
    private String name;
    private String group;
    private File file;
    private Object object;

    public Configuration(String string) {
        this(string, "");
    }

    public Configuration(String string, String string2) {
        this.name = string;
        this.group = string2;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Serializable serializable) {
        this.object = serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.getFile());
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.object);
        }
        finally {
            fileOutputStream.close();
        }
    }

    public void load() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.getFile());
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("cause of : " + classNotFoundException);
        }
        finally {
            fileInputStream.close();
        }
    }

    private File getFile() throws IOException {
        if (this.file == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name);
            stringBuffer.append(FILE_SUFFIX);
            this.file = new File(this.getDirectory(), stringBuffer.toString());
        }
        return this.file;
    }

    private File getDirectory() throws IOException {
        File file;
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("user.home", "");
        stringBuffer.append(string);
        stringBuffer.append('/');
        stringBuffer.append('.');
        if (this.group != null) {
            stringBuffer.append(this.group);
            stringBuffer.append('/');
        }
        if (!((file = new File(stringBuffer.toString())).isDirectory() || !file.isFile() && file.mkdirs())) {
            throw new IOException("can't create directory : " + file);
        }
        return file;
    }
}

