/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.io;

import java.io.IOException;
import java.util.List;
import net.argius.stu.io.CSVFile;
import net.argius.stu.io.CSVOutputForm;
import net.argius.stu.io.TableWriter;

public final class CSVTableWriter
extends TableWriter {
    private String file;
    private CSVFile csv;
    private boolean opened;

    public CSVTableWriter(String string) {
        this.file = string;
    }

    public CSVTableWriter(CSVFile cSVFile) {
        this.file = cSVFile.getPath();
        this.csv = cSVFile;
    }

    public void open() throws IOException {
        if (!this.opened) {
            if (this.csv == null) {
                this.csv = new CSVFile(this.file);
            }
            this.csv.setOutputForm(CSVOutputForm.AUTO);
            this.csv.setWriteMode();
            this.csv.clear();
            this.csv.open();
            this.opened = true;
        }
    }

    public void close() throws IOException {
        if (this.opened && this.csv != null) {
            this.csv.close();
        }
        this.opened = false;
    }

    protected void writeLine(List list) throws IOException {
        if (!this.opened) {
            throw new IOException("stream already closed.");
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.csv.addColumn((String)list.get(i));
        }
        this.csv.nextRow();
    }
}

