/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.io;

public final class CSVOutputForm {
    private static final int iRAW = 4097;
    private static final int iAUTO = 8193;
    private static final int iQUOTE = 16385;
    private static final int iESCAPE = 32769;
    public static final CSVOutputForm RAW = new CSVOutputForm(4097);
    public static final CSVOutputForm AUTO = new CSVOutputForm(8193);
    public static final CSVOutputForm QUOTE = new CSVOutputForm(16385);
    public static final CSVOutputForm ESCAPE = new CSVOutputForm(32769);
    private int form;

    private CSVOutputForm(int n) {
        this.form = n;
    }

    public String format(String string) {
        switch (this.form) {
            case 4097: {
                return this.editRaw(string);
            }
            case 8193: {
                return this.editAuto(string);
            }
            case 16385: {
                return this.editQuote(string);
            }
            case 32769: {
                return this.editEscape(string);
            }
        }
        return string;
    }

    private String editRaw(String string) {
        return string;
    }

    private String editAuto(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() > 0) {
            if (string2.indexOf(13) >= 0 || string2.indexOf(10) >= 0) {
                return this.editEscape(string);
            }
            if (string2.indexOf(44) >= 0) {
                return this.editEscape(string);
            }
            char c = string2.charAt(0);
            if (c == '0' && string2.length() >= 2) {
                try {
                    Double.parseDouble(string);
                    return this.editQuote(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string2.indexOf(46) >= 0 && string2.charAt(string2.length() - 1) == '0') {
                try {
                    Double.parseDouble(string);
                    return this.editQuote(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ('0' <= c && c <= '9') {
                try {
                    if (Long.parseLong(string2) > Integer.MAX_VALUE) {
                        return this.editQuote(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    private String editQuote(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=\"");
        stringBuffer.append(string);
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private String editEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }
}

