/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu.command;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import net.argius.stu.Command;
import net.argius.stu.text.StringQueue;
import net.argius.stu.text.Trimmer;

public class Time
extends Command {
    private static final String USAGE = "[<number-of-times>] <SQL-statement>";
    private static final IllegalArgumentException usageError = new IllegalArgumentException("[<number-of-times>] <SQL-statement>");
    private static final String SEPARATOR = "  : ";
    private static final DecimalFormat timeFormat = new DecimalFormat("0.000");

    protected void execute(Connection connection, String string) throws IllegalArgumentException, SQLException, IOException {
        String string2;
        int n;
        StringQueue stringQueue = this.split(string, 2);
        stringQueue.draw();
        if (stringQueue.isEmpty()) {
            throw usageError;
        }
        String string3 = stringQueue.draw();
        if (this.isNumeric(string3)) {
            n = Integer.parseInt(string3);
            if (stringQueue.isEmpty()) {
                throw usageError;
            }
            string2 = stringQueue.drawAll();
        } else {
            n = 1;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3);
            stringBuffer.append(' ');
            stringBuffer.append(stringQueue.drawAll());
            string2 = stringBuffer.toString();
        }
        this.writeLog(4, "times : " + n);
        this.writeLog(4, "SQL   : " + string2);
        if (n == 1) {
            this.tryOnce(connection, string2);
        } else {
            this.tryManyTimes(connection, string2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryOnce(Connection connection, String string) throws IOException, SQLException {
        String string2 = this.getMessage("time.seconds");
        Statement statement = connection.createStatement();
        try {
            long l;
            if (this.isSelect(string)) {
                long l2 = System.currentTimeMillis();
                statement.executeQuery(string).next();
                l = System.currentTimeMillis() - l2;
            } else {
                long l3 = System.currentTimeMillis();
                statement.executeUpdate(string);
                l = System.currentTimeMillis() - l3;
            }
            this.writeLog(4, "msecs : " + l);
            this.print(this.getMessage("time.one"), 1);
            this.print(SEPARATOR);
            this.print(Time.toSecondsString(l));
            this.println(string2);
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryManyTimes(Connection connection, String string, int n) throws IOException, SQLException {
        String string2 = " " + this.getMessage("time.seconds");
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        Statement statement = connection.createStatement();
        try {
            for (int i = 1; i <= n; ++i) {
                long l4;
                long l5;
                if (this.isSelect(string)) {
                    l5 = System.currentTimeMillis();
                    statement.executeQuery(string).next();
                    l4 = System.currentTimeMillis() - l5;
                } else {
                    l5 = System.currentTimeMillis();
                    statement.executeUpdate(string);
                    l4 = System.currentTimeMillis() - l5;
                }
                this.writeLog(4, "msecs[" + i + "] : " + l4);
                l += l4;
                l2 = l4 > l2 ? l4 : l2;
                l3 = l3 == 0L || l4 < l3 ? l4 : l3;
            }
            String[] stringArray = new String[]{this.getMessage("time.total"), this.getMessage("time.average"), this.getMessage("time.maximum"), this.getMessage("time.minimum")};
            int n2 = 0;
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = stringArray[i].getBytes().length;
                n2 = n2 < n4 ? n4 : n2;
            }
            this.print(Trimmer.trim(stringArray[0], n2), 1);
            this.print(SEPARATOR);
            this.print(Trimmer.trim(Time.toSecondsString(l), 10, Trimmer.RIGHT));
            this.println(string2);
            this.print(Trimmer.trim(stringArray[1], n2), 1);
            this.print(SEPARATOR);
            this.print(Trimmer.trim(Time.toSecondsString(l / (long)n), 10, Trimmer.RIGHT));
            this.println(string2);
            this.print(Trimmer.trim(stringArray[2], n2), 1);
            this.print(SEPARATOR);
            this.print(Trimmer.trim(Time.toSecondsString(l2), 10, Trimmer.RIGHT));
            this.println(string2);
            this.print(Trimmer.trim(stringArray[3], n2), 1);
            this.print(SEPARATOR);
            this.print(Trimmer.trim(Time.toSecondsString(l3), 10, Trimmer.RIGHT));
            this.println(string2);
        }
        finally {
            statement.close();
        }
    }

    private boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && '9' >= c) continue;
            return false;
        }
        return true;
    }

    private static String toSecondsString(long l) {
        return timeFormat.format((float)l / 1000.0f);
    }
}

