/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.argius.stu.Application;
import net.argius.stu.IOManager;
import net.argius.stu.Version;
import net.argius.stu.io.DefaultErrorPrinter;
import net.argius.stu.io.DefaultOutputPrinter;
import net.argius.stu.io.DefaultScanner;
import net.argius.stu.io.NullTableWriter;
import net.argius.stu.io.Printer;
import net.argius.stu.io.PrinterTableWriter;
import net.argius.stu.io.TableWriter;

public final class DefaultIOManager
extends IOManager {
    private static final TableWriter TableWriterNullObject = new NullTableWriter();
    private static final char DELIMITER = '=';

    public DefaultIOManager() {
        this.setScanner(new DefaultScanner());
        this.setOutputPrinter(new DefaultOutputPrinter());
        this.setErrorPrinter(new DefaultErrorPrinter());
        try {
            Version version = Application.getVersion();
            this.printMessage(version.getProductFullName(), true);
            this.printMessage("version " + version.getVersionString(), true);
            this.printMessage("", true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String scanLine() throws IOException {
        return this.getScanner().scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showResult(ResultSet resultSet, int n) throws IOException, SQLException {
        if (resultSet == null) {
            throw new SQLException("ResultSet is null.");
        }
        TableWriter tableWriter = TableWriterNullObject;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n2];
        boolean bl = true;
        boolean bl2 = n > 0;
        try {
            int n3;
            int n4 = 0;
            while (resultSet.next() && (!bl2 || n4 < n)) {
                ++n4;
                if (bl) {
                    int n5;
                    for (n3 = 1; n3 <= n2; ++n3) {
                        n5 = resultSetMetaData.getColumnType(n3);
                        int n6 = resultSetMetaData.getColumnDisplaySize(n3);
                        if (n6 <= 0) {
                            n6 = 16;
                        } else if (1000 < n6 && n6 < 32768) {
                            n6 = 1000;
                        } else if (32768 <= n6) {
                            n6 = 32;
                        }
                        switch (n5) {
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 8: {
                                n6 = -n6;
                                break;
                            }
                        }
                        nArray[n3 - 1] = n6;
                    }
                    tableWriter = new PrinterTableWriter(new DefaultOutputPrinter(), nArray, '=');
                    tableWriter.open();
                    n3 = 0;
                    for (n5 = 1; n5 <= n2; ++n5) {
                        String string = resultSetMetaData.getColumnName(n5);
                        if (string != null && string.trim().length() > 0) {
                            ++n3;
                        }
                        tableWriter.addColumn(string);
                    }
                    if (n3 > 0) {
                        this.println();
                    }
                    tableWriter.nextRow();
                    bl = false;
                }
                for (n3 = 1; n3 <= n2; ++n3) {
                    tableWriter.addColumn(resultSet.getString(n3));
                }
                tableWriter.nextRow();
            }
            if (n4 > 0) {
                this.println();
            }
            n3 = n4;
            return n3;
        }
        finally {
            tableWriter.close();
        }
    }

    private void println() {
        this.getOutputPrinter().println("");
    }

    public void printMessage(String string, boolean bl) throws IOException {
        Printer printer = this.getErrorPrinter();
        if (bl) {
            printer.println(string);
        } else {
            printer.print(string);
        }
    }
}

