/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.argius.stu.Application;
import net.argius.stu.text.Function;
import net.argius.stu.text.StringQueue;

public final class ConnectorManager
implements PropertyChangeListener {
    private static final String PROP_JDBC_DRIVERS = "jdbc.drivers";
    private static final String PROP_JDBC_DRIVERS_NAME = "net.argius.stu.jdbc.drivers.name";
    private static final String PROP_JDBC_DRIVERS_PATH = "net.argius.stu.jdbc.drivers.path";
    private static final String URL = "url";
    private static final String USER = "user";
    private static final String PASS = "password";
    private static final String USERSPECIFIED = "userspecified";
    private static final String READONLY = "readonly";
    private static final String EMPTY = "";
    private static final String pathSeparator = System.getProperty("path.separator", "");
    private Properties localProps;
    private Map connectorMap = new HashMap();
    private List connectorNameList = new ArrayList();
    private URLClassLoader classloader;
    private Driver[] driverClasses;

    public ConnectorManager(Properties properties) {
        this.initializeLocalProperties(properties);
        this.initializeConnectorList();
        this.initializeDriverList();
    }

    private void initializeLocalProperties(Properties properties) {
        Closeable closeable;
        String string = properties.getProperty("net.argius.stu.connector.properties", EMPTY);
        if (string.length() > 0) {
            this.localProps = new Properties(properties);
            try {
                closeable = new FileInputStream(string);
                this.localProps.load((InputStream)closeable);
            }
            catch (IOException iOException) {}
        } else {
            this.localProps = properties;
            string = properties.getProperty("net.argius.stu.properties", EMPTY);
        }
        System.setProperty("net.argius.stu.connector.properties", string);
        this.connectorNameList.clear();
        try {
            String string2;
            closeable = new BufferedReader(new FileReader(string));
            Properties properties2 = new Properties();
            while ((string2 = ((BufferedReader)closeable).readLine()) != null) {
                properties2.clear();
                properties2.load(new ByteArrayInputStream(string2.getBytes()));
                Enumeration<Object> enumeration = properties2.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (!string3.toLowerCase().endsWith(".url") || !this.localProps.containsKey(string3)) continue;
                    int n = string3.length() - URL.length() - 1;
                    String string4 = string3.substring(0, n);
                    this.connectorNameList.add(string4);
                }
            }
        }
        catch (IOException iOException) {
            Application.addException(iOException);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.localProps.clear();
        this.connectorMap.clear();
        Properties properties = (Properties)propertyChangeEvent.getSource();
        this.initializeLocalProperties(properties);
        this.initializeConnectorList();
        this.initializeDriverList();
    }

    private void initializeConnectorList() {
        Iterator iterator = this.connectorNameList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null) continue;
            Properties properties = new Properties();
            properties.put(URL, this.localProps.getProperty(string + '.' + URL, EMPTY));
            properties.put(USER, this.localProps.getProperty(string + '.' + USER, EMPTY));
            properties.put(PASS, this.localProps.getProperty(string + '.' + PASS, EMPTY));
            properties.put(USERSPECIFIED, this.localProps.getProperty(string + '.' + USERSPECIFIED, "false"));
            properties.put(READONLY, this.localProps.getProperty(string + '.' + READONLY, "false"));
            this.connectorMap.put(string.toUpperCase(), properties);
        }
    }

    private void initializeDriverList() {
        Object object;
        int n;
        String string = System.getProperty(PROP_JDBC_DRIVERS, EMPTY);
        String string2 = this.localProps.getProperty(PROP_JDBC_DRIVERS_NAME, EMPTY);
        String string3 = this.localProps.getProperty(PROP_JDBC_DRIVERS_PATH, EMPTY);
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object2 = new StringTokenizer(string, ":");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            arrayList.add(((StringTokenizer)object2).nextToken());
        }
        object2 = new StringTokenizer(string2, ":");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            arrayList.add(((StringTokenizer)object2).nextToken());
        }
        object2 = new ArrayList();
        URL[] uRLArray = new StringTokenizer(string3, pathSeparator);
        while (uRLArray.hasMoreTokens()) {
            object2.add(new File(uRLArray.nextToken()));
        }
        uRLArray = new URL[object2.size()];
        int n2 = object2.size();
        for (n = 0; n < n2; ++n) {
            object = (File)object2.get(n);
            try {
                uRLArray[n] = ((File)object).toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.classloader = new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
        n = arrayList.size();
        this.driverClasses = new Driver[n];
        for (n2 = 0; n2 < n; ++n2) {
            try {
                object = (String)arrayList.get(n2);
                Class<?> clazz = Class.forName((String)object, false, this.classloader);
                this.driverClasses[n2] = (Driver)clazz.newInstance();
                continue;
            }
            catch (Throwable throwable) {
                this.driverClasses[n2] = null;
            }
        }
    }

    protected boolean isUserSpecified(String string) {
        Properties properties = (Properties)this.connectorMap.get(string.toUpperCase());
        String string2 = properties.getProperty(USERSPECIFIED, EMPTY);
        return string2.equalsIgnoreCase("true");
    }

    protected boolean isReadOnly(String string) {
        Properties properties = (Properties)this.connectorMap.get(string.toUpperCase());
        String string2 = properties.getProperty(READONLY, EMPTY);
        return string2.equalsIgnoreCase("true");
    }

    public Connection resolve(String string) throws SQLException {
        StringQueue stringQueue = new StringQueue(Function.split(string));
        String string2 = stringQueue.draw();
        String string3 = string2.toUpperCase();
        if (!this.connectorMap.containsKey(string3)) {
            throw new SQLException();
        }
        Properties properties = (Properties)this.connectorMap.get(string3);
        String string4 = properties.getProperty(URL);
        for (int i = 0; i < this.driverClasses.length; ++i) {
            Connection connection;
            Driver driver = this.driverClasses[i];
            if (driver == null || !driver.acceptsURL(string4)) continue;
            if (this.isUserSpecified(string2)) {
                connection = driver.connect(string4, properties);
            } else {
                Properties properties2 = new Properties();
                properties2.setProperty(USER, stringQueue.draw());
                properties2.setProperty(PASS, stringQueue.draw());
                connection = driver.connect(string4, properties2);
            }
            if (this.isReadOnly(string2)) {
                connection.setReadOnly(true);
            }
            return connection;
        }
        throw new SQLException("driver is not loaded.");
    }

    public List getConnectorNames() {
        return Arrays.asList(this.connectorNameList.toArray());
    }
}

