/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stu;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import net.argius.stu.Command;
import net.argius.stu.ConnectorManager;
import net.argius.stu.Environment;
import net.argius.stu.IOManager;
import net.argius.stu.Log;
import net.argius.stu.Option;
import net.argius.stu.Prompt;
import net.argius.stu.Version;
import net.argius.stu.io.NullPrinter;
import net.argius.stu.text.Function;
import net.argius.stu.text.StringQueue;

public final class Application
extends Thread
implements PropertyChangeListener {
    private static final String RESOURCE_PACKAGE = "net.argius.stu.messages";
    private static Version version;
    private static List exceptions;
    private static List threads;
    private static int serialNumber;
    private static DecimalFormat df;
    private boolean available;
    private static final Exception defaultException;
    private Environment env;
    private IOManager io;
    private Log log;
    private File workDirectory;
    private File systemDirectory;
    private ResourceBundle resource;
    private Prompt prompt;
    private boolean multiline;
    private String errorString;
    private String warningString;
    private ConnectorManager connectorManager;
    private Connection conn;
    private Command command;
    static /* synthetic */ Class class$net$argius$stu$Application;

    public static void startMain(String[] stringArray) {
        Environment environment = Environment.getEnvironment();
        environment.getLog().print(3, ">>> START <<<");
        environment.getLog().print(3, "STU version " + Application.getVersion().getVersionString());
        Application.startNew(stringArray);
        environment.waitExit();
        while (threads.size() > 0) {
        }
        environment.getLog().print(3, ">>> E N D <<<");
        System.exit(0);
    }

    public static final void startNew(String[] stringArray) {
        Environment environment = Environment.getEnvironment();
        Application application = new Application(environment);
        boolean bl = true;
        if (stringArray != null && stringArray.length > 0) {
            try {
                bl = application.executeWithOption(stringArray);
            }
            catch (RuntimeException runtimeException) {
                bl = false;
            }
        }
        if (bl) {
            application.start();
        } else {
            application.terminate();
            environment.notifyExit();
        }
    }

    private boolean executeWithOption(String[] stringArray) {
        Option option = new Option(stringArray);
        this.writeLog(4, "args = " + Arrays.asList(stringArray));
        this.writeLog(3, "option = " + option);
        try {
            String string;
            if (option.isSilent()) {
                this.io.setErrorPrinter(new NullPrinter());
            }
            if ((string = option.getConnectorName()).length() > 0) {
                this.connect(string);
            }
            if (option.isDirect()) {
                String string2 = option.getDirectString();
                if (string2.trim().length() <= 0) {
                    throw new RuntimeException("not specified command.");
                }
                Command command = this.getCommand(string2);
                command.execute(this.conn, string2);
                return false;
            }
        }
        catch (Exception exception) {
            this.error(exception.getMessage(), exception);
            Application.addException(exception);
        }
        return true;
    }

    public Application() {
        Environment environment = Environment.getEnvironment();
        this.log = environment.getLog();
        this.setName("STUB");
    }

    protected Application(Environment environment) {
        this.env = environment;
        this.log = environment.getLog();
        this.writeLog(3, "Main.<init> start");
        this.io = environment.createIOManager();
        this.io.setApplication(this);
        this.initialize(environment.getProperties());
        this.resource = environment.getResourceBundle(RESOURCE_PACKAGE);
        this.command = new Command(this);
        this.connectorManager = new ConnectorManager(environment.getProperties());
        this.prompt = new Prompt(environment.getProperties(), this.io);
        this.errorString = this.getPhrase("error");
        this.warningString = this.getPhrase("warning");
        environment.addPropertyChangeListener(this);
        environment.addPropertyChangeListener(this.command);
        environment.addPropertyChangeListener(this.connectorManager);
        environment.addPropertyChangeListener(this.prompt);
        this.setName("T" + df.format(++serialNumber));
        threads.add(this);
        this.available = true;
        this.writeLog(3, "Main.<init> end");
    }

    private void initialize(Properties properties) {
        String string = properties.getProperty("net.argius.stu.prompt.multiline");
        this.multiline = Boolean.valueOf(string);
    }

    protected static synchronized void addException(Exception exception) {
        exceptions.add(exception);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Properties properties = (Properties)propertyChangeEvent.getSource();
        this.initialize(properties);
    }

    private void terminate() {
        if (this.conn != null) {
            try {
                this.conn.rollback();
                this.writeLog(4, "rollbacked transaction.");
            }
            catch (SQLException sQLException) {
                this.writeLog(1, sQLException);
            }
            try {
                this.conn.close();
                this.writeLog(4, "released connection.");
            }
            catch (SQLException sQLException) {
                this.writeLog(1, sQLException);
            }
        }
        this.env.removePropertyChangeListener(this);
        this.env.removePropertyChangeListener(this.command);
        this.env.removePropertyChangeListener(this.connectorManager);
        this.env.removePropertyChangeListener(this.prompt);
        threads.remove(this);
        this.writeLog(4, "threads = " + threads.size());
        if (threads.size() == 0) {
            this.env.notifyExit();
        }
    }

    public void notifyExit() {
        this.writeLog(4, "notify exit.");
        this.available = false;
    }

    public IOManager getIOManager() {
        return this.io;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        this.writeLog(3, "Thread start.");
        StringQueue stringQueue = new StringQueue();
        if (exceptions.size() > 0) {
            this.message(this.getMessage("errorwhileinit"));
            int n = exceptions.size();
            for (int i = 0; i < n; ++i) {
                Exception exception = (Exception)exceptions.get(i);
                this.message("  " + exception.getMessage());
                this.writeLog(1, exception);
            }
            object = exceptions;
            synchronized (object) {
                exceptions.clear();
            }
        }
        while (this.available) {
            try {
                Object object2;
                object = stringQueue.size() == 0 ? this.prompt.getInput() : this.prompt.getInput(stringQueue.size() + 1);
                this.writeLog(4, "input : " + (String)object);
                if (object == null) {
                    throw new Exception("input stream is broken?");
                }
                if (((String)(object = ((String)object).trim())).length() == 0) continue;
                int n = ((String)object).indexOf(59);
                boolean bl = n >= 0;
                int n2 = ((String)object).indexOf(32);
                if (bl) {
                    int n3 = n2 >= 0 && n2 < n ? n2 : n;
                    object2 = ((String)object).substring(0, n3);
                } else {
                    object2 = n2 >= 0 ? ((String)object).substring(0, n2) : object;
                }
                if (stringQueue.size() == 0) {
                    n2 = 0;
                    if (((String)object2).equalsIgnoreCase("EXIT")) {
                        threads.clear();
                        this.available = false;
                        break;
                    }
                    if (((String)object2).equalsIgnoreCase("CLOSE")) {
                        this.io.close();
                        this.available = false;
                        break;
                    }
                    if (((String)object2).equalsIgnoreCase("RELOAD")) {
                        this.changeProperty();
                        n2 = 1;
                    } else if (((String)object2).equalsIgnoreCase("CONNECT")) {
                        StringQueue stringQueue2 = new StringQueue(Function.split((String)object));
                        stringQueue2.draw();
                        this.connect(stringQueue2.drawAll());
                        n2 = 1;
                    } else if (((String)object2).equalsIgnoreCase("DISCONNECT")) {
                        this.disconnect();
                        n2 = 1;
                    } else if (((String)object2).equalsIgnoreCase("COMMIT")) {
                        this.commit();
                        n2 = 1;
                    } else if (((String)object2).equalsIgnoreCase("ROLLBACK")) {
                        this.rollback();
                        n2 = 1;
                    }
                    if (n2 != 0) {
                        stringQueue.drawAll();
                        continue;
                    }
                }
                if (bl) {
                    if (!((String)object).substring(n).trim().equals(";")) {
                        this.warning("sentence after ';' not available. put it away.", defaultException);
                    }
                    stringQueue.inject(((String)object).substring(0, n));
                } else {
                    stringQueue.inject((String)object);
                    if (this.multiline) continue;
                }
                String string = stringQueue.drawAll();
                if (this.log.getLevel() >= 5) {
                    this.writeLog(5, "sentence : " + string);
                }
                this.getCommand(string).invoke(this.conn, string);
            }
            catch (SQLException sQLException) {
                this.error(sQLException.getMessage(), sQLException);
            }
            catch (RuntimeException runtimeException) {
                this.error(runtimeException.getMessage(), runtimeException);
            }
            catch (Exception exception) {
                this.error("unexpected error with : " + exception, exception);
                break;
            }
        }
        this.terminate();
        this.writeLog(3, "Thread end.");
    }

    public String getProperty(String string) {
        return this.getEnvironment().getProperty(string);
    }

    public void writeLog(int n, String string) {
        this.log.print(n, string);
    }

    public void writeLog(int n, Throwable throwable) {
        this.log.print(n, "", throwable);
    }

    public void writeLog(int n, String string, Throwable throwable) {
        this.log.print(n, string, throwable);
    }

    public int getLogLevel() {
        return this.log.getLevel();
    }

    public ResourceBundle getResourceBundle(String string) {
        return this.getEnvironment().getResourceBundle(string);
    }

    public List getConnectorNames() {
        return this.connectorManager.getConnectorNames();
    }

    public boolean isUserSpecified(String string) {
        return this.connectorManager.isUserSpecified(string);
    }

    public File getSystemDirectory() {
        if (this.systemDirectory == null) {
            String string = System.getProperty("user.home", "");
            String string2 = System.getProperty("java.io.tmpdir", "");
            String string3 = "." + Application.getVersion().getProductName().toLowerCase();
            this.systemDirectory = string.length() > 0 ? new File(string, string3) : (string2.length() > 0 ? new File(string2, string3) : this.getWorkDirectory());
            if (!this.systemDirectory.exists()) {
                this.systemDirectory.mkdirs();
            }
        }
        return this.systemDirectory;
    }

    public File getWorkDirectory() {
        if (this.workDirectory == null) {
            String string = this.getProperty("net.argius.stu.work.directory");
            this.workDirectory = string.length() > 0 ? new File(string) : new File(this.getProperty("user.dir"));
            if (!this.workDirectory.isDirectory()) {
                this.workDirectory = new File("./");
            }
            this.setWorkDirectory(this.workDirectory);
        }
        return this.workDirectory;
    }

    public synchronized void setWorkDirectory(File file) {
        System.setProperty("user.dir", file.getAbsolutePath());
        this.workDirectory = file;
    }

    private synchronized Environment getEnvironment() {
        if (this.env == null) {
            this.env = Environment.getEnvironment();
        }
        return this.env;
    }

    private Command getCommand(String string) {
        StringQueue stringQueue = new StringQueue(Function.split(string, 1));
        String string2 = stringQueue.draw();
        try {
            return this.command.getCommand(string2);
        }
        catch (RuntimeException runtimeException) {
            String string3 = this.getMessage("commandnotfound", string2.toUpperCase());
            throw new RuntimeException(string3);
        }
    }

    private void changeProperty() {
        this.writeLog(3, "Main.changeProperty() start");
        try {
            this.env.firePropertyChange();
            this.message(this.getPhrase("reloaded"));
        }
        catch (Exception exception) {
            this.writeLog(2, exception);
            this.warning(this.getPhrase("failedtoreload"), defaultException);
        }
        this.writeLog(3, "Main.changeProperty() end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(String string) throws SQLException {
        this.writeLog(3, "Main.connect() start");
        StringQueue stringQueue = new StringQueue(Function.split(string));
        String string2 = stringQueue.draw();
        try {
            this.releaseConnection(this.conn);
            try {
                this.conn = this.connectorManager.resolve(string);
            }
            catch (SQLException sQLException) {
                this.conn = null;
                String string3 = sQLException.getMessage();
                if (string3 == null || string3.length() == 0) {
                    throw new SQLException(this.getMessage("connectornotfound", string2));
                }
                throw sQLException;
            }
            String string4 = this.conn.getMetaData().getUserName();
            this.prompt.setParameters(string4, string2);
            this.message(this.getPhrase("connected"));
            this.writeLog(4, "connected to '" + string2 + "'");
            if (this.log.getLevel() >= 5) {
                DatabaseMetaData databaseMetaData = this.conn.getMetaData();
                this.writeLog(5, "[database information]");
                this.writeLog(5, "product : " + databaseMetaData.getDatabaseProductName());
                this.writeLog(5, "version : " + databaseMetaData.getDatabaseProductVersion());
                this.writeLog(5, "driver  : " + databaseMetaData.getDriverName());
                this.writeLog(5, "version : " + databaseMetaData.getDriverVersion());
            }
            try {
                this.conn.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                this.warning(this.getPhrase("autocommitmodenotsupported"), defaultException);
            }
            Object var7_9 = null;
            this.writeLog(4, "conn = " + this.conn);
            if (this.conn == null) {
                this.prompt.setParameters(null, null);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.writeLog(4, "conn = " + this.conn);
            if (this.conn == null) {
                this.prompt.setParameters(null, null);
            }
            throw throwable;
        }
        this.writeLog(3, "Main.connect() end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() throws SQLException {
        this.writeLog(3, "Main.disconnect() start");
        if (this.conn != null) {
            try {
                this.releaseConnection(this.conn);
                this.message(this.getPhrase("disconnected"));
                Object var2_1 = null;
                this.conn = null;
                this.prompt.setParameters(null, null);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.conn = null;
                this.prompt.setParameters(null, null);
                throw throwable;
            }
        } else {
            this.warning(this.getPhrase("notconnect"), defaultException);
        }
        this.writeLog(3, "Main.disconnect() end");
    }

    private void releaseConnection(Connection connection) throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    private void commit() {
        this.writeLog(3, "Main.commit() start");
        try {
            if (this.conn != null) {
                this.conn.commit();
                this.message(this.getPhrase("commited"));
            } else {
                this.warning(this.getPhrase("notconnect"), defaultException);
            }
        }
        catch (SQLException sQLException) {
            this.warning(sQLException.toString(), defaultException);
        }
        this.writeLog(3, "Main.commit() end");
    }

    private void rollback() {
        this.writeLog(3, "Main.rollback() start");
        try {
            if (this.conn != null) {
                this.conn.rollback();
                this.message(this.getPhrase("rollbacked"));
            } else {
                this.warning(this.getPhrase("notconnect"), defaultException);
            }
        }
        catch (SQLException sQLException) {
            this.warning(sQLException.toString(), defaultException);
        }
        this.writeLog(3, "Main.rollback() end");
    }

    protected final String getMessage(String string) {
        return this.getPhrase(string);
    }

    protected final String getMessage(String string, String string2) {
        String string3 = this.getMessage(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string3.length();
        for (int i = 0; i < n; ++i) {
            char c = string3.charAt(i);
            if (c == '$') {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String getPhrase(String string) {
        return this.resource.getString("stu.main." + string);
    }

    String getPhraseForCommand(String string) {
        return this.resource.getString("stu.command." + string);
    }

    private void message(String string) {
        try {
            this.io.printMessage(string, true);
        }
        catch (IOException iOException) {
            this.writeLog(1, "Application.message()", iOException);
        }
    }

    private void warning(String string, Throwable throwable) {
        this.writeLog(2, string, throwable);
        this.message(this.warningString + " : " + string);
    }

    private void error(String string, Throwable throwable) {
        this.writeLog(1, string, throwable);
        this.message(this.errorString + " : " + string);
    }

    public static synchronized Version getVersion() {
        if (version == null) {
            version = new Version(class$net$argius$stu$Application == null ? (class$net$argius$stu$Application = Application.class$("net.argius.stu.Application")) : class$net$argius$stu$Application);
        }
        return version;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        exceptions = new ArrayList();
        threads = new LinkedList();
        df = new DecimalFormat("000");
        defaultException = new Exception("(no exception)");
    }
}

