package net.argius.version;

import java.io.*;
import java.util.*;

/**
 * o[WB
 * sσNXB
 */
public final class Version implements Serializable, Comparable, Cloneable {

    private static final long serialVersionUID = -8929616242785956174L;

    private static final String EMPTY_STRING = "";
    private static final String PREFIX = "version.";
    private static final String FILE_NAME = PREFIX + "properties";
    private static final String KEY_MAJOR = PREFIX + "major";
    private static final String KEY_MINOR = PREFIX + "minor";
    private static final String KEY_REVISION = PREFIX + "revision";
    private static final String KEY_NOTE = PREFIX + "note";
    private static final String KEY_BUILD_NUMBER = PREFIX + "build.number";
    private static final String KEY_BUILD_TIME = PREFIX + "build.time";

    private transient String shortString;
    private transient String regularString;
    private transient String fullString;

    private final boolean valid;
    private final int majorNumber;
    private final int minorNumber;
    private final int revision;
    private final String note;
    private final int buildNumber;
    private final long buildTime;

    /**
     * Version̐B
     * @param majorNumber W[o[Wԍ (K{E[ȏ)
     * @param minorNumber }Ci[o[Wԍ (K{E[ȏ)
     * @param revision rW
     * @param note l
     * @param buildNumber rhԍ
     * @param buildTime rh(~b)
     */
    private Version(int majorNumber,
                    int minorNumber,
                    int revision,
                    String note,
                    int buildNumber,
                    long buildTime) {
        if (majorNumber < 0) {
            throw new IllegalArgumentException("majorNumber : " + majorNumber);
        }
        if (minorNumber < 0) {
            throw new IllegalArgumentException("minorNumber : " + minorNumber);
        }
        this.majorNumber = majorNumber;
        this.minorNumber = minorNumber;
        this.revision = revision;
        this.note = (note == null) ? EMPTY_STRING : note;
        this.buildNumber = buildNumber;
        this.buildTime = buildTime;
        initializeString();
        valid = true;
    }

    /**
     * Version̐B
     * ȃo[WB
     */
    private Version() {
        majorNumber = 0;
        minorNumber = 0;
        revision = 0;
        note = EMPTY_STRING;
        buildNumber = 0;
        buildTime = 0L;
        shortString = EMPTY_STRING;
        regularString = EMPTY_STRING;
        fullString = EMPTY_STRING;
        valid = false;
    }

    /**
     * \B
     */
    private void initializeString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(majorNumber);
        buffer.append('.');
        buffer.append(minorNumber);
        shortString = buffer.toString();
        buffer.append('.');
        buffer.append(revision);
        buffer.append(' ');
        buffer.append(note);
        regularString = buffer.toString();
        if (note.length() > 0) {
            buffer.append(' ');
        }
        buffer.append("[build #");
        buffer.append(buildNumber);
        buffer.append(' ');
        buffer.append(new Date(buildTime));
        buffer.append(']');
        fullString = buffer.toString();
    }

    /**
     * CX^X擾B
     * @param majorNumber W[ԍ (K{E[ȏ)
     * @param minorNumber }Ci[ԍ (K{E[ȏ)
     * @return CX^X
     */
    public static Version getInstance(int majorNumber, int minorNumber) {
        return getInstance(majorNumber,
                           minorNumber,
                           0,
                           EMPTY_STRING,
                           Integer.MIN_VALUE,
                           Long.MIN_VALUE);
    }

    /**
     * CX^X擾B
     * @param majorNumber W[o[Wԍ (K{E[ȏ)
     * @param minorNumber }Ci[o[Wԍ (K{E[ȏ)
     * @param revision rW
     * @param note l
     * @param buildNumber rhԍ
     * @param buildTime rh(~b)
     * @return CX^X
     */
    public static Version getInstance(int majorNumber,
                                      int minorNumber,
                                      int revision,
                                      String note,
                                      int buildNumber,
                                      long buildTime) {
        try {
            return new Version(majorNumber,
                               minorNumber,
                               revision,
                               note,
                               buildNumber,
                               buildTime);
        } catch (Exception ex) {
            return new Version();
        }
    }

    /**
     * CX^X̎擾B
     * ΏۃAvP[VƓpbP[WɊ܂܂
     * <code>version.properties</code> QƂA
     * o[W𐶐B
     * @param targetClass ΏۃNX
     * @return CX^X
     */
    public static Version getInstance(Class targetClass) {
        try {
            InputStream is = targetClass.getResourceAsStream(FILE_NAME);
            Properties props = new Properties();
            props.load(is);
            String buildNumberString = props.getProperty(KEY_BUILD_NUMBER);
            String buildTimeString = props.getProperty(KEY_BUILD_TIME);
            return new Version(Integer.parseInt(props.getProperty(KEY_MAJOR)),
                               Integer.parseInt(props.getProperty(KEY_MINOR)),
                               Integer.parseInt(props.getProperty(KEY_REVISION)),
                               props.getProperty(KEY_NOTE),
                               (buildNumberString == null)
                                       ? Integer.MIN_VALUE
                                       : Integer.parseInt(buildNumberString),
                               (buildTimeString == null
                                       ? Long.MIN_VALUE
                                       : Long.parseLong(buildTimeString)));
        } catch (IOException ex) {
            return new Version();
        } catch (RuntimeException ex) {
            return new Version();
        }
    }

    /**
     * o[W񂪂ꂽǂ𒲍B
     * @return o[W񂪂ꂽȂ<code>true</code>A
     *          łȂ<code>false</code>
     */
    public boolean isValid() {
        return valid;
    }

    /**
     * W[o[Wԍ̎擾B
     * @return W[o[Wԍ
     */
    public int getMajorNumber() {
        return majorNumber;
    }

    /**
     * }Ci[o[Wԍ̎擾B
     * @return }Ci[o[Wԍ
     */
    public int getMinorNumber() {
        return minorNumber;
    }

    /**
     * rW̎擾B
     * @return rW
     */
    public int getRevision() {
        return revision;
    }

    /**
     * l̎擾B
     * @return l
     */
    public String getNote() {
        return note;
    }

    /**
     * rhԍ̎擾B
     * ݒ肳ĂȂꍇAŏ̒lƂȂB
     * @return rhԍ
     */
    public int getBuildNumber() {
        return buildNumber;
    }

    /**
     * rh(~b)̎擾B
     * ݒ肳ĂȂꍇAŏ̒lƂȂB
     * @return rh(~b)
     */
    public long getBuildTime() {
        return buildTime;
    }

    /**
     * Zo[W̎擾B
     * \ĹuW[o[Wԍ + }Ci[o[WԍvŁA
     * ꂼ̍ڂ̓sIhi"."jŋ؂B
     * Ⴆ΁A <code>1.0</code> ̂悤ɕ\LB
     * @return Zo[W
     */
    public String getShortString() {
        return shortString;
    }

    /**
     * ʂ̃o[W̎擾B
     * \ĹuZo[W + rW + lvŁA 
     * ꂼ̍ڂ̓Xy[Xŋ؂B
     * Ⴆ΁A <code>1.0 5555 </code> ̂悤ɕ\LB
     * @return ʂ̃o[W
     */
    public String getRegularString() {
        return regularString;
    }

    /**
     * SĂ̏o[W̎擾B
     * \Ĺuʂ̃o[W + "(build:" + rhԍ + rh)vŁA
     * Ⴆ <code>1.0 5555  [build #654 Mon Jan 12 22:46:39 JST 1970]</code>
     * ̂悤ɕ\LB
     * @return SĂ̏o[W
     */
    public String getFullString() {
        return fullString;
    }

    /**
     * 񉻃IuWFNg𐳏ȕ@ŐB
     * @return IuWFNg
     * @throws ObjectStreamException IuWFNgXg[̃G[
     */
    private Object readResolve() throws ObjectStreamException {
        return getInstance(majorNumber,
                           minorNumber,
                           revision,
                           note,
                           buildNumber,
                           buildTime);
    }

    /**
     * ʂVersionIuWFNgƓerB
     *  != L ̏ꍇ́A  LB
     *  == L ̏ꍇ́AS <code>String</code> ƂĔrB
     * @param o ʂVersionIuWFNg
     * @return ̃IuWFNgw肳ꂽIuWFNg菬ꍇ͕̐A
     *         ꍇ̓[A
     *         傫ꍇ͐̐
     */
    public int compareTo(Version o) {
        if (o.valid != valid) {
            return (valid) ? -1 : 1;
        }
        return fullString.compareTo(o.fullString);
    }

    /**
     * ʂ̃IuWFNgƓerB
     * @param o ʂVersionIuWFNg
     * @return ̃IuWFNgw肳ꂽIuWFNg菬ꍇ͕̐A
     *         ꍇ̓[A
     *         傫ꍇ͐̐
     * @throws ClassCastException ʂ̃IuWFNg Version ȊȌꍇ
     */
    public int compareTo(Object o) {
        return compareTo((Version)o);
    }

    /* (overridden)
     * @see java.lang.Object#clone()
     */
    public Object clone() throws CloneNotSupportedException {
        Object o = super.clone();
        if (o instanceof Version) {
            return o;
        }
        throw new CloneNotSupportedException();
    }

    /* (overridden)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version o = (Version)obj;
            return (o.valid == valid && o.getFullString().equals(fullString));
        }
        return super.equals(obj);
    }

    /* (overridden)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        int result = 17;
        result = 37 * result + (valid ? 0 : 1);
        result = 37 * result + fullString.hashCode();
        return result;
    }

    /**
     * o[W̕\擾B
     * SĂ̏o[WƓB
     * @return \
     */
    public String toString() {
        return fullString;
    }

}