package net.argius.stew.io;

import java.io.*;

/**
 * ̓Xg[obt@B
 */
final class InputStreamBuffer {

    private final Reader reader;
    private final CharSequenceFIFO fifo;
    private final char[] chars;

    /**
     * InputStreamBuffer̐B
     * @param is ̓Xg[
     */
    InputStreamBuffer(InputStream is) {
        this.reader = new InputStreamReader(is);
        this.fifo = new CharSequenceFIFO(4096);
        this.chars = new char[1024];
    }

    /**
     * Xg[B
     * @throws IOException o̓G[ꍇ
     */
    void close() throws IOException {
        reader.close();
    }

    /**
     * obt@e̒wTCYɂȂ悤ɂB
     * Ȃꍇ͏[UB
     * @param size wTCY
     * @return [UɃTCY𖞂A[UĖ <code>true</code>
     *         [UȂꍇ <code>false</code>
     * @throws IOException o̓G[ꍇ
     */
    boolean fill(int size) throws IOException {
        while (fifo.length() < size) {
            int length = readChars();
            if (length <= 0) {
                break;
            }
        }
        return fifo.length() >= size;
    }

    /**
     * obt@𕥂oB
     * @return V[PX
     */
    CharSequence draw() {
        return fifo.draw();
    }

    /**
     * obt@𕥂oB
     * @param position ʒu
     * @return V[PX
     */
    CharSequence draw(int position) {
        return fifo.draw(position);
    }

    /**
     * ̓Xg[SẴf[^obt@ɓǂݍށB
     * @return ǂݍ񂾃f[^
     * @throws IOException o̓G[ꍇ
     */
    int readAll() throws IOException {
        int total = 0;
        while (true) {
            int length = readChars();
            if (length < 0) {
                break;
            }
            total += length;
        }
        return total;
    }

    /**
     * ʓǂݍށB
     * @return ǂݍ񂾕
     * @throws IOException o̓G[ꍇ
     */
    int readChars() throws IOException {
        int length = reader.read(chars);
        if (length > 0) {
            fifo.add(chars, 0, length);
        }
        return length;
    }

    /**
     * obt@w肵B
     * @param c 
     * @param fromIndex Jnʒu
     * @param autoFill ȂɎIɓǂݍޏꍇ <code>true</code>
     * @return ŏɏoʒu Ȃꍇ <code>-1</code>
     * @throws IOException o̓G[ꍇ
     */
    int indexOf(char c, int fromIndex, boolean autoFill) throws IOException {
        while (true) {
            int index = fifo.indexOf(c, fromIndex);
            if (index >= 0) {
                return index;
            }
            if (!autoFill || readChars() <= 0) {
                return -1;
            }
        }
    }

    /**
     * obt@w肵B
     * @param s 
     * @param fromIndex Jnʒu
     * @param autoFill ȂɎIɓǂݍޏꍇ <code>true</code>
     * @return ŏɏoʒu Ȃꍇ <code>-1</code>
     * @throws IOException o̓G[ꍇ
     */
    int indexOf(String s, int fromIndex, boolean autoFill) throws IOException {
        while (true) {
            int index = fifo.indexOf(s, fromIndex);
            if (index >= 0) {
                return index;
            }
            if (!autoFill || readChars() <= 0) {
                return -1;
            }
        }
    }

    /**
     * ǂݍށB
     * @param index ʒu
     * @return 
     */
    char charAt(int index) {
        return fifo.charAt(index);
    }

    /**
     * ێĂf[^̒ԂB
     * @return f[^̒
     */
    int length() {
        return fifo.length();
    }

}