package net.argius.stew.io;

import java.io.*;

/**
 * HTML`̃GNX|[gB
 */
public final class HtmlExporter extends Exporter {

    private PrintWriter out;

    /**
     * HtmlExporter̐B
     * @param os o̓Xg[
     * @param title ^Cg
     */
    public HtmlExporter(OutputStream os, String title) {
        super(os);
        this.out = new PrintWriter(os);
        out.println("<html>");
        out.println("<head>");
        out.print("<title>");
        out.print(title);
        out.println("</title>");
        out.println("</head>");
        out.println("<body>");
        out.print("<h1>");
        out.print(title);
        out.println("</h1>");
        out.println("<table>");
        out.flush();
    }

    /* (overridden)
     * @see net.argius.stew.io.Exporter#writeHeader(java.lang.Object[])
     */
    protected void writeHeader(Object[] row) throws IOException {
        out.println("<tr>");
        for (int i = 0; i < row.length; i++) {
            out.print("<th>");
            out.print(row[i]);
            out.println("</th>");
        }
        out.println("</tr>");
        out.flush();
    }

    /* (overridden)
     * @see net.argius.stew.io.Exporter#close()
     */
    public void close() throws IOException {
        try {
            if (out != null) {
                out.println("</table>");
                out.println("</body>");
                out.println("</html>");
                out.flush();
                out.close();
            }
        } finally {
            out = null;
            super.close();
        }
    }

    /* (overridden)
     * @see net.argius.stew.io.Exporter#appendRow(java.lang.Object[])
     */
    public void addRow(Object[] row) {
        out.println("<tr>");
        for (int i = 0; i < row.length; i++) {
            out.print("<td>");
            out.print(row[i]);
            out.println("</td>");
        }
        out.println("</tr>");
        out.flush();
    }

}