package net.argius.stew.gui;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;

import javax.swing.*;
import javax.swing.table.*;

/**
 * ResultSetTable̍swb_B
 */
final class ResultSetTableRowHeader extends JTable implements
                                                  PropertyChangeListener {

    private static final int DEFAULT_WIDTH = 40;

    private final JTable table;
    private final DefaultTableModel model;
    private final ContextMenu contextMenu;

    private int dragStartRow;

    /**
     * ResultSetTableRowHeader̐B
     * @param table JTable
     */
    public ResultSetTableRowHeader(JTable table) {
        this.table = table;
        this.model = new DefaultTableModel(0, 1) {

            public boolean isCellEditable(int row, int column) {
                return false;
            }

        };
        this.contextMenu = new ContextMenu(table);
        setModel(model);
        setFocusable(false);
        table.addPropertyChangeListener(this);
    }

    /* (overridden)
     * @see javax.swing.JTable#getCellRenderer(int, int)
     */
    public TableCellRenderer getCellRenderer(int row, int column) {
        return ResultSetTableRowNumberCellRenderer.INSTANCE;
    }

    /* (overridden)
     * @see java.beans.PropertyChangeListener#propertyChange(java.beans.PropertyChangeEvent)
     */
    public void propertyChange(PropertyChangeEvent e) {
        if (table == null) {
            return;
        }
        String propertyName = e.getPropertyName();
        if (propertyName.equals("enabled")) {
            boolean isEnabled = table.isEnabled();
            setVisible(isEnabled);
            if (isEnabled) {
                setWidth();
                resetViewPosition();
            }
        } else if (propertyName.equals("font")) {
            setFont(table.getFont());
        } else if (propertyName.equals("rowHeight")) {
            setRowHeight(table.getRowHeight());
        }
    }

    /**
     * ̐ݒB
     */
    private void setWidth() {
        int rowCount = table.getRowCount();
        model.setRowCount(rowCount);
        Dimension d = getSize();
        JLabel label = new JLabel(String.valueOf(rowCount * 1000L));
        if (label.getPreferredSize().width > DEFAULT_WIDTH) {
            d.width = label.getPreferredSize().width;
        } else {
            d.width = DEFAULT_WIDTH;
        }
        setPreferredScrollableViewportSize(d);
    }

    /**
     * r[ʒuZbgB
     * e[u͍ĕ`悵ɃXN[ʒu(r[̈ʒu)ێ邪A
     * ̏Ԃ͍swb_ɂ͔fȂ߁AIɂsB
     */
    private void resetViewPosition() {
        Container p1 = table.getParent();
        Container p2 = getParent();
        if (p1 instanceof JViewport && p2 instanceof JViewport) {
            JViewport v1 = (JViewport)p1;
            JViewport v2 = (JViewport)p2;
            v2.setViewPosition(v1.getViewPosition());
        }
    }

    /**
     * sǉB
     * @param row s
     */
    void addRow(Object[] row) {
        model.addRow(row);
    }

    /**
     * s폜B
     * @param row s
     */
    void removeRow(int row) {
        model.removeRow(row);
    }

    /* (overridden)
     * @see java.awt.Component#processMouseEvent(java.awt.event.MouseEvent)
     */
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == MouseEvent.MOUSE_PRESSED) {
            changeTableRowSelection(e);
            contextMenu.mouseClicked(e);
        }
    }

    /* (overridden)
     * @see javax.swing.JComponent#processMouseMotionEvent(java.awt.event.MouseEvent)
     */
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == MouseEvent.MOUSE_DRAGGED) {
            changeTableRowSelection(e);
        }
    }

    /**
     * e[ȗIԂύXB
     * @param e }EXCxg
     */
    void changeTableRowSelection(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        if (SwingUtilities.isLeftMouseButton(e)) {
            int id = e.getID();
            boolean isMousePressed = id == MouseEvent.MOUSE_PRESSED;
            boolean isMouseDragged = id == MouseEvent.MOUSE_DRAGGED;
            if (isMousePressed || isMouseDragged) {
                if (!e.isControlDown() && !e.isShiftDown()) {
                    table.clearSelection();
                }
                int rowIndex = rowAtPoint(p);
                if (rowIndex < 0 || getRowCount() < rowIndex) {
                    return;
                }
                int index0;
                int index1;
                if (isMousePressed) {
                    if (e.isShiftDown()) {
                        index0 = dragStartRow;
                        index1 = rowIndex;
                    } else {
                        dragStartRow = rowIndex;
                        index0 = rowIndex;
                        index1 = rowIndex;
                    }
                } else if (isMouseDragged) {
                    index0 = dragStartRow;
                    index1 = rowIndex;
                } else {
                    return;
                }
                table.addRowSelectionInterval(index0, index1);
                table.addColumnSelectionInterval(table.getColumnCount() - 1, 0);
                table.requestFocus();
            }
        }
    }

}
