package net.argius.stew.gui;

import java.math.*;
import java.sql.*;
import java.util.*;

import javax.swing.*;
import javax.swing.table.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * ʃZbge[utTableModelB
 * ɍXV@\gĂB
 */
class ResultSetTableModel extends DefaultTableModel {

    private static final long serialVersionUID = 6814361740331839406L;
    private static final String INSERT_MARK = "*";
    private static final Comparator CMP = new ResultSetValueComparator();

    private static final Logger log = LoggerFactory.getLogger(ResultSetTableModel.class);

    private final int[] types;
    private final ResultSetTableRowHeader rowHeader;

    private final transient ResultSetTableMonitor monitor;

    /**
     * ResultSetTableModel̐B
     * @param size TCY
     * @param types ě^(java.sql.Types)
     * @param monitor ResultSetTableMonitor
     * @param rowHeader ResultSetTableRowHeader
     */
    ResultSetTableModel(int size,
                        int[] types,
                        ResultSetTableMonitor monitor,
                        ResultSetTableRowHeader rowHeader) {
        super(0, size);
        this.types = (int[])types.clone();
        this.monitor = monitor;
        this.rowHeader = rowHeader;
    }

    /* (overridden)
     * @see javax.swing.table.TableModel#getColumnClass(int)
     */
    public Class getColumnClass(int columnIndex) {
        switch (types[columnIndex]) {
            case Types.CHAR:
            case Types.VARCHAR:
            case Types.LONGVARCHAR:
                return String.class;
            case Types.BIT:
                return Boolean.class;
            case Types.TINYINT:
                return Byte.class;
            case Types.SMALLINT:
                return Short.class;
            case Types.INTEGER:
                return Integer.class;
            case Types.BIGINT:
                return Long.class;
            case Types.REAL:
                return Float.class;
            case Types.DOUBLE:
            case Types.FLOAT:
                return Double.class;
            case Types.DECIMAL:
            case Types.NUMERIC:
                return BigDecimal.class;
            case Types.DATE:
            case Types.TIME:
            case Types.TIMESTAMP:
            default:
                return Object.class;
        }
    }

    /* (overridden)
     * @see javax.swing.table.DefaultTableModel#isCellEditable(int, int)
     */
    public boolean isCellEditable(int row, int column) {
        if (!isInsertRow(row) && !monitor.isUpdatable()) {
            return false;
        }
        return super.isCellEditable(row, column);
    }

    /* (overridden)
     * @see javax.swing.table.DefaultTableModel#removeRow(int)
     */
    public void removeRow(int row) {
        super.removeRow(row);
        rowHeader.removeRow(row);
    }

    /**
     * ̃e[uXV\ǂ𒲍B
     * @return ̃e[uXV\Ȃ<code>true</code>AłȂ<code>false</code>
     */
    boolean isUpdatable() {
        return monitor.isUpdatable();
    }

    /**
     * s}ƂĒǉB
     * @param row s
     */
    void addRowAsInsert(Object[] row) {
        addRow(row);
        rowHeader.addRow(new Object[]{INSERT_MARK});
    }

    /**
     * }sǂ𒲍B
     * @param rowIndex sCfbNX
     * @return }sȂ<code>true</code>AłȂ<code>false</code>
     */
    boolean isInsertRow(int rowIndex) {
        if (rowIndex < 0 || rowHeader.getRowCount() <= rowIndex) {
            return false;
        }
        Object mark = rowHeader.getValueAt(rowIndex, 0);
        return String.valueOf(mark).equals(INSERT_MARK);
    }

    /**
     * Z̕ҏW𔽉fB
     * @param table e[u
     * @param editor ҏW̃GfB^
     */
    void updateCellEdited(ResultSetTable table, CellEditor editor) {
        try {
            int columnIndex = table.getEditingColumn();
            int rowIndex = table.getEditingRow();
            if (table.getCellEditor(rowIndex, columnIndex) == editor) {
                updateValueChanged(table,
                                   rowIndex,
                                   columnIndex,
                                   getValueAt(rowIndex, columnIndex),
                                   editor.getCellEditorValue());
                return;
            }
        } catch (SQLException ex) {
            onError(ex);
        } catch (RuntimeException ex) {
            onError(ex);
        }
        editor.cancelCellEditing();
    }

    /**
     * l̕ύX𔽉fB
     * @param table e[u
     * @param rowIndex sCfbNX
     * @param columnIndex CfbNX
     * @param oldValue ύXO̒l
     * @param newValue ύX̒l
     * @throws SQLException SQL֘AG[ꍇ
     */
    void updateValueChanged(JTable table,
                            int rowIndex,
                            int columnIndex,
                            Object oldValue,
                            Object newValue) throws SQLException {
        if (CMP.compare(oldValue, newValue) == 0) {
            if (log.isDebugEnabled()) {
                log.debug("skip to update.");
            }
        } else if (!isInsertRow(rowIndex)) {
            String[] keys = getKeys(table);
            Map rowData = getRowData(keys, rowIndex);
            String targetKey = keys[columnIndex];
            NamedValue target = new NamedValue(targetKey, newValue);
            monitor.update(rowData, target);
        }
    }

    /**
     * s}𔽉fB
     * IĂsB
     * @param table e[u
     * @throws SQLException 
     * @deprecated
     */
    void updateRowInserted(JTable table) throws SQLException {
        int rowIndex = table.getSelectedRow();
        updateRowInserted(table, rowIndex);
    }

    /**
     * s}𔽉fB
     * @param table e[u
     * @param rowIndex sCfbNX
     * @throws SQLException 
     */
    void updateRowInserted(JTable table, int rowIndex) throws SQLException {
        String[] keys = getKeys(table);
        Map rowData = getRowData(keys, rowIndex);
        monitor.insert(rowData);
        rowHeader.setValueAt(StringClass.EMPTY, rowIndex, 0);
    }

    /**
     * s폜𔽉fB
     * IĂsB
     * @param table e[u
     * @throws SQLException 
     * @deprecated
     */
    void updateRowDeleted(JTable table) throws SQLException {
        int[] rowIndexes = table.getSelectedRows();
        updateRowDeleted(table, rowIndexes);
    }

    /**
     * s폜𔽉fB
     * @param table e[u
     * @param rowIndexes sCfbNX
     * @throws SQLException 
     */
    void updateRowDeleted(JTable table, int[] rowIndexes) throws SQLException {
        String[] keys = getKeys(table);
        for (int i = 0; i < rowIndexes.length; i++) {
            int rowIndex = rowIndexes[i];
            Map rowData = getRowData(keys, rowIndex);
            monitor.delete(rowData);
        }
    }

    /**
     * L[ꗗ̎擾B
     * @param table e[u
     * @return L[ꗗ
     */
    private String[] getKeys(JTable table) {
        List keyList = new ArrayList();
        TableColumnModel model = table.getColumnModel();
        for (int i = 0, n = table.getColumnCount(); i < n; i++) {
            Object key = model.getColumn(i).getHeaderValue();
            keyList.add(key.toString());
        }
        return (String[])keyList.toArray(new String[keyList.size()]);
    }

    /**
     * sf[^̎擾B
     * @param keys L[ꗗ
     * @param rowIndex sCfbNX
     * @return sf[^
     */
    private Map getRowData(String[] keys, int rowIndex) {
        Map rowData = new LinkedHashMap();
        for (int columnIndex = 0, n = keys.length; columnIndex < n; columnIndex++) {
            Object key = keys[columnIndex];
            Object value = getValueAt(rowIndex, columnIndex);
            rowData.put(key, value);
        }
        return rowData;
    }

    /**
     * G[̏B
     * @param th G[
     */
    private void onError(Throwable th) {
        log.error("", th);
        DialogMessage.alert(th.getMessage());
    }

}