package net.argius.stew.gui;

import java.awt.event.*;
import java.util.*;

import javax.swing.*;

import net.argius.stew.*;

/**
 * ڑXg\ANVB
 */
final class ConnectorListAction extends AbstractAction {

    private final WindowOutputProcessor op;
    private final Environment env;

    /**
     * ConnectorListAction̐B
     * @param op OutputProcessor
     * @param env s
     */
    ConnectorListAction(WindowOutputProcessor op, Environment env) {
        this.op = op;
        this.env = env;
    }

    /* (overridden)
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent e) {
        env.updateConnectorMap();
        Map m = env.getConnectorMap();
        if (m.isEmpty()) {
            Exception ex = new IllegalStateException(Messages.getString("dialog.connectorlist.nolist"));
            op.onError(ex);
        } else {
            List elementList = new ArrayList();
            for (Iterator it = m.values().iterator(); it.hasNext();) {
                Connector connector = (Connector)it.next();
                elementList.add(new ConnectorListElement(connector));
            }
            Object input = DialogMessage.select(op.window,
                                                Messages.getString("dialog.connectorlist.header"),
                                                elementList.toArray());
            if (input != null) {
                ConnectorListElement element = (ConnectorListElement)input;
                String command = "connect " + element.getConnector().getId();
                op.consoleTextArea.replace(command);
                op.consoleTextArea.sendCommand();
            }
        }
    }

    /**
     * ڑXg̗vfB
     */
    private static final class ConnectorListElement {

        private final Connector connector;

        /**
         * ConnectorListElement̐B
         * @param connenctor Connector
         */
        ConnectorListElement(Connector connenctor) {
            this.connector = connenctor;
        }

        /**
         * Connector̎擾B
         * @return Connector
         */
        Connector getConnector() {
            return connector;
        }

        /* (overridden)
         * @see java.lang.Object#toString()
         */
        public String toString() {
            return connector.getId() + " (" + connector.getName() + ")";
        }

    }

}