package net.argius.stew.command;

import java.io.*;
import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;
import net.argius.stew.io.*;

/**
 * f[^t@C荞ރR}hB
 *
 * t@C`́Agqɂ莩IɑIB
 * <ul>
 * <li>gq"csv"̏ꍇCSV`Ƃăt@CǂݍށB
 * <li>LȊȌꍇ̓^u؂`Ƃăt@CǂݍށB
 * </ul>
 * 
 * "Load"R}hƈقȂA"batch"gpB
 */
public final class Import extends Load {

    private static final Logger log = LoggerFactory.getLogger(Import.class);
    private static final String USAGE = getUsage("import");
    private static final String PROP_BATCH_LIMIT = "net.argius.stew.command.Import.batch.limit";
    private static final int DEFAULT_BATCH_LIMIT = 10000;

    /* (overridden)
     * @see net.argius.stew.CommandInterface#execute(java.sql.Connection, net.argius.stew.Parameter)
     */
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(USAGE);
        }
        // 
        int argsIndex = 2;
        String p1 = parameter.get(argsIndex++);
        String p2 = parameter.get(argsIndex++);
        String p3 = parameter.get(argsIndex++);
        boolean hasHeader = p3.equalsIgnoreCase("header");
        if (log.isDebugEnabled()) {
            log.debug("file : " + p1);
            log.debug("table : " + p2);
            log.debug("hasHeader : " + hasHeader);
        }
        try {
            // s
            loadRecord(conn, new File(p1), p2, hasHeader);
        } catch (IOException ex) {
            throw new CommandException(ex);
        } catch (SQLException ex) {
            SQLException next = ex.getNextException();
            if (next != null && next != ex) {
                log.error("next exception: ", next);
            }
            throw new CommandException(ex);
        }
    }

    /* (overridden)
     * @see net.argius.stew.command.Load#insertRecords(java.sql.PreparedStatement, net.argius.stew.io.Importer)
     */
    protected void insertRecords(PreparedStatement stmt, Importer importer) throws IOException, SQLException {
        final int batchLimit;
        String s = LocalSystem.getProperty(PROP_BATCH_LIMIT);
        if (StringClass.isBlank(s)) {
            batchLimit = DEFAULT_BATCH_LIMIT;
        } else {
            int value;
            try {
                value = Integer.parseInt(s);
            } catch (NumberFormatException ex) {
                log.warn("property error: " + PROP_BATCH_LIMIT, ex);
                value = DEFAULT_BATCH_LIMIT;
            }
            batchLimit = value;
        }
        if (log.isDebugEnabled()) {
            log.debug("batch limit = " + batchLimit);
        }
        int recordCount = 0;
        int insertedCount = 0;
        int errorCount = 0;
        while (true) {
            Object[] row = importer.nextRow();
            final boolean eof = row.length == 0;
            if (!eof) {
                ++recordCount;
                try {
                    for (int i = 0; i < row.length; i++) {
                        stmt.setObject(i + 1, row[i]);
                    }
                    stmt.addBatch();
                } catch (SQLException ex) {
                    String message = "error occurred at " + recordCount;
                    if (log.isTraceEnabled()) {
                        log.trace(message, ex);
                    } else if (log.isDebugEnabled()) {
                        log.debug(message + " : " + ex);
                    }
                    ++errorCount;
                }
            }
            if (recordCount % batchLimit == 0 || eof) {
                int inserted = executeBatch(stmt);
                insertedCount += inserted;
                if (log.isDebugEnabled()) {
                    log.debug("record/inserted = " + recordCount + "/" + insertedCount);
                }
                if (eof) {
                    break;
                }
            }
        }
        if (errorCount > 0) {
            log.warn("error count = " + errorCount);
        }
        outputMessage(".loaded", new Object[]{new Integer(insertedCount), new Integer(recordCount)});
    }

    /**
     * ob`sB
     * @param stmt PreparedStatement
     * @return XV
     * @throws SQLException SQLG[
     */
    private int executeBatch(PreparedStatement stmt) throws SQLException {
        int[] results = stmt.executeBatch();
        int resultCount = 0;
        int noInfoCount = 0;
        int failedCount = 0;
        for (int i = 0; i < results.length; i++) {
            int result = results[i];
            switch (result) {
                case 1:
                    ++resultCount; // 1INSERT
                    break;
                case Statement.SUCCESS_NO_INFO:
                    ++noInfoCount;
                    ++resultCount; // 1INSERT
                    break;
                case Statement.EXECUTE_FAILED:
                    ++failedCount;
                    break;
                default:
                    throw new IllegalStateException("result=" + result);
            }
        }
        if (failedCount > 0) {
            log.warn("failedCount = " + failedCount);
        }
        if (noInfoCount > 0) {
            log.warn("noInfoCount = " + noInfoCount);
        }
        if (resultCount != results.length) {
            log.warn("array size = " + results.length + ", but result count = " + resultCount);
        }
        stmt.clearBatch();
        return resultCount;
    }

}