/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

public final class CharSequenceFIFO
implements CharSequence {
    private static final int DEFAULT_CAPACITY = 16;
    private char[] buffer;
    private int limit;

    public CharSequenceFIFO() {
        this(16);
    }

    public CharSequenceFIFO(int n) {
        this.buffer = new char[n];
        this.limit = 0;
    }

    public char charAt(int n) {
        this.checkRange(n);
        return this.buffer[n];
    }

    public int length() {
        return this.limit;
    }

    public CharSequence subSequence(int n, int n2) {
        this.checkRange(n2);
        return new String(this.buffer, n, n2 - n);
    }

    public void add(char c) {
        this.ensure(1);
        this.buffer[this.limit++] = c;
    }

    public void add(char[] cArray) {
        this.add(cArray, 0, cArray.length);
    }

    public void add(char[] cArray, int n, int n2) {
        this.ensure(n2);
        System.arraycopy(cArray, n, this.buffer, this.limit, n2);
        this.limit += n2;
    }

    public void add(String string) {
        int n = string.length();
        this.ensure(n);
        string.getChars(0, n, this.buffer, this.limit);
        this.limit += n;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(char c, int n) {
        int n2;
        if (n >= this.limit) {
            return -1;
        }
        int n3 = n2 = n < 0 ? 0 : n;
        while (n2 < this.limit) {
            if (this.buffer[n2] == c) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        int n2 = string.length();
        if (n2 <= 0) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        char c = cArray[0];
        if (n < 0) {
            n = 0;
        }
        if (n2 == 1) {
            return this.indexOf(c, n);
        }
        int n3 = this.limit - n2 + 1;
        block0: for (int i = n; i < n3; ++i) {
            int n4;
            boolean bl = false;
            for (n4 = i; n4 < n3; ++n4) {
                if (this.buffer[n4] != c) continue;
                bl = true;
                i = n4;
                break;
            }
            if (!bl) break;
            for (n4 = 1; n4 < n2; ++n4) {
                if (this.buffer[i + n4] == cArray[n4]) continue;
                continue block0;
            }
            return i;
        }
        return -1;
    }

    public CharSequence draw() {
        return this.draw(this.limit);
    }

    public CharSequence draw(int n) {
        int n2 = Math.min(n, this.limit);
        String string = new String(this.buffer, 0, n2);
        int n3 = this.buffer.length;
        System.arraycopy(this.buffer, n, this.buffer, 0, n3 - n);
        this.limit -= n;
        return string;
    }

    private void ensure(int n) {
        int n2;
        int n3 = this.buffer.length;
        if (n3 > this.limit + n) {
            return;
        }
        for (n2 = n3; n2 < n3 + n; n2 <<= 1) {
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.buffer, 0, cArray, 0, n3);
        this.buffer = cArray;
    }

    private void checkRange(int n) {
        if (n < 0 || n > this.limit) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CharSequenceFIFO charSequenceFIFO = (CharSequenceFIFO)object;
        if (this.limit != charSequenceFIFO.limit) {
            return false;
        }
        for (int i = 0; i < this.limit; ++i) {
            if (this.buffer[i] == charSequenceFIFO.buffer[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + CharSequenceFIFO.hashCode(this.buffer);
        n = 31 * n + this.limit;
        return n;
    }

    private static int hashCode(char[] cArray) {
        int n = 31;
        int n2 = 1;
        for (int i = 0; i < cArray.length; ++i) {
            n2 = n * n2 + cArray[i];
        }
        return n2;
    }

    public String toString() {
        return new String(this.buffer, 0, this.limit);
    }
}

