/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import net.argius.stew.Environment;
import net.argius.stew.gui.Menu;
import net.argius.stew.gui.Messages;
import net.argius.stew.gui.WindowConfiguration;
import net.argius.stew.gui.WindowOutputProcessor;

final class Window
extends JFrame {
    private Environment env;
    private WindowOutputProcessor op;

    Window(Environment environment, WindowOutputProcessor windowOutputProcessor) {
        this.op = windowOutputProcessor;
        this.env = environment;
        this.setDefaultCloseOperation(0);
        String string = "Stew";
        int n = windowOutputProcessor.getSequencialNumber();
        if (n > 1) {
            string = string + " (" + n + ")";
        }
        this.setTitle(string);
        this.setIconImage(Window.loadIcon().getImage());
    }

    static ImageIcon loadIcon() {
        try {
            return new ImageIcon(Window.class.getResource("icon.gif"));
        }
        catch (RuntimeException runtimeException) {
            return new ImageIcon();
        }
    }

    void loadConfiguration() {
        try {
            WindowConfiguration.load(this, this.env.getSystemDirectory());
        }
        catch (IOException iOException) {
            this.op.onError(iOException);
        }
        catch (RuntimeException runtimeException) {
            String string = Messages.getString("message.configurationfilebroken");
            this.op.onError(new Exception(MessageFormat.format(string, "Window"), runtimeException));
            WindowConfiguration windowConfiguration = new WindowConfiguration();
            windowConfiguration.apply(this);
        }
    }

    int getDividerLocation() {
        return this.op.splitPane.getDividerLocation();
    }

    void setDividerLocation(int n) {
        this.op.splitPane.setDividerLocation(n);
    }

    public Font getFont() {
        return this.op.getFont();
    }

    public void setFont(Font font) {
        this.op.onFontChanged(font);
    }

    boolean getStatusBarVisibility() {
        return this.op.statusBarLabel.isVisible();
    }

    void setStatusBarVisibility(boolean bl) {
        this.op.statusBarLabel.setVisible(bl);
        Menu menu = (Menu)this.getJMenuBar();
        menu.checkBoxStatusBarVisibility.setSelected(bl);
    }

    void setAllComponentsEnabled(boolean bl) {
        this.setAllComponentsEnabled(this, bl);
    }

    private void setAllComponentsEnabled(Container container, boolean bl) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                Container container2 = (Container)component;
                this.setAllComponentsEnabled(container2, bl);
            }
            component.setEnabled(bl);
        }
    }

    public void dispose() {
        try {
            WindowConfiguration.save(this, this.env.getSystemDirectory());
        }
        catch (Throwable throwable) {
            this.op.onError(throwable);
        }
        this.env = null;
        this.op = null;
        super.dispose();
    }
}

