/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public final class TextSearchMatcher {
    private Pattern pattern;
    private String string;
    private boolean useRegularExpression;
    private boolean ignoreCase;
    private boolean backward;
    private boolean continuously;
    private int start;
    private int end;

    public TextSearchMatcher(String string, boolean bl, boolean bl2) {
        if (bl) {
            int n = bl2 ? 2 : 0;
            this.pattern = Pattern.compile(string, n);
            this.string = string;
        } else {
            this.string = bl2 ? string.toUpperCase() : string;
        }
        this.useRegularExpression = bl;
        this.ignoreCase = bl2;
    }

    public Highlighter.HighlightPainter getHighlightPainter() {
        return new DefaultHighlighter.DefaultHighlightPainter(Color.decode("#33dd66"));
    }

    public boolean isBackward() {
        return this.backward;
    }

    public void setBackward(boolean bl) {
        this.backward = bl;
    }

    public boolean isContinuously() {
        return this.continuously;
    }

    public void setContinuously(boolean bl) {
        this.continuously = bl;
    }

    public boolean find(String string) {
        return this.find(string, 0);
    }

    public boolean find(String string, int n) {
        boolean bl;
        this.start = -1;
        this.end = -1;
        if (this.useRegularExpression) {
            Matcher matcher = this.pattern.matcher(string);
            bl = matcher.find(n);
            if (bl) {
                this.start = matcher.start();
                this.end = matcher.end();
            }
        } else {
            String string2 = this.ignoreCase ? string.toUpperCase() : string;
            int n2 = string2.indexOf(this.string, n);
            boolean bl2 = bl = n2 >= n;
            if (bl) {
                this.start = n2;
                this.end = n2 + this.string.length();
            }
        }
        return bl;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }
}

