/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import net.argius.stew.CipherPassword;
import net.argius.stew.Environment;
import net.argius.stew.gui.ConnectorListAction;
import net.argius.stew.gui.ConsoleTextArea;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.HelpInfoAction;
import net.argius.stew.gui.MenuConfiguration;
import net.argius.stew.gui.Messages;
import net.argius.stew.gui.ResultSetTable;
import net.argius.stew.gui.TextSearch;
import net.argius.stew.gui.VersionInfoAction;
import net.argius.stew.gui.Window;
import net.argius.stew.gui.WindowOutputProcessor;

final class Menu
extends JMenuBar {
    static final int DEFAULT_LIMIT_COUNT = 1000;
    final JCheckBoxMenuItem checkBoxStatusBarVisibility;
    final JCheckBoxMenuItem checkBoxShowColumnNumber;
    Object focused;
    private final Environment env;
    private final WindowOutputProcessor op;
    private final Window window;
    private final ConsoleTextArea consoleTextArea;
    private final ResultSetTable resultSetTable;
    private final JLabel statusBarLabel;
    private final JSpinner viewLimitCountSpinner;
    private final ColumnAdjustModeButtonGroup columnAdjustModeButtonGroup;

    Menu(Environment environment, final WindowOutputProcessor windowOutputProcessor) {
        this.env = environment;
        this.op = windowOutputProcessor;
        this.window = windowOutputProcessor.window;
        this.consoleTextArea = windowOutputProcessor.consoleTextArea;
        this.resultSetTable = windowOutputProcessor.resultSetTable;
        this.statusBarLabel = windowOutputProcessor.statusBarLabel;
        this.focused = this.consoleTextArea;
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Menu.this.focused = focusEvent.getSource();
            }
        };
        this.resultSetTable.addFocusListener(focusAdapter);
        this.consoleTextArea.addFocusListener(focusAdapter);
        JMenu jMenu = Menu.createJMenu(Menu.getMessage("file"), 'F');
        this.add(jMenu);
        jMenu.add(Menu.createJMenuItem(Menu.getMessage("file.newwindow"), 'N', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuNewWindowSelected();
            }
        }, Menu.getKeyStroke(78, true)));
        jMenu.add(Menu.createJMenuItem(Menu.getMessage("file.close"), 'C', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuCloseSelected();
            }
        }, Menu.getKeyStroke(87, true)));
        jMenu.add(new JSeparator());
        jMenu.add(Menu.createJMenuItem(Menu.getMessage("file.chdir"), 'D', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuChangeDirectorySelected();
            }
        }, Menu.getKeyStroke(68, true)));
        jMenu.add(Menu.createJMenuItem(Menu.getMessage("file.export"), 'E', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuExportSelected();
            }
        }));
        jMenu.add(new JSeparator());
        jMenu.add(Menu.createJMenuItem(Menu.getMessage("file.quit"), 'Q', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuQuitSelected();
            }
        }, Menu.getKeyStroke(81, true)));
        JMenu jMenu2 = Menu.createJMenu(Menu.getMessage("edit"), 'E');
        this.add(jMenu2);
        final KeyStroke keyStroke = Menu.getKeyStroke(88, true);
        jMenu2.add(Menu.createJMenuItem(Menu.getMessage("edit.cut"), 'T', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.performKeyEvent(keyStroke, actionEvent);
            }
        }, keyStroke));
        final KeyStroke keyStroke2 = Menu.getKeyStroke(67, true);
        jMenu2.add(Menu.createJMenuItem(Menu.getMessage("edit.copy"), 'C', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.performKeyEvent(keyStroke2, actionEvent);
            }
        }, keyStroke2));
        final KeyStroke keyStroke3 = Menu.getKeyStroke(86, true);
        jMenu2.add(Menu.createJMenuItem(Menu.getMessage("edit.paste"), 'P', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.performKeyEvent(keyStroke3, actionEvent);
            }
        }, keyStroke3));
        final KeyStroke keyStroke4 = Menu.getKeyStroke(65, true);
        jMenu2.add(Menu.createJMenuItem(Menu.getMessage("edit.selectall"), 'A', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.performKeyEvent(keyStroke4, actionEvent);
            }
        }, keyStroke4));
        jMenu2.add(new JSeparator());
        jMenu2.add(Menu.createJMenuItem(Menu.getMessage("edit.findtext"), 'F', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuFindTextSelected();
            }
        }, Menu.getKeyStroke(70, true)));
        jMenu2.add(new JSeparator());
        jMenu2.add(Menu.createJMenuItem(Menu.getMessage("edit.gotoedit"), 'G', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuGoToInputAreaSelected();
            }
        }, Menu.getKeyStroke(71, true)));
        jMenu2.add(Menu.createJMenuItem(Menu.getMessage("edit.clear"), 'M', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuClearSelected();
            }
        }));
        JMenu jMenu3 = Menu.createJMenu(Menu.getMessage("view"), 'V');
        this.add(jMenu3);
        this.checkBoxStatusBarVisibility = Menu.createJCheckBoxMenuItem(Menu.getMessage("view.statusbar"), windowOutputProcessor.statusBarLabel.isVisible(), 'B', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuStatusBarSelected(actionEvent);
            }
        }, null);
        jMenu3.add(this.checkBoxStatusBarVisibility);
        jMenu3.add(new JSeparator());
        this.checkBoxShowColumnNumber = Menu.createJCheckBoxMenuItem(Menu.getMessage("view.columnnumber"), false, 'C', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuShowColumnNumberSelected();
            }
        }, null);
        jMenu3.add(this.checkBoxShowColumnNumber);
        jMenu3.add(Menu.createJMenuItem(Menu.getMessage("view.widen"), 'W', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuWidenSelected();
            }
        }, Menu.getKeyStroke(46, true)));
        jMenu3.add(Menu.createJMenuItem(Menu.getMessage("view.narrow"), 'N', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuNarrowSelected();
            }
        }, Menu.getKeyStroke(44, true)));
        jMenu3.add(Menu.createJMenuItem(Menu.getMessage("view.adjustcolumnwidth"), 'A', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuAdjustColumnWidthSelected();
            }
        }, Menu.getKeyStroke(47, true)));
        JMenu jMenu4 = Menu.createJMenu(Menu.getMessage("view.columnautoadjustmentmode"), 'M');
        jMenu3.add(jMenu4);
        this.columnAdjustModeButtonGroup = new ColumnAdjustModeButtonGroup(this, jMenu4);
        jMenu3.add(new JSeparator());
        jMenu3.add(Menu.createJMenuItem(Menu.getMessage("view.refresh"), 'R', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                windowOutputProcessor.refresh();
            }
        }, Menu.getKeyStroke(116, false)));
        this.viewLimitCountSpinner = new JSpinner(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 500));
        jMenu3.add(Menu.createJMenuItem(Menu.getMessage("view.limitcount"), 'L', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuSetLimitCountSelected();
            }
        }));
        jMenu3.add(Menu.createJMenuItem(Menu.getMessage("view.font"), 'F', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuChangeFontSelected();
            }
        }, Menu.getKeyStroke(59, true)));
        JMenu jMenu5 = Menu.createJMenu(Menu.getMessage("connect"), 'C');
        this.add(jMenu5);
        jMenu5.add(Menu.createJMenuItem(Menu.getMessage("connect.connect"), 'C', new ConnectorListAction(windowOutputProcessor, environment), Menu.getKeyStroke(32, true)));
        jMenu5.add(Menu.createJMenuItem(Menu.getMessage("connect.disconnect"), 'D', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuDisconnectSelected();
            }
        }));
        jMenu5.add(new JSeparator());
        jMenu5.add(Menu.createJMenuItem(Menu.getMessage("connect.encryptionkey"), 'K', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuEncryptionKeySelected();
            }
        }));
        jMenu5.add(Menu.createJMenuItem(Menu.getMessage("connect.configuration"), 'E', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuConnectorConfigurationSelected();
            }
        }));
        JMenu jMenu6 = Menu.createJMenu(Menu.getMessage("command"), 'M');
        this.add(jMenu6);
        jMenu6.add(Menu.createJMenuItem(Menu.getMessage("command.execute"), 'X', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuCommandExecuteSelected();
            }
        }, Menu.getKeyStroke(77, true)));
        jMenu6.add(new JSeparator());
        jMenu6.add(Menu.createJMenuItem(Menu.getMessage("command.history.previous"), 'P', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuCommandPreviousHistorySelected();
            }
        }, Menu.getKeyStroke(75, true)));
        jMenu6.add(Menu.createJMenuItem(Menu.getMessage("command.history.next"), 'N', new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.onMenuCommandNextHistorySelected();
            }
        }, Menu.getKeyStroke(74, true)));
        JMenu jMenu7 = Menu.createJMenu(Menu.getMessage("help"), 'H');
        this.add(jMenu7);
        jMenu7.add(Menu.createJMenuItem(Menu.getMessage("help.showhelp"), 'H', new HelpInfoAction(this.window)));
        jMenu7.add(new JSeparator());
        jMenu7.add(Menu.createJMenuItem(Menu.getMessage("help.about"), 'A', new VersionInfoAction(this.window)));
        this.bindCancelEditingEvent();
        this.loadConfiguration();
        this.validate();
    }

    private void bindCancelEditingEvent() {
        final ResultSetTable resultSetTable = this.resultSetTable;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                resultSetTable.editingCanceled(new ChangeEvent(actionEvent.getSource()));
            }
        };
        int n = this.getMenuCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = this.getMenu(i);
            int n2 = jMenu.getItemCount();
            for (int j = 0; j < n2; ++j) {
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (jMenuItem == null || jMenuItem.getAccelerator() == null) continue;
                jMenuItem.addActionListener(actionListener);
            }
        }
    }

    private void loadConfiguration() {
        try {
            MenuConfiguration.load(this, this.env.getSystemDirectory());
        }
        catch (IOException iOException) {
            this.op.onError(iOException);
        }
        catch (RuntimeException runtimeException) {
            String string = Messages.getString("message.configurationfilebroken");
            this.op.onError(new Exception(MessageFormat.format(string, "Menu"), runtimeException));
            this.setColumnAdjustMode(null);
        }
    }

    private void saveConfiguration() {
        try {
            MenuConfiguration.save(this, this.env.getSystemDirectory());
        }
        catch (IOException iOException) {
            this.op.onError(iOException);
        }
    }

    private static JMenu createJMenu(String string, char c) {
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(c);
        return jMenu;
    }

    private static JMenuItem createJMenuItem(String string, char c, Action action) {
        return Menu.createJMenuItem(string, c, action, null);
    }

    private static JMenuItem createJMenuItem(String string, char c, Action action, KeyStroke keyStroke) {
        JMenuItem jMenuItem = new JMenuItem(string, c);
        if (action != null) {
            jMenuItem.addActionListener(action);
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        return jMenuItem;
    }

    private static JCheckBoxMenuItem createJCheckBoxMenuItem(String string, boolean bl, char c, Action action, KeyStroke keyStroke) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, bl);
        jCheckBoxMenuItem.setMnemonic(c);
        if (action != null) {
            jCheckBoxMenuItem.addActionListener(action);
        }
        if (keyStroke != null) {
            jCheckBoxMenuItem.setAccelerator(keyStroke);
        }
        return jCheckBoxMenuItem;
    }

    private static KeyStroke getKeyStroke(int n, boolean bl) {
        return KeyStroke.getKeyStroke(n, bl ? 2 : 0);
    }

    private void requestCommand(String string) {
        this.op.requestCommand(string, "menu:" + string);
    }

    void performKeyEvent(KeyStroke keyStroke, ActionEvent actionEvent) {
        JComponent jComponent = this.focused == this.resultSetTable ? this.resultSetTable : this.consoleTextArea;
        ActionListener actionListener = jComponent.getActionForKeyStroke(keyStroke);
        if (actionListener != null) {
            actionEvent.setSource(jComponent);
            actionListener.actionPerformed(actionEvent);
        }
    }

    void onMenuNewWindowSelected() {
        this.op.createNew();
    }

    void onMenuCloseSelected() {
        this.op.onWindowClosing();
    }

    void onMenuChangeDirectorySelected() {
        File file = this.env.getCurrentDirectory();
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(Menu.getMessage("dialog.chdir.title"));
        jFileChooser.setApproveButtonText(Menu.getMessage("dialog.chdir.button"));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.showDialog(this, null);
        File file2 = jFileChooser.getSelectedFile();
        if (file2 != null) {
            this.env.setCurrentDirectory(file2);
        }
    }

    void onMenuExportSelected() {
        File file = this.env.getCurrentDirectory();
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(Menu.getMessage("dialog.export.title"));
        jFileChooser.setApproveButtonText(Menu.getMessage("dialog.export.button"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.showDialog(this, null);
        File file2 = jFileChooser.getSelectedFile();
        if (file2 != null) {
            String string;
            if (file2.exists() && DialogMessage.confirmYesNo(this.window, string = Menu.getMessage("message.confirm.overwritefile")) != 0) {
                return;
            }
            try {
                this.resultSetTable.export(file2);
                DialogMessage.notice(this.window, Menu.getMessage("message.notice.exported"));
            }
            catch (IOException iOException) {
                this.op.onError(iOException);
            }
        }
    }

    void onMenuQuitSelected() {
        String string = Menu.getMessage("message.exit");
        int n = DialogMessage.confirmYesNo(this.window, string);
        if (n == 0) {
            this.op.requestExit();
        }
    }

    void onMenuFindTextSelected() {
        this.op.requestShowTextSearchPanel((TextSearch)this.focused);
    }

    void onMenuGoToInputAreaSelected() {
        this.consoleTextArea.requestFocus();
    }

    void onMenuClearSelected() {
        this.consoleTextArea.clear();
        this.consoleTextArea.sendCommand();
    }

    void onMenuWidenSelected() {
        this.resultSetTable.changeColumnWidth(1.5);
    }

    void onMenuNarrowSelected() {
        this.resultSetTable.changeColumnWidth(0.6666666666666666);
    }

    void onMenuAdjustColumnWidthSelected() {
        this.resultSetTable.adjustColumnWidth();
    }

    void onMenuSetLimitCountSelected() {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.viewLimitCountSpinner.getModel();
        int n = spinnerNumberModel.getNumber().intValue();
        JOptionPane jOptionPane = new JOptionPane(this.viewLimitCountSpinner, -1, 2);
        final JDialog jDialog = jOptionPane.createDialog(this.window, null);
        final JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.viewLimitCountSpinner.getEditor();
        defaultEditor.getTextField().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        try {
                            defaultEditor.commitEdit();
                        }
                        catch (ParseException parseException) {
                            DialogMessage.alert(defaultEditor, parseException.toString());
                        }
                        jDialog.dispose();
                        break;
                    }
                    case 27: {
                        jDialog.dispose();
                        break;
                    }
                }
            }
        });
        jDialog.setVisible(true);
        jOptionPane.getInputValue();
        int n2 = spinnerNumberModel.getNumber().intValue();
        if (n2 != n) {
            this.setLimitCount(n2);
        }
    }

    void onMenuChangeFontSelected() {
        this.op.requestShowFontChooser();
    }

    void onMenuStatusBarSelected(ActionEvent actionEvent) {
        this.statusBarLabel.setVisible(!this.statusBarLabel.isVisible());
        Object object = actionEvent.getSource();
        if (object instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)object;
            jCheckBoxMenuItem.setState(this.statusBarLabel.isVisible());
        }
    }

    void onMenuShowColumnNumberSelected() {
        boolean bl = this.resultSetTable.isShowColumnNumber();
        this.resultSetTable.setShowColumnNumber(!bl);
        this.resultSetTable.repaint();
    }

    void onMenuDisconnectSelected() {
        this.requestCommand("disconnect");
    }

    void onMenuEncryptionKeySelected() {
        Number number;
        JPasswordField jPasswordField = new JPasswordField(20);
        Object[] objectArray = new Object[]{Menu.getMessage("dialog.encryption.message"), jPasswordField};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 2);
        jOptionPane.createDialog(this.window, null).setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Number && (number = (Number)object).intValue() == 0) {
            char[] cArray = jPasswordField.getPassword();
            CipherPassword.setSecretKey(String.valueOf(cArray));
        }
    }

    void onMenuConnectorConfigurationSelected() {
        this.env.updateConnectorMap();
        if (this.env.getCurrentConnector() != null) {
            DialogMessage.notice(this.window, Menu.getMessage("message.notice.starteditconnector"));
        }
        this.op.requestShowConnectorMapEditDialog();
        this.env.updateConnectorMap();
    }

    void onMenuCommandExecuteSelected() {
        this.consoleTextArea.sendCommand();
    }

    void onMenuCommandPreviousHistorySelected() {
        this.consoleTextArea.turnBackHistory();
        this.consoleTextArea.requestFocus();
    }

    void onMenuCommandNextHistorySelected() {
        this.consoleTextArea.turnNextHistory();
        this.consoleTextArea.requestFocus();
    }

    private static String getMessage(String string) {
        return Messages.getString("menu.Menu." + string);
    }

    int getLimitCount() {
        return this.resultSetTable.getLimitCount();
    }

    void setLimitCount(int n) {
        this.resultSetTable.setLimitCount(n);
        this.viewLimitCountSpinner.setValue(new Integer(n));
        this.saveConfiguration();
    }

    String getColumnAdjustMode() {
        return this.resultSetTable.getColumnAdjustMode();
    }

    void setColumnAdjustMode(String string) {
        this.resultSetTable.setColumnAdjustMode(string);
        this.columnAdjustModeButtonGroup.setMode(string);
        this.saveConfiguration();
    }

    static final class ColumnAdjustModeButtonGroup
    extends ButtonGroup {
        final Menu menu;
        final JRadioButtonMenuItem[] radios;

        ColumnAdjustModeButtonGroup(Menu menu, JMenuItem jMenuItem) {
            this.menu = menu;
            String string = "view.columnautoadjustmentmode";
            JRadioButtonMenuItem[] jRadioButtonMenuItemArray = new JRadioButtonMenuItem[]{ColumnAdjustModeButtonGroup.createJRadioButtonMenuItem(ColumnAdjustModeButtonGroup.getMessage(string + ".none"), false, 'N'), ColumnAdjustModeButtonGroup.createJRadioButtonMenuItem(ColumnAdjustModeButtonGroup.getMessage(string + ".header"), false, 'H'), ColumnAdjustModeButtonGroup.createJRadioButtonMenuItem(ColumnAdjustModeButtonGroup.getMessage(string + ".value"), false, 'V'), ColumnAdjustModeButtonGroup.createJRadioButtonMenuItem(ColumnAdjustModeButtonGroup.getMessage(string + ".headerandvalue"), false, 'A')};
            int n = 0;
            while (n < jRadioButtonMenuItemArray.length) {
                JRadioButtonMenuItem jRadioButtonMenuItem = jRadioButtonMenuItemArray[n];
                jMenuItem.add(jRadioButtonMenuItem);
                this.add(jRadioButtonMenuItem);
                final int n2 = n++;
                jRadioButtonMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ColumnAdjustModeButtonGroup.this.onMenuColumnAdjustModeSelected(ColumnAdjustModeButtonGroup.this.getMode(n2));
                    }
                });
            }
            this.radios = jRadioButtonMenuItemArray;
        }

        String getMode() {
            for (int i = 0; i < this.radios.length; ++i) {
                if (!this.radios[i].isSelected()) continue;
                return this.getMode(i);
            }
            return "";
        }

        String getMode(int n) {
            switch (n) {
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "HEADER";
                }
                case 2: {
                    return "VALUE";
                }
                case 3: {
                    return "HEADER-AND-VALUE";
                }
            }
            return "";
        }

        void setMode(String string) {
            int n = string == null || string.equalsIgnoreCase("NONE") ? 0 : (string.equalsIgnoreCase("HEADER") ? 1 : (string.equalsIgnoreCase("VALUE") ? 2 : (string.equalsIgnoreCase("HEADER-AND-VALUE") ? 3 : -1)));
            if (n >= 0) {
                this.radios[n].setSelected(true);
            }
        }

        void onMenuColumnAdjustModeSelected(String string) {
            this.menu.setColumnAdjustMode(string);
        }

        private static JRadioButtonMenuItem createJRadioButtonMenuItem(String string, boolean bl, char c) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            jRadioButtonMenuItem.setMnemonic(c);
            jRadioButtonMenuItem.setSelected(bl);
            return jRadioButtonMenuItem;
        }

        private static String getMessage(String string) {
            return Messages.getString("menu.Menu." + string);
        }
    }
}

