/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Highlighter;
import javax.swing.text.Position;
import net.argius.stew.StringClass;
import net.argius.stew.gui.HistoryList;
import net.argius.stew.gui.TextSearch;
import net.argius.stew.gui.TextSearchMatcher;
import net.argius.stew.gui.WindowOutputProcessor;

final class ConsoleTextArea
extends JTextArea
implements TextSearch {
    private static final String EOL = "\n";
    private final WindowOutputProcessor op;
    private final HistoryList historyList;
    private int borderPosition;

    ConsoleTextArea(WindowOutputProcessor windowOutputProcessor) {
        this.op = windowOutputProcessor;
        this.historyList = new HistoryList();
        this.initializeView();
        this.initializeKeyBind();
        AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
        abstractDocument.setDocumentFilter(new PrivateDocumentFilter(this));
        this.validate();
    }

    private void initializeView() {
        this.setLineWrap(true);
        this.setWrapStyleWord(false);
    }

    private void initializeKeyBind() {
        InputMap inputMap = this.getInputMap();
        inputMap.put(this.getKeyStroke(10), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleTextArea.this.sendCommand();
            }
        });
        inputMap.put(this.getKeyStroke(36), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleTextArea.this.setCaretPosition(ConsoleTextArea.this.getBorderPosition());
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(67, 128), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConsoleTextArea.this.getSelectedText() == null) {
                    ConsoleTextArea.this.onBreak();
                } else {
                    DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
                    copyAction.actionPerformed(actionEvent);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(66, 512), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleTextArea.this.onBreak();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(10, 128), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleTextArea.this.insert(ConsoleTextArea.EOL, ConsoleTextArea.this.getCaretPosition());
            }
        });
    }

    void onBreak() {
        this.append(" [BREAK]> ");
        this.borderPosition = this.getCursorEndPosition();
        this.validate();
    }

    int getBorderPosition() {
        return this.borderPosition;
    }

    boolean isEditablePosition(int n) {
        return n >= this.borderPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCommand() {
        try {
            ConsoleTextArea consoleTextArea = this;
            synchronized (consoleTextArea) {
                Document document = this.getDocument();
                int n = this.getCaretPosition();
                int n2 = this.getCursorEndPosition();
                if (n != n2) {
                    this.setCaretPosition(n2);
                    return;
                }
                String string = document.getText(this.borderPosition, n2 - this.borderPosition);
                this.op.requestCommand(string);
                if (!StringClass.isBlank(string)) {
                    this.historyList.add(string);
                }
                this.borderPosition = this.getCursorEndPosition();
            }
        }
        catch (BadLocationException badLocationException) {
            this.op.onError(badLocationException);
        }
    }

    public void append(String string) {
        String string2 = string.replaceAll("\\\r\\\n?", EOL);
        super.append(string2);
        this.borderPosition += string2.length();
        this.setCaretPosition(this.getCursorEndPosition());
    }

    void replace(String string) {
        this.replaceRange(string, this.borderPosition, this.getCursorEndPosition());
    }

    void clear() {
        this.borderPosition = 0;
        this.setText("");
    }

    void turnBackHistory() {
        String string = this.historyList.getPrevious();
        if (!StringClass.isEmpty(string)) {
            this.replace(string);
        }
    }

    void turnNextHistory() {
        String string = this.historyList.getNext();
        if (!StringClass.isEmpty(string)) {
            this.replace(string);
        }
    }

    private KeyStroke getKeyStroke(int n) {
        return KeyStroke.getKeyStroke(n, 0);
    }

    private int getCursorEndPosition() {
        Document document = this.getDocument();
        Position position = document.getEndPosition();
        return position.getOffset() - 1;
    }

    public void removeHighlights() {
        Highlighter highlighter = this.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            this.getHighlighter().removeHighlight(highlightArray[i]);
        }
    }

    public boolean search(TextSearchMatcher textSearchMatcher) {
        this.removeHighlights();
        try {
            Highlighter highlighter = this.getHighlighter();
            Highlighter.HighlightPainter highlightPainter = textSearchMatcher.getHighlightPainter();
            String string = this.getText();
            int n = 0;
            boolean bl = false;
            while (textSearchMatcher.find(string, n)) {
                bl = true;
                int n2 = textSearchMatcher.getStart();
                highlighter.addHighlight(n2, textSearchMatcher.getEnd(), highlightPainter);
                n = n2 + 1;
            }
            this.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    ConsoleTextArea.this.removeKeyListener(this);
                    ConsoleTextArea.this.removeHighlights();
                }
            });
            return bl;
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    public void reset() {
        this.removeHighlights();
    }

    private static final class PrivateDocumentFilter
    extends DocumentFilter {
        private final ConsoleTextArea consoleTextArea;

        PrivateDocumentFilter(ConsoleTextArea consoleTextArea) {
            this.consoleTextArea = consoleTextArea;
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.consoleTextArea.isEditablePosition(n)) {
                super.insertString(filterBypass, n, string, attributeSet);
            }
        }

        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (this.consoleTextArea.isEditablePosition(n)) {
                super.remove(filterBypass, n, n2);
            }
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.consoleTextArea.isEditablePosition(n)) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            }
        }
    }
}

