/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.gui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorMap;
import net.argius.stew.Environment;
import net.argius.stew.gui.DialogMessage;
import net.argius.stew.gui.Messages;
import net.argius.stew.gui.WindowOutputProcessor;

final class ConnectorListAction
extends AbstractAction {
    private final WindowOutputProcessor op;
    private final Environment env;

    ConnectorListAction(WindowOutputProcessor windowOutputProcessor, Environment environment) {
        this.op = windowOutputProcessor;
        this.env = environment;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.env.updateConnectorMap();
        ConnectorMap connectorMap = this.env.getConnectorMap();
        if (connectorMap.isEmpty()) {
            IllegalStateException illegalStateException = new IllegalStateException(Messages.getString("dialog.connectorlist.nolist"));
            this.op.onError(illegalStateException);
        } else {
            Object object;
            ArrayList<ConnectorListElement> arrayList = new ArrayList<ConnectorListElement>();
            Object object2 = connectorMap.values().iterator();
            while (object2.hasNext()) {
                object = (Connector)object2.next();
                arrayList.add(new ConnectorListElement((Connector)object));
            }
            object2 = DialogMessage.select(this.op.window, Messages.getString("dialog.connectorlist.header"), arrayList.toArray());
            if (object2 != null) {
                object = (ConnectorListElement)object2;
                String string = "connect " + ((ConnectorListElement)object).getConnector().getId();
                this.op.consoleTextArea.replace(string);
                this.op.consoleTextArea.sendCommand();
            }
        }
    }

    private static final class ConnectorListElement {
        private final Connector connector;

        ConnectorListElement(Connector connector) {
            this.connector = connector;
        }

        Connector getConnector() {
            return this.connector;
        }

        public String toString() {
            return this.connector.getId() + " (" + this.connector.getName() + ")";
        }
    }
}

