/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorConfiguration;
import net.argius.stew.ConnectorMap;
import net.argius.stew.Launcher;
import net.argius.stew.Messages;
import net.argius.stew.Parameter;
import net.argius.stew.StringClass;
import net.argius.stew.UnexpectedError;
import net.argius.version.Version;

public final class ConnectorMapEditor {
    private static final String MESSAGE_CONNECTOR_MAP_EDITOR = "message.ConnectorMapEditor.";
    private static final String[] PROP_KEYS = new String[]{"name", "classpath", "driver", "url", "user", "password", "readonly", "rollback"};
    private final ConnectorMap map;
    private ConnectorMap previous = ConnectorConfiguration.load();

    private ConnectorMapEditor() throws IOException {
        this.map = new ConnectorMap(this.previous);
    }

    private static String getMessage(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("id is empty string");
        }
        return Messages.getString(MESSAGE_CONNECTOR_MAP_EDITOR + string);
    }

    private static String getInput(String string) {
        if (string.length() > 0) {
            ConnectorMapEditor.print(ConnectorMapEditor.getMessage(string));
        }
        ConnectorMapEditor.print(" > ");
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            UnexpectedError unexpectedError = new UnexpectedError();
            unexpectedError.initCause(iOException);
            throw unexpectedError;
        }
    }

    private static Parameter getParameter(String string) {
        String string2 = ConnectorMapEditor.getInput(string);
        return new Parameter(string2 == null ? "" : string2);
    }

    private static boolean confirmYes(String string) {
        if (string.length() > 0) {
            ConnectorMapEditor.print(ConnectorMapEditor.getMessage(string));
        }
        ConnectorMapEditor.print("(y/N) > ");
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            return String.valueOf(bufferedReader.readLine()).equalsIgnoreCase("y");
        }
        catch (IOException iOException) {
            UnexpectedError unexpectedError = new UnexpectedError();
            unexpectedError.initCause(iOException);
            throw unexpectedError;
        }
    }

    private static void print(Object object) {
        System.out.print(object);
    }

    private static void printLine() {
        System.out.println();
    }

    private static void printLine(Object object) {
        System.out.println(object);
    }

    private static void printMessage(String string) {
        ConnectorMapEditor.printMessage(string, new Object[0]);
    }

    private static void printMessage(String string, Object object) {
        ConnectorMapEditor.printMessage(string, new Object[]{object});
    }

    private static void printMessage(String string, Object[] objectArray) {
        String string2 = objectArray.length > 0 ? MessageFormat.format(ConnectorMapEditor.getMessage(string), objectArray) : ConnectorMapEditor.getMessage(string);
        ConnectorMapEditor.printLine(string2);
    }

    private static boolean isSameContent(ConnectorMap connectorMap, ConnectorMap connectorMap2) {
        Set set = connectorMap.keySet();
        if (!((Object)set).equals(connectorMap2.keySet())) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Connector connector = connectorMap.getConnector(string);
            Connector connector2 = connectorMap2.getConnector(string);
            if (connector2.getProperties().equals(connector.getProperties())) continue;
            return false;
        }
        return true;
    }

    private void printHelp() {
        ConnectorMapEditor.printMessage("help.header");
        ConnectorMapEditor.printLine("     help     : " + ConnectorMapEditor.getMessage("help.help"));
        ConnectorMapEditor.printLine("     a    id  : " + ConnectorMapEditor.getMessage("help.add"));
        ConnectorMapEditor.printLine("     m    id  : " + ConnectorMapEditor.getMessage("help.modify"));
        ConnectorMapEditor.printLine("     r    id  : " + ConnectorMapEditor.getMessage("help.remove"));
        ConnectorMapEditor.printLine("     copy A B : " + ConnectorMapEditor.getMessage("help.copy"));
        ConnectorMapEditor.printLine("     disp [id]: " + ConnectorMapEditor.getMessage("help.disp"));
        ConnectorMapEditor.printLine("     save     : " + ConnectorMapEditor.getMessage("help.save"));
        ConnectorMapEditor.printLine("     load     : " + ConnectorMapEditor.getMessage("help.load"));
        ConnectorMapEditor.printLine("     exit     : " + ConnectorMapEditor.getMessage("help.exit"));
    }

    private boolean proceedInputProperties(String string, Connector connector) {
        Properties properties = connector.getProperties();
        do {
            String string2;
            int n;
            ConnectorMapEditor.printMessage("property.start1");
            ConnectorMapEditor.printMessage("property.start2");
            for (n = 0; n < PROP_KEYS.length; ++n) {
                string2 = PROP_KEYS[n];
                String string3 = properties.getProperty(string2);
                ConnectorMapEditor.print(MessageFormat.format(ConnectorMapEditor.getMessage("property.input"), string2, string3));
                String string4 = ConnectorMapEditor.getInput("");
                if (StringClass.isEmpty(string4)) continue;
                properties.setProperty(string2, string4);
            }
            for (n = 0; n < PROP_KEYS.length; ++n) {
                string2 = PROP_KEYS[n];
                System.err.println(string2 + "=" + properties.getProperty(string2));
            }
            if (ConnectorMapEditor.confirmYes("property.tryconnect.confirm")) {
                try {
                    connector.getConnection();
                    ConnectorMapEditor.printMessage("property.tryconnect.succeeded");
                }
                catch (SQLException sQLException) {
                    ConnectorMapEditor.printMessage("property.tryconnect.failed", sQLException.getMessage());
                }
            }
            if (!ConnectorMapEditor.confirmYes("property.update.confirm")) continue;
            return true;
        } while (ConnectorMapEditor.confirmYes("property.retry.confirm"));
        ConnectorMapEditor.printMessage("property.update.cancel");
        return false;
    }

    private void proceedAdd(String string) {
        if (this.map.containsKey(string)) {
            ConnectorMapEditor.printMessage("proc.alreadyexists", string);
            return;
        }
        Properties properties = new Properties();
        for (int i = 0; i < PROP_KEYS.length; ++i) {
            properties.setProperty(PROP_KEYS[i], "");
        }
        Connector connector = new Connector(string, properties);
        if (this.proceedInputProperties(string, connector)) {
            this.map.put(string, connector);
            ConnectorMapEditor.printMessage("proc.added", string);
        }
    }

    private void proceedModify(String string) {
        if (!this.map.containsKey(string)) {
            ConnectorMapEditor.printMessage("proc.notexists", string);
            return;
        }
        Connector connector = new Connector(string, this.map.getConnector(string));
        if (this.proceedInputProperties(string, connector)) {
            this.map.put(string, connector);
            ConnectorMapEditor.printMessage("proc.modified", string);
        }
    }

    private void proceedRemove(String string) {
        Connector connector = this.map.getConnector(string);
        ConnectorMapEditor.printLine("ID[" + string + "]:" + connector.getName());
        if (ConnectorMapEditor.confirmYes("proc.remove.confirm")) {
            this.map.remove(string);
            ConnectorMapEditor.printMessage("proc.remove.finished");
        } else {
            ConnectorMapEditor.printMessage("proc.remove.canceled");
        }
        ConnectorMapEditor.printLine(this.map);
    }

    private void proceedCopy(String string, String string2) {
        if (!this.map.containsKey(string)) {
            ConnectorMapEditor.printMessage("proc.notexists", string);
            ConnectorMapEditor.printMessage("proc.copy.canceled");
            return;
        }
        if (this.map.containsKey(string2)) {
            ConnectorMapEditor.printMessage("proc.alreadyexists", string2);
            ConnectorMapEditor.printMessage("proc.copy.canceled");
            return;
        }
        this.map.put(string2, new Connector(string2, this.map.getConnector(string)));
        ConnectorMapEditor.printMessage("proc.copy.finished");
    }

    private void proceedDisplayIds() {
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            String string2 = string.length() < 10 ? "          ".substring(string.length()) : "";
            ConnectorMapEditor.printLine(string2 + string + " : " + this.map.getConnector(string).getName());
        }
    }

    private void proceedDisplayDetail(String string) {
        if (!this.map.containsKey(string)) {
            ConnectorMapEditor.printMessage("proc.notexists", string);
            return;
        }
        Properties properties = this.map.getConnector(string).getProperties();
        for (int i = 0; i < PROP_KEYS.length; ++i) {
            String string2 = PROP_KEYS[i];
            String string3 = "          ".substring(string2.length());
            ConnectorMapEditor.printLine(string3 + string2 + " : " + properties.getProperty(string2));
        }
    }

    private void proceedSave() throws IOException {
        if (this.map.equals(this.previous)) {
            ConnectorMapEditor.printMessage("proc.nomodification");
        } else if (ConnectorMapEditor.confirmYes("proc.save.confirm")) {
            ConnectorConfiguration.save(this.map);
            this.previous = new ConnectorMap(this.map);
            ConnectorMapEditor.printMessage("proc.save.finished");
        } else {
            ConnectorMapEditor.printMessage("proc.save.canceled");
        }
    }

    private void proceedLoad() throws IOException {
        ConnectorMap connectorMap = ConnectorConfiguration.load();
        if (ConnectorMapEditor.isSameContent(connectorMap, this.previous) && ConnectorMapEditor.isSameContent(connectorMap, this.map)) {
            ConnectorMapEditor.printMessage("proc.nomodification");
            return;
        }
        ConnectorMapEditor.printMessage("proc.load.confirm1");
        if (ConnectorMapEditor.confirmYes("proc.load.confirm2")) {
            ConnectorMapEditor.printMessage("proc.load.finished");
        } else {
            ConnectorMapEditor.printMessage("proc.load.canceled");
        }
    }

    public static void main(String[] stringArray) {
        ConnectorMapEditor.printLine("Stew - SQL client tool with JDBC");
        ConnectorMapEditor.printLine("version " + Version.getInstance(Launcher.class));
        ConnectorMapEditor.printLine();
        ConnectorMapEditor.printMessage("main.start");
        ConnectorMapEditor.printLine();
        try {
            ConnectorMapEditor connectorMapEditor = new ConnectorMapEditor();
            while (true) {
                Parameter parameter = ConnectorMapEditor.getParameter("main.wait");
                String string = parameter.get(1);
                String string2 = parameter.get(2);
                if (string.equalsIgnoreCase("help")) {
                    connectorMapEditor.printHelp();
                } else if (string.equalsIgnoreCase("a")) {
                    connectorMapEditor.proceedAdd(string2);
                } else if (string.equalsIgnoreCase("m")) {
                    connectorMapEditor.proceedModify(string2);
                } else if (string.equalsIgnoreCase("r")) {
                    connectorMapEditor.proceedRemove(string2);
                } else if (string.equalsIgnoreCase("copy")) {
                    connectorMapEditor.proceedCopy(string2, parameter.get(3));
                } else if (string.equalsIgnoreCase("disp")) {
                    if (StringClass.isEmpty(string2)) {
                        connectorMapEditor.proceedDisplayIds();
                    } else {
                        connectorMapEditor.proceedDisplayDetail(string2);
                    }
                } else if (string.equalsIgnoreCase("save")) {
                    connectorMapEditor.proceedSave();
                } else if (string.equalsIgnoreCase("load")) {
                    connectorMapEditor.proceedLoad();
                } else if (string.equalsIgnoreCase("exit")) break;
                ConnectorMapEditor.printLine();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        ConnectorMapEditor.printLine();
        ConnectorMapEditor.printMessage("main.end");
    }
}

