package net.argius.stew.io;

import java.io.*;

/**
 * GNX|[g̊NXB
 * 
 * (getExporter)ꍇA
 * t@C`͈ȉ̂悤Ɋgqɂ莩IɑIB
 * <ul>
 * <li>gq"htm""html"̏ꍇHTML`ŏo͂B
 * <li>gq"csv"̏ꍇCSV`ŏo͂B
 * <li>LȊȌꍇ̓^u؂`ŏo͂B
 * </ul>
 */
public abstract class Exporter {

    protected OutputStream os;
    protected boolean wasWrittenHeader;

    /**
     * Exporter̐B
     * @param os o̓Xg[
     */
    protected Exporter(OutputStream os) {
        this.os = os;
        this.wasWrittenHeader = false;
    }

    /**
     * wb_ǉB
     * ǉ͈xsȂB
     * @param row s
     * @throws IOException o̓G[ꍇ
     * A܂́Awb_ǉׂłȂꍇ
     */
    public void addHeader(Object[] row) throws IOException {
        if (wasWrittenHeader) {
            throw new IOException("header was already written");
        }
        writeHeader(row);
        wasWrittenHeader = true;
    }

    /**
     * wb_ށB
     * @param header wb_
     * @throws IOException o̓G[ꍇ
     */
    protected void writeHeader(Object[] header) throws IOException {
        addRow(header);
    }

    /**
     * IB
     * @throws IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        if (os != null) {
            try {
                os.close();
            } finally {
                os = null;
            }
        }
    }

    /**
     * ExporterIɑIĎ擾B
     * @param file t@C
     * @return Exporter
     * @throws IOException o̓G[ꍇ
     */
    public static Exporter getExporter(File file) throws IOException {
        return ExporterFactory.createExporter(new Path(file));
    }

    /**
     * ExporterIɑIĎ擾B
     * @param fileName t@C
     * @return Exporter
     * @throws IOException o̓G[ꍇ 
     */
    public static Exporter getExporter(String fileName) throws IOException {
        return ExporterFactory.createExporter(new Path(fileName));
    }

    /**
     * sǉB
     * @param row s
     * @throws IOException o̓G[ꍇ
     */
    public abstract void addRow(Object[] row) throws IOException;

}