package net.argius.stew;

import java.io.*;
import java.sql.*;

import net.argius.logging.*;

/**
 * R}h̎sB
 */
public final class Environment {

    static final String CONNECTOR_PROPERTIES_NAME = "connector.properties";

    private static final Logger log = LoggerFactory.getLogger(Environment.class);

    private OutputProcessor outputProcessor;
    private ConnectorMap connectorMap;
    private Connector connector;
    private Connection conn;
    private int timeoutSeconds;
    private File systemDirectory;
    private File currentDirectory;
    private long connectorTimestamp;

    /**
     * Environment̐B
     */
    public Environment() {
        initializeOutputProcessor();
        initializeQueryTimeout();
        // ڑݒ
        this.connectorMap = new ConnectorMap();
        loadConnectorMap();
        // fBNg
        this.systemDirectory = LocalSystem.getDirectory();
        this.currentDirectory = getInitialCurrentDirectory();
    }

    /**
     * Environment̐(Rs[RXgN^)B
     * @param src Rs[̃CX^X
     */
    public Environment(Environment src) {
        // connector,conn,op  Rs[Ȃ
        this.connectorMap = new ConnectorMap(src.connectorMap);
        this.timeoutSeconds = src.timeoutSeconds;
        this.systemDirectory = src.systemDirectory;
        this.currentDirectory = src.currentDirectory;
    }

    /**
     * \[XB
     * IɉOɎQƂĂIuWFNgB
     */
    public void release() {
        try {
            releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug("released connection");
            }
        } catch (SQLException ex) {
            log.error("release error", ex);
        } finally {
            /*
             * ȍ~ɎgpƃG[ɂȂ邱Ƃ𗘗p
             * \[XꂽƂ𖾎Ă
             */
            outputProcessor = null;
            connectorMap = null;
            connector = null;
            conn = null;
            systemDirectory = null;
            currentDirectory = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("released Environment");
        }
    }

    /**
     * ڑB
     * ڑ̃RlNVؒfAQƂB
     * @throws SQLException SQL֘AG[ꍇ 
     */
    void releaseConnection() throws SQLException {
        try {
            if (conn != null) {
                if (connector != null && connector.usesAutoRollback()) {
                    try {
                        conn.rollback();
                        if (log.isDebugEnabled()) {
                            log.debug("rollbacked");
                        }
                    } catch (SQLException ex) {
                        log.warn("", ex);
                    }
                }
                try {
                    conn.close();
                    if (log.isDebugEnabled()) {
                        log.debug("disconnected");
                    }
                } catch (SQLException ex) {
                    log.warn("", ex);
                    throw ex;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("not connected");
                }
            }
        } finally {
            conn = null;
            connector = null;
        }
    }

    /**
     * OutputProcessoȑB
     */
    private void initializeOutputProcessor() {
        OutputProcessor op;
        if (LocalSystem.containsKey(PropertyKey.OUTPUT_PROCESSOR)) {
            String fqcn = LocalSystem.getProperty(PropertyKey.OUTPUT_PROCESSOR);
            op = (OutputProcessor)DynamicLoader.newInstance(fqcn);
        } else {
            op = new StandardOutputProcessor();
        }
        this.outputProcessor = op;
        if (log.isDebugEnabled()) {
            log.debug("OutputProcessor : " + this.outputProcessor);
        }
    }

    /**
     * JgfBNg̎擾B
     * @return JgfBNg
     */
    private File getInitialCurrentDirectory() {
        if (LocalSystem.containsKey(PropertyKey.DIRECTORY)) {
            File directory = new File(LocalSystem.getProperty(PropertyKey.DIRECTORY));
            if (directory.isDirectory()) {
                return directory;
            }
        }
        return new File(".");
    }

    /**
     * ^CAEgl̏B
     */
    private void initializeQueryTimeout() {
        String stringValue = LocalSystem.getProperty(PropertyKey.QUERY_TIMEOUT);
        int intValue = -1;
        if (!StringClass.isBlank(stringValue)) {
            try {
                intValue = Integer.parseInt(stringValue);
            } catch (NumberFormatException ex) {
                // ignore
            }
        }
        this.timeoutSeconds = intValue;
        if (log.isDebugEnabled()) {
            log.debug("timeout(String) : " + stringValue);
            log.debug("timeout(int)    : " + intValue);
        }
    }

    /**
     * ڑݒ}bvǂݍށB
     * ȊO̎sz肳ĂB
     */
    public void loadConnectorMap() {
        File connectorFile = new File(LocalSystem.getDirectory(), CONNECTOR_PROPERTIES_NAME);
        ConnectorMap m;
        try {
            InputStream is = new FileInputStream(connectorFile);
            try {
                m = ConnectorConfiguration.load(is);
            } finally {
                is.close();
            }
        } catch (IOException ex) {
            m = new ConnectorMap();
        }
        synchronized (connectorMap) {
            if (connectorMap.size() > 0) {
                connectorMap.clear();
            }
            connectorMap.putAll(m);
            connectorTimestamp = connectorFile.lastModified();
        }
    }

    /**
     * ڑݒ}bvŐVB
     * t@CXVĂꍇAloadConnectorMap()sB
     * @return XVꍇ <code>true</code>AXVȂꍇ <code>false</code>
     */
    public boolean updateConnectorMap() {
        File connectorFile = new File(LocalSystem.getDirectory(), CONNECTOR_PROPERTIES_NAME);
        if (connectorFile.lastModified() > connectorTimestamp) {
            loadConnectorMap();
            return true;
        }
        return false;
    }

    /**
     * OutputProcessor̎擾B
     * @return outputProcessor OutputProcessor
     */
    public OutputProcessor getOutputProcessor() {
        return outputProcessor;
    }

    /**
     * OutputProcessor̐ݒB
     * @param outputProcessor OutputProcessor
     */
    public void setOutputProcessor(OutputProcessor outputProcessor) {
        this.outputProcessor = outputProcessor;
    }

    /**
     * RlN^}bv̎擾B
     * @return RlN^}bv
     */
    public ConnectorMap getConnectorMap() {
        return connectorMap;
    }

    /**
     * ڑ̃RlN^擾B
     * @return ڑ̃RlN^
     */
    public Connector getCurrentConnector() {
        return connector;
    }

    /**
     * ڑ̃RlN^ݒ肷B
     * @param connector ڑ̃RlN^
     */
    protected void setCurrentConnector(Connector connector) {
        this.connector = connector;
    }

    /**
     * ڑ̃RlNV擾B
     * @return ڑ̃RlNV
     */
    public Connection getCurrentConnection() {
        return conn;
    }

    /**
     * ڑ̃RlNVݒ肷B
     * @param conn ڑ̃RlNV
     */
    protected void setCurrentConnection(Connection conn) {
        this.conn = conn;
    }

    /**
     * ^CAEgb̎擾B
     * @return ^CAEgb
     */
    public int getTimeoutSeconds() {
        return timeoutSeconds;
    }

    /**
     * JgfBNg̎擾B
     * @return JgfBNg
     */
    public File getCurrentDirectory() {
        return currentDirectory;
    }

    /**
     * JgfBNg̐ݒB
     * @param currentDirectory JgfBNg
     */
    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    /**
     * VXefBNg̎擾B
     * iVXefBNǵAVXegpfBNgBj
     * @return VXefBNg
     */
    public File getSystemDirectory() {
        return systemDirectory;
    }

}