package net.argius.stew;

import java.io.*;
import java.net.*;
import java.sql.*;
import java.util.*;

import net.argius.logging.*;

/**
 * RlN^B
 * JDBCRlNV̐ڑB
 */
public final class Connector {

    private static final Logger log = LoggerFactory.getLogger(Connector.class);

    private final String id;
    private final Properties props;
    private final Password password;

    /**
     * Connector̐B
     * @param id ID
     * @param props vpeB
     */
    public Connector(String id, Properties props) {
        if (!id.matches("^[A-Za-z0-9]*$")) {
            throw new IllegalArgumentException("illegal id : " + id);
        }
        this.id = id;
        this.props = props;
        this.password = createPasswordInstance(props.getProperty("password.class"));
        password.setTransformedString(props.getProperty("password"));
    }

    /**
     * PasswordCX^X̐B
     * @param className NX
     * @return CX^X
     */
    private static Password createPasswordInstance(String className) {
        if (!StringClass.isBlank(className)) {
            try {
                return (Password)DynamicLoader.newInstance(className);
            } catch (DynamicLoadingException ex) {
                log.warn("", ex);
            }
        }
        return new PlainTextPassword();
    }

    /**
     * Connector̐(Rs[RXgN^)B
     * @param id ID
     * @param src Rs[̃CX^X
     */
    public Connector(String id, Connector src) {
        this(id, new Properties(src.props));
    }

    /**
     * ID̎擾B
     * @return ID
     */
    public String getId() {
        return id;
    }

    /**
     * ̂̎擾B
     * @return 
     */
    public String getName() {
        return props.getProperty("name");
    }

    /**
     * classpath̎擾B
     * @return classpath
     */
    public String getClasspath() {
        return props.getProperty("classpath", "");
    }

    /**
     * driver̎擾B
     * @return driver
     */
    public String getDriver() {
        return props.getProperty("driver");
    }

    /**
     * url̎擾B
     * @return url
     */
    public String getUrl() {
        return props.getProperty("url");
    }

    /**
     * user̎擾B
     * @return user
     */
    public String getUser() {
        return props.getProperty("user");
    }

    /**
     * pX[hIuWFNg̎擾B
     * @return pX[hIuWFNg
     */
    public Password getPassword() {
        return password;
    }

    /**
     * readonly̎擾B
     * @return readonly Ȃ <code>true</code>
     */
    public boolean isReadOnly() {
        String s = props.getProperty("readonly");
        return Boolean.valueOf(s).booleanValue();
    }

    /**
     * rollback̎擾B
     * @return [obN@\gpȂ <code>true</code>
     */
    public boolean usesAutoRollback() {
        String s = props.getProperty("rollback");
        return Boolean.valueOf(s).booleanValue();
    }

    /**
     * vpeBIuWFNg̎擾B
     * @return vpeBIuWFNg
     */
    protected Properties getProperties() {
        return props;
    }

    /**
     * RlNV̎擾B
     * @return RlNV
     * @throws SQLException caANZXG[ꍇ
     */
    public Connection getConnection() throws SQLException {
        try {
            Driver driver = loadDriver(getDriver(), getClasspath());
            Properties p = new Properties();
            p.setProperty("user", getUser());
            p.setProperty("password", getPassword().getRowString());
            if (!driver.acceptsURL(getUrl())) {
                throw new SQLException("invalid url : " + getUrl());
            }
            if (log.isInfoEnabled()) {
                log.info("driver.connect start");
            }
            Connection conn = driver.connect(getUrl(), p);
            if (log.isInfoEnabled()) {
                log.info("driver.connect end");
            }
            if (conn == null) {
                throw new IllegalStateException("driver returned null");
            }
            return conn;
        } catch (DynamicLoadingException ex) {
            throw new SQLException(ex.toString());
        }
    }

    /**
     * JDBChCo[hB
     * @param className SCNX
     * @param classpath NXpX
     * @return JDBChCo
     */
    private static Driver loadDriver(String className, String classpath) {
        String[] paths = classpath.split(File.pathSeparator);
        List list = new ArrayList();
        for (int i = 0; i < paths.length; i++) {
            try {
                list.add(new File(paths[i]).toURL());
            } catch (MalformedURLException ex) {
                // ignore
            }
        }
        URL[] urls = (URL[])list.toArray(new URL[list.size()]);
        if (log.isInfoEnabled()) {
            log.info("driver.instantiate start");
        }
        Object driver = DynamicLoader.newInstance(className, urls);
        if (log.isInfoEnabled()) {
            log.info("driver.instantiate end");
        }
        return (Driver)driver;
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "Connector:" + id;
    }

}