package net.argius.logging;

import java.lang.reflect.*;

/**
 * Logger̃t@NgB
 */
public final class LoggerFactory {

    private static final NullLogger NULL_LOGGER = new NullLogger();
    private static final boolean enable = Boolean.getBoolean("net.argius.logging");
    private static final String fqcn = System.getProperty("net.argius.logging.class");
    private static final String level = System.getProperty("net.argius.logging.level", "INFO");

    /**
     * LoggerFactory̐B
     */
    private LoggerFactory() {
        // no instance
    }

    /**
     * Logger̎擾B
     * @return Logger
     */
    public static Logger getLogger() {
        return createLogger("");
    }

    /**
     * Logger̎擾B
     * @param targetName Ώۖ
     * @return Logger
     */
    public static Logger getLogger(String targetName) {
        return createLogger(targetName);
    }

    /**
     * Logger̎擾B
     * @param targetClass ΏۃNX
     * @return Logger
     */
    public static Logger getLogger(Class targetClass) {
        return createLogger(targetClass.getName());
    }

    /**
     * Logger̐B
     * @param targetName Ώۖ
     * @return Logger
     */
    private static Logger createLogger(String targetName) {
        if (enable) {
            Logger log;
            try {
                Class loggerClass = Class.forName(fqcn);
                Constructor ctor = loggerClass.getConstructor(new Class[]{String.class});
                log = (Logger)ctor.newInstance(new Object[]{targetName});
            } catch (Throwable th) {
                log = new StandardErrorOutputLogger(targetName);
            }
            log.setLevel(level);
            return log;
        }
        return NULL_LOGGER;
    }

}